/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.schedulers;

import br.com.oti.gesconsys.business.SchedulerClientService;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class ScheduledTasks {
    private Logger logger = LoggerFactory.getLogger(ScheduledTasks.class);
    TaskScheduler scheduler;
    private String tokenJwt;
    @Autowired
    private SchedulerClientService schedulerClient;
    Runnable refreshTokenTask = () -> {
        try {
            this.internalRefreshToken();
        }
        catch (Exception e) {
            this.logger.error("refreshTokenTask.exc={}", (Object)e.getMessage());
        }
    };
    Runnable deleteBloqueiosAntigosTask = () -> {
        try {
            this.schedulerClient.deleteBloqueiosAntigos(this.tokenJwt).block();
        }
        catch (Exception e) {
            this.logger.error("deleteBloqueiosAntigos.exc={}", (Object)e.getMessage());
        }
    };
    Runnable deleteEnsaiosVaziosTask = () -> {
        try {
            this.schedulerClient.deleteEnsaiosVazios(this.tokenJwt).block();
        }
        catch (Exception e) {
            this.logger.error("deleteEnsaiosVazios.exc={}", (Object)e.getMessage());
        }
    };
    Runnable deleteCachedAnexosTask = () -> {
        try {
            this.schedulerClient.deleteCachedAnexos(this.tokenJwt).block();
        }
        catch (Exception e) {
            this.logger.error("deleteCachedAnexosTask.exc={}", (Object)e.getMessage());
        }
    };
    Runnable cleanupCachedMailTask = () -> {
        try {
            this.schedulerClient.cleanupCachedMail(this.tokenJwt).block();
        }
        catch (Exception e) {
            this.logger.error("cleanupCachedMail.exc={}", (Object)e.getMessage());
        }
    };
    Runnable cleanupOpenSessionsTask = () -> {
        try {
            this.schedulerClient.cleanupOpenSessions(this.tokenJwt).block();
        }
        catch (Exception e) {
            this.logger.error("cleanupOpenSessions.exc={}", (Object)e.getMessage());
        }
    };
    Runnable sendMailTask = () -> {
        try {
            this.schedulerClient.sendMails(this.tokenJwt).block();
        }
        catch (Exception e) {
            this.logger.error("sendMaiTask.exc={}", (Object)e.getMessage());
        }
    };
    Runnable executeDailyCorrespTask = () -> {
        try {
            this.logger.debug("Starting executeDailyCorrespTask JOB...");
            this.schedulerClient.executeDailyMailCorresp(this.tokenJwt).block();
        }
        catch (Exception e) {
            this.logger.error("executeDailyCorrespTask.exc={}", (Object)e.getMessage());
        }
    };
    Runnable executeDailyLicencasTask = () -> {
        try {
            this.logger.debug("Starting executeDailyLicencasTask JOB...");
            this.schedulerClient.executeDailyMailLicencas(this.tokenJwt).block();
        }
        catch (Exception e) {
            this.logger.error("executeDailyLicencasTask.exc={}", (Object)e.getMessage());
        }
    };
    Runnable executeDailyObrigacaoTask = () -> {
        try {
            this.logger.debug("Starting executeDailyObrigacaoTask JOB...");
            this.schedulerClient.executeDailyMailObrigacoes(this.tokenJwt).block();
        }
        catch (Exception e) {
            this.logger.error("executeDailyObrigacaoTask.exc={}", (Object)e.getMessage());
        }
    };
    Runnable executeDailyRegistroUsuarioEquipeTask = () -> {
        try {
            this.logger.debug("Starting executeDailyRegistroUsuarioEquipeTask JOB...");
            this.schedulerClient.executeDailyRegistroUsuarioEquipe(this.tokenJwt).block();
        }
        catch (Exception e) {
            this.logger.error("executeDailyRegistroUsuarioEquipeTask.exc={}", (Object)e.getMessage());
        }
    };
    Runnable executeGedUuidTask = () -> {
        try {
            this.logger.debug("Starting executeGedUuidTask JOB ...");
            this.schedulerClient.generateUuid(this.tokenJwt).block();
        }
        catch (Exception e) {
            this.logger.error("executeGedUuidTask.exc={}", (Object)e.getMessage());
        }
    };
    Runnable fillFilesGedTask = () -> {
        try {
            this.logger.debug("Starting fillFilesGedTask JOB ...");
            this.schedulerClient.fillGedFiles(this.tokenJwt).block();
        }
        catch (Exception e) {
            this.logger.error("fillFilesGedTask.exc={}", (Object)e.getMessage());
        }
    };
    Runnable fillResumoCorrespTask = () -> {
        try {
            this.logger.debug("Starting fillResumoCorrespTask JOB ...");
            this.schedulerClient.fillResumoCorresp(this.tokenJwt).block();
        }
        catch (Exception e) {
            this.logger.error("fillResumoCorrespTask.exc={}", (Object)e.getMessage());
        }
    };
    Runnable executeMonthlyObrigacaoTask = () -> {
        try {
            this.logger.debug("Starting executeObrigacaoMonthlyTask JOB...");
            this.schedulerClient.executeMonthlyMailObrigacoes(this.tokenJwt).block();
        }
        catch (Exception e) {
            this.logger.error("executeMonthlyObrigacaoTask.exc={}", (Object)e.getMessage());
        }
    };
    Runnable executePrazoCorrespondenciaTask = () -> {
        try {
            this.schedulerClient.updatePrazoCorrespondencia(this.tokenJwt).block();
        }
        catch (Exception e) {
            this.logger.error("executePrazoCorrespondenciaTask.exc={}", (Object)e.getMessage());
        }
    };
    Runnable executePrazoObrigacaoTask = () -> {
        try {
            this.schedulerClient.updatePrazoObrigacao(this.tokenJwt).block();
        }
        catch (Exception e) {
            this.logger.error("executePrazoObrigacaoTask.exc={}", (Object)e.getMessage());
        }
    };
    Runnable executePrazoRacTask = () -> {
        try {
            this.schedulerClient.updatePrazoRacs(this.tokenJwt).block();
        }
        catch (Exception e) {
            this.logger.error("executePrazoRacTask.exc={}", (Object)e.getMessage());
        }
    };
    Runnable updateDadosIbgeTask = () -> {
        try {
            this.logger.debug("Starting executeUpdateDadosIbge JOB...");
            this.schedulerClient.updateDadosIbge(this.tokenJwt);
        }
        catch (Exception e) {
            this.logger.error("updateDadosIbgeTask.exc={}", (Object)e.getMessage());
        }
    };
    Runnable updateIndicadoresRodoviasTask = () -> {
        try {
            this.logger.debug("Starting executeIndicadoresRodovia JOB...");
            this.schedulerClient.updateIndicadoresRodovias(this.tokenJwt);
        }
        catch (Exception e) {
            this.logger.error("updateIndicadoresRodoviasTask.exc={}", (Object)e.getMessage());
        }
    };
    Runnable updateUsuariosInativosSSOTask = () -> {
        try {
            this.logger.debug("Starting updateUsuariosInativosSSO JOB...");
            this.schedulerClient.updateUsuariosInativosSSO(this.tokenJwt);
        }
        catch (Exception e) {
            this.logger.error("updateUsuariosInativosSSOTask.exc={}", (Object)e.getMessage());
        }
    };

    public ScheduledTasks(TaskScheduler scheduler) {
        this.logger.debug("Iniciando tarefas agendadas...");
        this.scheduler = scheduler;
    }

    @PostConstruct
    public void init() {
        this.internalRefreshToken();
        this.prepareCronjobs();
    }

    private void prepareCronjobs() {
        this.scheduler.schedule(this.refreshTokenTask, (Trigger)new CronTrigger("0 0 * * * *"));
        this.scheduler.schedule(this.deleteBloqueiosAntigosTask, (Trigger)new CronTrigger("0 0/1 * * * *"));
        this.scheduler.schedule(this.deleteCachedAnexosTask, (Trigger)new CronTrigger("0 0/1 * * * *"));
        this.scheduler.schedule(this.cleanupCachedMailTask, (Trigger)new CronTrigger("0 0/2 * * * *"));
        this.scheduler.schedule(this.cleanupOpenSessionsTask, (Trigger)new CronTrigger("0 0/5 * * * *"));
        this.scheduler.schedule(this.executeGedUuidTask, (Trigger)new CronTrigger("0 0/1 * * * *"));
        this.scheduler.schedule(this.fillResumoCorrespTask, (Trigger)new CronTrigger("0 0/3 * * * *"));
        this.scheduler.schedule(this.fillFilesGedTask, (Trigger)new CronTrigger("0 0/2 * * * *"));
        this.scheduler.schedule(this.updateUsuariosInativosSSOTask, (Trigger)new CronTrigger("0 0/5 * * * *"));
    }

    private void internalRefreshToken() {
        this.logger.debug("Gerando token JWT...");
        this.tokenJwt = this.schedulerClient.refreshToken();
    }
}

