/*
 * Decompiled with CFR 0.152.
 */
package br.com.pavesys.spring.security;

import br.com.pavesys.beans.Usuario;
import br.com.pavesys.beans.UsuarioSessao;
import br.com.pavesys.beans.dao.UsuarioSessaoDAO;
import br.com.pavesys.services.TokenService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class SecurityFilter
extends OncePerRequestFilter {
    @Autowired
    private TokenService tokenService;
    @Autowired
    private UsuarioSessaoDAO usuarioSessaoDAO;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String username;
        String token = this.recoverToken(request);
        if (token != null && (username = this.tokenService.validateToken(token)) != null && !username.isEmpty()) {
            Optional activeSession = this.usuarioSessaoDAO.findByTokenAndDatHorLogoutIsNull(token);
            if (activeSession.isPresent()) {
                Usuario user = ((UsuarioSessao)activeSession.get()).getUsuario();
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user, null, user.getAuthorities());
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            } else {
                response.setStatus(401);
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String recoverToken(HttpServletRequest request) {
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || !authHeader.startsWith("Bearer ")) {
            return null;
        }
        return authHeader.replace("Bearer ", "");
    }
}

