/*
 * Decompiled with CFR 0.152.
 */
package br.com.pavesys.services;

import br.com.pavesys.beans.Usuario;
import br.com.pavesys.beans.dao.UsuarioDAO;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    @Autowired
    UsuarioDAO usuarioDAO;
    @Value(value="${api.security.token.expiration}")
    private Integer tokenExpirationTime;
    @Value(value="${api.security.token.secret}")
    private String secret;

    public String generateToken(Usuario usuario) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)this.secret);
            return JWT.create().withIssuer("irap-backend").withSubject(usuario.getUsername()).withExpiresAt(this.generateTokenExpirationDate()).sign(algorithm);
        }
        catch (JWTCreationException exception) {
            throw new RuntimeException("Error while creating token", exception);
        }
    }

    public String validateToken(String token) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)this.secret);
            return JWT.require((Algorithm)algorithm).withIssuer("irap-backend").build().verify(token).getSubject();
        }
        catch (JWTVerificationException exception) {
            return "";
        }
    }

    private Instant generateTokenExpirationDate() {
        return LocalDateTime.now().plusHours(this.tokenExpirationTime.intValue()).toInstant(ZoneOffset.of("-03:00"));
    }
}

