/*
 * Decompiled with CFR 0.152.
 */
package br.com.pavesys.services;

import br.com.pavesys.beans.Usuario;
import br.com.pavesys.beans.UsuarioSessao;
import br.com.pavesys.beans.dao.UsuarioSessaoDAO;
import jakarta.transaction.Transactional;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SessaoService {
    @Autowired
    private UsuarioSessaoDAO usuarioSessaoDAO;

    public Optional<UsuarioSessao> getActiveSessionById(Integer userId) {
        return this.usuarioSessaoDAO.findActiveSessionByUserId(userId);
    }

    @Transactional
    public UsuarioSessao createSession(Usuario usuario, String token) {
        Optional activeSession = this.getActiveSessionById(usuario.getId());
        activeSession.ifPresent(sessao -> {
            sessao.setDatHorLogout(LocalDateTime.now());
            this.usuarioSessaoDAO.save(sessao);
        });
        UsuarioSessao session = new UsuarioSessao();
        session.setUsuario(usuario);
        session.setDatHorLogin(LocalDateTime.now());
        session.setToken(token);
        return (UsuarioSessao)this.usuarioSessaoDAO.save((Object)session);
    }

    public void closeSession(String token) {
        Integer userId = this.usuarioSessaoDAO.findUserIdFromActiveSessionByToken(token);
        Optional activeSession = this.getActiveSessionById(userId);
        activeSession.ifPresent(sessao -> {
            sessao.setDatHorLogout(LocalDateTime.now());
            this.usuarioSessaoDAO.save(sessao);
        });
    }
}

