/*
 * Decompiled with CFR 0.152.
 */
package br.com.pavesys.services;

import br.com.pavesys.beans.Usuario;
import br.com.pavesys.beans.UsuarioRole;
import br.com.pavesys.beans.UsuarioSessao;
import br.com.pavesys.beans.UsuarioStatus;
import br.com.pavesys.beans.VO.AutenticacaoRequestVO;
import br.com.pavesys.beans.VO.AutenticacaoResponseVO;
import br.com.pavesys.beans.VO.LogoutRequestVO;
import br.com.pavesys.beans.VO.SessionCheckRequestVO;
import br.com.pavesys.beans.ViaSegura;
import br.com.pavesys.beans.dao.UsuarioSessaoDAO;
import br.com.pavesys.exceptions.BusinessException;
import br.com.pavesys.services.SessaoService;
import br.com.pavesys.services.TokenService;
import java.time.LocalDate;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class AuthenticationService {
    private Logger log = LoggerFactory.getLogger(AuthenticationService.class);
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private UsuarioSessaoDAO usuarioSessaoDAO;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private SessaoService sessaoService;

    public ResponseEntity loginUser(AutenticacaoRequestVO data) {
        this.log.debug("Iniciando login no service para username={}", (Object)data.getUsername());
        UsernamePasswordAuthenticationToken usernamePassword = new UsernamePasswordAuthenticationToken((Object)data.getUsername(), (Object)data.getPassword());
        Authentication auth = this.authenticationManager.authenticate((Authentication)usernamePassword);
        this.log.debug("Username e password autenticados com sucesso...");
        Usuario usuario = (Usuario)auth.getPrincipal();
        if (usuario.getDatExpiracao() != null && usuario.getDatExpiracao().isBefore(LocalDate.now())) {
            usuario.setStatus(UsuarioStatus.EXPIRADO);
            this.log.debug("Problema ao realizar login: Usu\u00e1rio est\u00e1 EXPIRADO.");
            return ResponseEntity.badRequest().body((Object)"Usu\u00e1rio expirado");
        }
        if (usuario.getStatus() == UsuarioStatus.SUSPENSO) {
            this.log.debug("Problema ao realizar login: Usu\u00e1rio est\u00e1 SUSPENSO.");
            return ResponseEntity.badRequest().body((Object)"Usu\u00e1rio suspenso");
        }
        try {
            String token = this.tokenService.generateToken(usuario);
            UsuarioRole role = usuario.getRole();
            ViaSegura viaSegura = usuario.getViaSegura();
            Integer id = usuario.getId();
            this.log.debug("Gerando token e captando cargo do usu\u00e1rio...");
            this.sessaoService.createSession(usuario, token);
            this.log.debug("Usu\u00e1rio de username={} e token={} logado com sucesso", (Object)data.getUsername(), (Object)token);
            return ResponseEntity.ok((Object)new AutenticacaoResponseVO(token, role, viaSegura, id));
        }
        catch (BusinessException exception) {
            this.log.error("Erro ao logar usu\u00e1rio", (Throwable)exception);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exception.getMessage());
        }
    }

    public ResponseEntity logoutUser(LogoutRequestVO data) {
        Optional usuarioSessaoOpt = this.usuarioSessaoDAO.findLastSessionByToken(data.getToken());
        this.log.debug("Realizando logout no usu\u00e1rio {}...", (Object)((UsuarioSessao)usuarioSessaoOpt.get()).getUsuario().getUsername());
        if (usuarioSessaoOpt.isEmpty()) {
            this.log.debug("Problema ao realizar logout: N\u00e3o existem sess\u00f5es para este usu\u00e1rio");
            return ResponseEntity.badRequest().build();
        }
        this.log.debug("Fechando sess\u00e3o do usu\u00e1rio...");
        this.sessaoService.closeSession(data.getToken());
        this.log.debug("Logout realizado com sucesso para o usu\u00e1rio {}", (Object)((UsuarioSessao)usuarioSessaoOpt.get()).getUsuario().getUsername());
        return ResponseEntity.ok().build();
    }

    public ResponseEntity sessionCheck(SessionCheckRequestVO data) {
        this.log.debug("Checando sess\u00e3o do usu\u00e1rio...");
        Optional usuarioSessaoOpt = this.usuarioSessaoDAO.findLastSessionByToken(data.getToken());
        if (usuarioSessaoOpt.isEmpty()) {
            this.log.debug("Falha no session-check: Usuario nao encontrado");
            return ResponseEntity.notFound().build();
        }
        this.log.debug("Recuperando token da ultima sessao do usuario...");
        String lastSessionToken = ((UsuarioSessao)usuarioSessaoOpt.get()).getToken();
        if (!lastSessionToken.equals(data.getToken())) {
            this.log.debug("Falha no session-check: O token enviado est\u00e1 incorreto");
            return ResponseEntity.badRequest().build();
        }
        this.log.debug("A sess\u00e3o do usu\u00e1rio {} est\u00e1 ativa", (Object)((UsuarioSessao)usuarioSessaoOpt.get()).getUsuario().getUsername());
        return ResponseEntity.ok((Object)true);
    }
}

