/*
 * Decompiled with CFR 0.152.
 */
package br.com.pavesys.services;

import br.com.pavesys.beans.Usuario;
import br.com.pavesys.beans.UsuarioRole;
import br.com.pavesys.beans.UsuarioStatus;
import br.com.pavesys.beans.VO.ListarUsuariosResponseVO;
import br.com.pavesys.beans.VO.RenewExpirationRequestVO;
import br.com.pavesys.beans.VO.TrocaDeCargoRequestVO;
import br.com.pavesys.beans.VO.TrocaDePermissaoViaSeguraRequestVO;
import br.com.pavesys.beans.VO.TrocaDeSenhaByAdminRequestVO;
import br.com.pavesys.beans.VO.UsuarioRegistroRequestVO;
import br.com.pavesys.beans.ViaSegura;
import br.com.pavesys.beans.dao.UsuarioDAO;
import br.com.pavesys.beans.dao.UsuarioSessaoDAO;
import br.com.pavesys.exceptions.BusinessException;
import br.com.pavesys.rests.AdminRestServices;
import jakarta.transaction.Transactional;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class AdminServices {
    @Autowired
    private UsuarioDAO usuarioDAO;
    @Autowired
    private UsuarioSessaoDAO usuarioSessaoDAO;
    @Autowired
    private PasswordEncoder passwordEncoder;
    private static final Logger logger = LoggerFactory.getLogger(AdminRestServices.class);

    public ResponseEntity registerUser(UsuarioRegistroRequestVO data) throws ResponseStatusException {
        logger.debug("Iniciando registro para o username {}", (Object)data.getUsername());
        if (this.usuarioDAO.findByUsername(data.getUsername()) != null) {
            logger.debug("Tentativa de registro falhou - username j\u00e1 registrado: {}", (Object)data.getUsername());
            return ResponseEntity.badRequest().body((Object)"J\u00e1 existe um usu\u00e1rio registrado com este username.");
        }
        if (this.usuarioDAO.findByEmail(data.getEmail()) != null) {
            logger.debug("Tentativa de registro falhou - email j\u00e1 registrado: {}", (Object)data.getEmail());
            return ResponseEntity.badRequest().body((Object)"J\u00e1 existe um usu\u00e1rio registrado com este email.");
        }
        if (data.getPassword().length() < 8) {
            logger.debug("Tentativa de registro falhou - a senha possui menos de 8 caracteres");
            return ResponseEntity.badRequest().body((Object)"Sua senha deve ter no minimo 8 caracteres");
        }
        if (data.getDatExpiracao() != null && data.getDatExpiracao().isBefore(LocalDate.now())) {
            logger.debug("Tentativa de registro falhou - a data de expira\u00e7\u00e3o definida ({}) \u00e9 menor que a data atual ({})", (Object)data.getDatExpiracao(), (Object)LocalDate.now());
            return ResponseEntity.badRequest().body((Object)"A data de expira\u00e7\u00e3o n\u00e3o pode ser uma data passada.");
        }
        try {
            String encryptedPassword = this.passwordEncoder.encode((CharSequence)data.getPassword());
            Usuario newUser = new Usuario(data.getUsername(), data.getEmail(), data.getEmpresa(), encryptedPassword, data.getDatExpiracao(), data.getViaSegura(), data.getRole());
            newUser.setStatus(UsuarioStatus.ATIVO);
            logger.debug("Registrando novo usu\u00e1rio: username={} e role={}", (Object)data.getUsername(), (Object)data.getRole());
            this.usuarioDAO.save((Object)newUser);
            logger.debug("Usu\u00e1rio salvo com sucesso no banco de dados!");
            return ResponseEntity.ok((Object)"Usu\u00e1rio criado com sucesso");
        }
        catch (BusinessException exception) {
            logger.error("Erro ao registrar usu\u00e1rio", (Throwable)exception);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exception.getMessage());
        }
    }

    public ResponseEntity changeUserRole(TrocaDeCargoRequestVO data) {
        logger.debug("Iniciando a altera\u00e7\u00e3o de cargo para o usu\u00e1rio de id {} e role atual: ", (Object)data.getId(), (Object)data.getRole());
        if (data.getId() == null) {
            logger.debug("Tentativa de altera\u00e7\u00e3o de cargo falhou: O ID do usu\u00e1rio registrado n\u00e3o pode ser nulo");
            return ResponseEntity.badRequest().body((Object)"O ID do usu\u00e1rio n\u00e3o pode ser nulo.");
        }
        if (data.getRole() == null) {
            logger.debug("Tentativa de altera\u00e7\u00e3o de cargo falhou: O role passado n\u00e3o pode ser nulo");
            return ResponseEntity.badRequest().body((Object)"\u00c9 necess\u00e1rio passar um cargo para realizar a altera\u00e7\u00e3o.");
        }
        Optional usuarioOpt = this.usuarioDAO.findById((Object)data.getId());
        if (usuarioOpt.isEmpty()) {
            logger.debug("Tentativa de altera\u00e7\u00e3o de cargo falhou: Usu\u00e1rio de id {} n\u00e3o foi encontrado no banco de dados", (Object)data.getId());
            return ResponseEntity.notFound().build();
        }
        try {
            UsuarioRole newRole = data.getRole();
            Usuario usuario = (Usuario)usuarioOpt.get();
            if (usuario.getRole() == newRole) {
                logger.debug("O usu\u00e1rio j\u00e1 possui o cargo {}", (Object)data.getRole());
                return ResponseEntity.badRequest().body((Object)"O usu\u00e1rio j\u00e1 possui este cargo!");
            }
            usuario.setRole(newRole);
            logger.debug("Alterando cargo do usu\u00e1rio: ID={} para role={}", (Object)data.getId(), (Object)data.getRole());
            this.usuarioDAO.save((Object)usuario);
            logger.debug("Cargo do usu\u00e1rio de ID={} alterado com sucesso para role{}", (Object)data.getId(), (Object)data.getRole());
            return ResponseEntity.ok((Object)("Cargo do usu\u00e1rio de ID: " + usuario.getId() + " e USERNAME: " + usuario.getUsername() + " alterado com sucesso para " + String.valueOf(usuario.getRole()) + "."));
        }
        catch (BusinessException exception) {
            logger.error("Erro ao alterar cargo do usu\u00e1rio", (Throwable)exception);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exception.getMessage());
        }
    }

    public ResponseEntity changeViaSeguraAccess(TrocaDePermissaoViaSeguraRequestVO data) {
        logger.debug("Iniciando a altera\u00e7\u00e3o de cargo para o usu\u00e1rio de id {} e acesso ViaSegura atual: ", (Object)data.getId(), (Object)data.getViaSegura());
        if (data.getId() == null) {
            logger.debug("Tentativa de altera\u00e7\u00e3o de permiss\u00e3o de acesso falhou: O ID do usu\u00e1rio registrado n\u00e3o pode ser nulo");
            return ResponseEntity.badRequest().body((Object)"O ID do usu\u00e1rio n\u00e3o pode ser nulo.");
        }
        if (data.getViaSegura() == null) {
            logger.debug("Tentativa de altera\u00e7\u00e3o de permiss\u00e3o de acesso falhou: O acesso passado n\u00e3o pode ser nulo");
            return ResponseEntity.badRequest().body((Object)"\u00c9 necess\u00e1rio passar uma permiss\u00e3o de acesso para realizar a altera\u00e7\u00e3o.");
        }
        Optional usuarioOpt = this.usuarioDAO.findById((Object)data.getId());
        if (usuarioOpt.isEmpty()) {
            logger.debug("Tentativa de altera\u00e7\u00e3o de permiss\u00e3o de acesso falhou: Usu\u00e1rio de id {} n\u00e3o foi encontrado no banco de dados", (Object)data.getId());
            return ResponseEntity.notFound().build();
        }
        try {
            ViaSegura viaSegura = data.getViaSegura();
            Usuario usuario = (Usuario)usuarioOpt.get();
            if (usuario.getViaSegura() == viaSegura) {
                logger.debug("O usu\u00e1rio j\u00e1 possui o acesso do viaSegura={}", (Object)data.getViaSegura());
                return ResponseEntity.badRequest().body((Object)"O usu\u00e1rio j\u00e1 possui este acesso!");
            }
            usuario.setViaSegura(viaSegura);
            logger.debug("Alterando a permiss\u00e3o do usu\u00e1rio: ID={} para acesso={}", (Object)data.getId(), (Object)data.getViaSegura());
            this.usuarioDAO.save((Object)usuario);
            logger.debug("Permiss\u00e3o do usu\u00e1rio de ID={} alterado com sucesso para acesso={}", (Object)data.getId(), (Object)data.getViaSegura());
            return ResponseEntity.ok((Object)("Acesso do usu\u00e1rio de ID: " + usuario.getId() + " e USERNAME: " + usuario.getUsername() + " alterado com sucesso para " + String.valueOf(usuario.getViaSegura()) + "."));
        }
        catch (BusinessException exception) {
            logger.error("Erro ao alterar cargo do usu\u00e1rio", (Throwable)exception);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exception.getMessage());
        }
    }

    public ResponseEntity changeUserPassword(TrocaDeSenhaByAdminRequestVO data) {
        logger.debug("Iniciando troca de senha para o ID={}", (Object)data.getId());
        if (data.getId() == null || data.getId().describeConstable().isEmpty()) {
            logger.debug("Tentativa de mudan\u00e7a de senha falhou: O id do usu\u00e1rio n\u00e3o pode ser nulo");
            return ResponseEntity.badRequest().body((Object)"O ID do usu\u00e1rio n\u00e3o pode ser nulo.");
        }
        if (data.getPassword() == null || data.getPassword().isBlank()) {
            logger.debug("Tentativa de mudan\u00e7a de senha falhou: A nova senha n\u00e3o pode ser nula");
            return ResponseEntity.badRequest().body((Object)"\u00c9 necess\u00e1rio passar uma senha para realizar a altera\u00e7\u00e3o.");
        }
        if (data.getPassword().length() < 8) {
            logger.debug("Tentativa de mudan\u00e7a de senha falhou: A nova senha deve conter no m\u00ednimo 8 caracteres");
            return ResponseEntity.badRequest().body((Object)"Sua senha deve ter no minimo 8 caracteres");
        }
        Optional usuarioOpt = this.usuarioDAO.findById((Object)data.getId());
        if (usuarioOpt.isEmpty()) {
            logger.debug("Tentativa de mudan\u00e7a de senha falhou: Usu\u00e1rio de ID={} n\u00e3o encontrado no banco de dados.", (Object)data.getId());
            return ResponseEntity.notFound().build();
        }
        try {
            logger.debug("Criptografando a senha...");
            String encryptedPassword = this.passwordEncoder.encode((CharSequence)data.getPassword());
            Usuario usuario = (Usuario)usuarioOpt.get();
            usuario.setPassword(encryptedPassword);
            logger.debug("Alterando senha do usu\u00e1rio {}...", (Object)((Usuario)usuarioOpt.get()).getUsername());
            this.usuarioDAO.save((Object)usuario);
            logger.debug("Altera\u00e7\u00e3o de senha realizada com sucesso para o usu\u00e1rio {}", (Object)((Usuario)usuarioOpt.get()).getUsername());
            return ResponseEntity.ok((Object)"Senha alterada com sucesso.");
        }
        catch (BusinessException exception) {
            logger.debug("Erro ao alterar senha do usu\u00e1rio", (Throwable)exception);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exception.getMessage());
        }
    }

    public ResponseEntity<List<ListarUsuariosResponseVO>> listUsers() {
        logger.debug("Inicializando listagem de usu\u00e1rios...");
        List usuarios = this.usuarioDAO.findAll();
        ArrayList<ListarUsuariosResponseVO> usuariosResponseVOList = new ArrayList<ListarUsuariosResponseVO>();
        try {
            for (Usuario usuario : usuarios) {
                Integer id = usuario.getId();
                Optional session = this.usuarioSessaoDAO.findLastLoginByUserId(id);
                LocalDateTime loginTime = session.map(s -> s.getDatHorLogin()).orElse(null);
                if (usuario.getDatExpiracao() != null && usuario.getDatExpiracao().isBefore(LocalDate.now())) {
                    usuario.setStatus(UsuarioStatus.EXPIRADO);
                }
                ListarUsuariosResponseVO usuariosResponseVO = new ListarUsuariosResponseVO(usuario.getId(), usuario.getUsername(), usuario.getEmpresa(), usuario.getEmail(), usuario.getRole(), usuario.getViaSegura(), usuario.getDatExpiracao(), loginTime, usuario.getStatus());
                usuariosResponseVOList.add(usuariosResponseVO);
            }
            if (usuariosResponseVOList.isEmpty()) {
                logger.debug("Nenhum usu\u00e1rio encontrado no sistema.");
                return ResponseEntity.notFound().build();
            }
            logger.debug("Usu\u00e1rios listados com sucesso!");
            return ResponseEntity.ok(usuariosResponseVOList);
        }
        catch (BusinessException exception) {
            logger.error("Erro ao listar usu\u00e1rios do sistmea", (Throwable)exception);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exception.getMessage());
        }
    }

    @Transactional
    public ResponseEntity deleteUser(Integer id) {
        logger.debug("Iniciando processo de delete para o ID={}", (Object)id);
        Optional usuarioOpt = this.usuarioDAO.findById((Object)id);
        if (usuarioOpt.isEmpty()) {
            logger.debug("N\u00e3o foi poss\u00edvel encontrar o ID={} no banco de dados.", (Object)id);
            return ResponseEntity.notFound().build();
        }
        try {
            logger.debug("Deletando sess\u00f5es do usu\u00e1rio...");
            this.usuarioSessaoDAO.deleteSessionsByUserId(id);
            logger.debug("Deletando usu\u00e1rio...");
            this.usuarioDAO.deleteById((Object)id);
            logger.debug("Usu\u00e1rio de ID={} deletado com sucesso do banco de dados juntamente com suas sess\u00f5es!");
            return ResponseEntity.ok((Object)"Usu\u00e1rio deletado com sucesso juntamente com suas sessoes!");
        }
        catch (BusinessException exception) {
            logger.error("Erro ao deletar usu\u00e1rio", (Throwable)exception);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exception.getMessage());
        }
    }

    public ResponseEntity suspendUser(Integer id) {
        logger.debug("Iniciando procedimento e suspens\u00e3o do usu\u00e1rio de ID={}", (Object)id);
        Usuario usuario = this.usuarioDAO.findById((Object)id).orElse(null);
        if (usuario == null) {
            logger.debug("Tentativa de suspens\u00e3o falhou: N\u00e3o foi poss\u00edvel encontrar o usu\u00e1rio no banco de dados ou o valor \u00e9 null");
            return ResponseEntity.notFound().build();
        }
        if (usuario.getStatus() == UsuarioStatus.SUSPENSO) {
            logger.debug("Tentativa de suspens\u00e3o falhou: O usu\u00e1rio de ID={} j\u00e1 est\u00e1 suspenso.", (Object)id);
            return ResponseEntity.badRequest().body((Object)"Este usu\u00e1rio j\u00e1 est\u00e1 suspenso");
        }
        try {
            logger.debug("Suspendendo usu\u00e1rio de ID={}...", (Object)id);
            usuario.setStatus(UsuarioStatus.SUSPENSO);
            this.usuarioDAO.save((Object)usuario);
            logger.debug("Usu\u00e1rio de ID={} suspenso com sucesso!", (Object)id);
            return ResponseEntity.ok((Object)"Usu\u00e1rio suspenso com sucesso");
        }
        catch (BusinessException exception) {
            logger.error("Erro ao suspender usu\u00e1rio", (Throwable)exception);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exception.getMessage());
        }
    }

    public ResponseEntity activateUser(Integer id) {
        logger.debug("Iniciando processo de reativa\u00e7\u00e3o para o ID={}", (Object)id);
        Usuario usuario = this.usuarioDAO.findById((Object)id).orElse(null);
        if (usuario == null) {
            logger.debug("Tentativa de reativa\u00e7\u00e3o falhou: n\u00e3o foi poss\u00edvel encontrar o usu\u00e1rio no banco de dados ou o valor \u00e9 null");
            return ResponseEntity.notFound().build();
        }
        if (usuario.getStatus() == UsuarioStatus.ATIVO) {
            logger.debug("Tentativa de reativa\u00e7\u00e3o falhou: o usu\u00e1rio de ID={} j\u00e1 se encontra como ATIVO", (Object)id);
            return ResponseEntity.badRequest().body((Object)"Este usu\u00e1rio j\u00e1 est\u00e1 ativo.");
        }
        try {
            logger.debug("Reativando usu\u00e1rio de ID={}", (Object)id);
            usuario.setStatus(UsuarioStatus.ATIVO);
            this.usuarioDAO.save((Object)usuario);
            logger.debug("Usu\u00e1rio de ID={} reativado com sucesso!", (Object)id);
            return ResponseEntity.ok((Object)"Usu\u00e1rio reativado com sucesso");
        }
        catch (BusinessException exception) {
            logger.error("Erro ao reativar usu\u00e1rio", (Throwable)exception);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exception.getMessage());
        }
    }

    public ResponseEntity renewUserExpiration(Integer id, RenewExpirationRequestVO data) {
        logger.debug("Inicializando renova\u00e7\u00e3o de data de expira\u00e7\u00e3o do usu\u00e1rio...");
        Usuario usuario = this.usuarioDAO.findById((Object)id).orElse(null);
        if (usuario == null) {
            logger.debug("Tentativa de renova\u00e7\u00e3o falhou: n\u00e3o foi poss\u00edvel encontrar o usu\u00e1rio no banco de dados ou o valor \u00e9 null");
            return ResponseEntity.notFound().build();
        }
        if (data.getExpDate().isBefore(LocalDate.now())) {
            logger.debug("Tentativa de renova\u00e7\u00e3o falhou: a data que voc\u00ea passou \u00e9 anterior a de hoje", (Object)id);
            return ResponseEntity.badRequest().body((Object)"Por favor, envie uma data v\u00e1lida.");
        }
        try {
            logger.debug("Renovando data de expira\u00e7\u00e3o do usu\u00e1rio de ID={}", (Object)id);
            usuario.setDatExpiracao(data.getExpDate());
            this.usuarioDAO.save((Object)usuario);
            logger.debug("Usu\u00e1rio de ID={} com data de expira\u00e7\u00e3o renovada para: {} com sucesso!", (Object)id, (Object)usuario.getDatExpiracao());
            return ResponseEntity.ok((Object)"Usu\u00e1rio com data de expira\u00e7\u00e3o renovada com sucesso");
        }
        catch (BusinessException exception) {
            logger.error("Erro ao renovar usu\u00e1rio", (Throwable)exception);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exception.getMessage());
        }
    }
}

