/*
 * Decompiled with CFR 0.152.
 */
package br.com.pavesys.rests;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/ping"})
public class PingRestServices {
    private static Logger logger = LoggerFactory.getLogger(PingRestServices.class);

    @GetMapping(produces={"application/json"})
    public ResponseEntity<String> echo() {
        logger.debug("Executando API ECHO");
        try {
            ObjectMapper mapper = new ObjectMapper();
            HashMap<String, String> serverMap = new HashMap<String, String>();
            DateTimeFormatter sdtf = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            serverMap.put("serverTime", sdtf.format(LocalDateTime.now()));
            String jsonData = mapper.writeValueAsString(serverMap);
            return new ResponseEntity((Object)jsonData, (HttpStatusCode)HttpStatus.OK);
        }
        catch (JsonProcessingException msg) {
            logger.error("msg", (Object)msg.getMessage());
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, msg.getMessage());
        }
    }
}

