/*
 * Decompiled with CFR 0.152.
 */
package br.com.pavesys.rests;

import br.com.pavesys.beans.VO.AutenticacaoRequestVO;
import br.com.pavesys.beans.VO.LogoutRequestVO;
import br.com.pavesys.beans.VO.SessionCheckRequestVO;
import br.com.pavesys.beans.VO.TokenTrocaDeSenhaRequestVO;
import br.com.pavesys.beans.VO.TrocaDeSenhaByUserRequestVO;
import br.com.pavesys.beans.VO.TrocaDeSenhaTokenRequestVO;
import br.com.pavesys.mail.EmailService;
import br.com.pavesys.services.AuthenticationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auth"})
public class AuthenticationRestServices {
    private Logger log = LoggerFactory.getLogger(AuthenticationRestServices.class);
    @Autowired
    private EmailService emailService;
    @Autowired
    private AuthenticationService authenticationService;

    @PostMapping(value={"/login"})
    public ResponseEntity login(@RequestBody AutenticacaoRequestVO data) {
        this.log.debug("Inicializando login no restServices");
        return this.authenticationService.loginUser(data);
    }

    @PostMapping(value={"/logout"})
    public ResponseEntity logout(@RequestBody LogoutRequestVO data) {
        this.log.debug("Inicializando logout no restServices");
        return this.authenticationService.logoutUser(data);
    }

    @PostMapping(value={"/session-check"})
    public ResponseEntity sessionCheck(@RequestBody SessionCheckRequestVO data) {
        this.log.debug("Inicializando session-check no restServices");
        return this.authenticationService.sessionCheck(data);
    }

    @PostMapping(value={"/resetPassword"})
    public ResponseEntity createTokenAndSendMail(@RequestBody TrocaDeSenhaTokenRequestVO data) {
        this.log.debug("Inicializando cria\u00e7\u00e3o de token para redefini\u00e7\u00e3o de senha e envio de email...");
        return this.emailService.createChangePasswordToken(data);
    }

    @PostMapping(value={"/validateResetPasswordToken"})
    public ResponseEntity validateTokenAndChangePassword(@RequestBody TokenTrocaDeSenhaRequestVO data) {
        return this.emailService.validateChangePasswordToken(data);
    }

    @PutMapping(value={"/changePasswordByToken"})
    public ResponseEntity changePasswordByToken(@RequestBody TrocaDeSenhaByUserRequestVO data) {
        return this.emailService.changeUserPassword(data);
    }
}

