/*
 * Decompiled with CFR 0.152.
 */
package br.com.pavesys.rests;

import br.com.pavesys.beans.VO.ListarUsuariosResponseVO;
import br.com.pavesys.beans.VO.RenewExpirationRequestVO;
import br.com.pavesys.beans.VO.TrocaDeCargoRequestVO;
import br.com.pavesys.beans.VO.TrocaDePermissaoViaSeguraRequestVO;
import br.com.pavesys.beans.VO.TrocaDeSenhaByAdminRequestVO;
import br.com.pavesys.beans.VO.UsuarioRegistroRequestVO;
import br.com.pavesys.services.AdminServices;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin"})
public class AdminRestServices {
    @Autowired
    private AdminServices adminServices;
    private static final Logger logger = LoggerFactory.getLogger(AdminRestServices.class);

    @PostMapping(value={"/register"})
    public ResponseEntity register(@RequestBody UsuarioRegistroRequestVO data) {
        return this.adminServices.registerUser(data);
    }

    @PutMapping(value={"/changeUserRole"})
    public ResponseEntity changeUserRole(@RequestBody TrocaDeCargoRequestVO data) {
        return this.adminServices.changeUserRole(data);
    }

    @PutMapping(value={"/changeUserViaSeguraAccess"})
    public ResponseEntity changeViaSeguraAccess(@RequestBody TrocaDePermissaoViaSeguraRequestVO data) {
        return this.adminServices.changeViaSeguraAccess(data);
    }

    @PutMapping(value={"/changeUserPassword"})
    public ResponseEntity changeUserPassword(@RequestBody TrocaDeSenhaByAdminRequestVO data) {
        return this.adminServices.changeUserPassword(data);
    }

    @GetMapping(value={"/list"})
    public ResponseEntity<List<ListarUsuariosResponseVO>> listUsers() {
        return this.adminServices.listUsers();
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity deleteUser(@PathVariable Integer id) {
        return this.adminServices.deleteUser(id);
    }

    @PutMapping(value={"/suspend/{id}"})
    public ResponseEntity suspendUser(@PathVariable Integer id) {
        return this.adminServices.suspendUser(id);
    }

    @PutMapping(value={"/activate/{id}"})
    public ResponseEntity activateUser(@PathVariable Integer id) {
        return this.adminServices.activateUser(id);
    }

    @PutMapping(value={"/renewExpiration/{id}"})
    public ResponseEntity renewUserExpiration(@PathVariable Integer id, @RequestBody RenewExpirationRequestVO data) {
        return this.adminServices.renewUserExpiration(id, data);
    }
}

