/*
 * Decompiled with CFR 0.152.
 */
package br.com.pavesys.mail;

import br.com.pavesys.beans.EsqueciMinhaSenha;
import br.com.pavesys.beans.TokenEsqueciMinhaSenhaStatus;
import br.com.pavesys.beans.Usuario;
import br.com.pavesys.beans.VO.TokenTrocaDeSenhaRequestVO;
import br.com.pavesys.beans.VO.TrocaDeSenhaByUserRequestVO;
import br.com.pavesys.beans.VO.TrocaDeSenhaTokenRequestVO;
import br.com.pavesys.beans.dao.EsqueciMinhaSenhaDAO;
import br.com.pavesys.beans.dao.UsuarioDAO;
import jakarta.transaction.Transactional;
import java.time.LocalDateTime;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class EmailService {
    private final Logger log = LoggerFactory.getLogger(EmailService.class);
    @Autowired
    private JavaMailSender emailSender;
    @Autowired
    EsqueciMinhaSenhaDAO esqueciMinhaSenhaDAO;
    @Autowired
    UsuarioDAO usuarioDAO;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Value(value="${spring.mail.username}")
    private String emailSenderUsername;

    public void sendSimpleMessage(String to, String subject, String text) {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setFrom(this.emailSenderUsername);
        message.setTo(to);
        message.setSubject(subject);
        message.setText(text);
        this.emailSender.send(message);
    }

    public ResponseEntity changeUserPassword(TrocaDeSenhaByUserRequestVO data) {
        this.log.debug("Inicializando troca de senha do usu\u00e1rio");
        EsqueciMinhaSenha esqueciMinhaSenha = this.esqueciMinhaSenhaDAO.findByTokenNovaSenha(data.getToken());
        if (esqueciMinhaSenha == null) {
            this.log.debug("N\u00e3o foi poss\u00edvel achar este token em nosso sistema.");
            return ResponseEntity.notFound().build();
        }
        if (esqueciMinhaSenha.getStatus() != TokenEsqueciMinhaSenhaStatus.ATIVO) {
            this.log.debug("Token j\u00e1 utilizado anteriormente.");
            return ResponseEntity.badRequest().body((Object)"Token j\u00e1 utilizado anteriormente");
        }
        if (esqueciMinhaSenha.getDatHorExpiracaoToken().isBefore(LocalDateTime.now())) {
            this.log.debug("Token j\u00e1 expirado.");
            return ResponseEntity.badRequest().body((Object)"Token j\u00e1 expirado.");
        }
        if (data.getPassword().length() < 8) {
            this.log.debug("Tentativa de mudan\u00e7a de senha falhou: A nova senha deve conter no m\u00ednimo 8 caracteres");
            return ResponseEntity.badRequest().body((Object)"Sua senha deve ter no minimo 8 caracteres");
        }
        Usuario usuario = esqueciMinhaSenha.getUsuario();
        this.log.debug("Criptografando nova senha...");
        String encryptedNewPassword = this.passwordEncoder.encode((CharSequence)data.getPassword());
        this.log.debug("Setando nova senha...");
        usuario.setPassword(encryptedNewPassword);
        this.usuarioDAO.save((Object)usuario);
        this.log.debug("Nova senha definida com sucesso!");
        esqueciMinhaSenha.setStatus(TokenEsqueciMinhaSenhaStatus.USADO);
        this.esqueciMinhaSenhaDAO.save((Object)esqueciMinhaSenha);
        this.log.debug("Status do token alterado para: UTILIZADO - impossibilitando-o de ser usado novamente");
        return ResponseEntity.ok((Object)"Senha alterada com sucesso!");
    }

    @Transactional
    public ResponseEntity createChangePasswordToken(TrocaDeSenhaTokenRequestVO data) {
        try {
            this.log.debug("Procurando usu\u00e1rio via email passado no rest...");
            Usuario usuario = this.usuarioDAO.findByEmail(data.getEmail());
            if (usuario == null) {
                this.log.debug("Usu\u00e1rio com o email {} n\u00e3o encontrado no sistema!", (Object)data.getEmail());
                return ResponseEntity.notFound().build();
            }
            this.log.debug("Deletando token antigo caso exista...");
            this.esqueciMinhaSenhaDAO.deleteByUserId(usuario.getId());
            this.log.debug("Gerando token...");
            LocalDateTime datHorExpiracaoToken = LocalDateTime.now().plusMinutes(30L);
            String token = this.givenUsingJava8_whenGeneratingRandomAlphanumericString_thenCorrect();
            this.esqueciMinhaSenhaDAO.save((Object)new EsqueciMinhaSenha(usuario, datHorExpiracaoToken, token, TokenEsqueciMinhaSenhaStatus.ATIVO));
            this.log.debug("Salvo no banco de dados: token de redefini\u00e7\u00e3o de senha, status do token e identificador do usu\u00e1rio");
            this.log.debug("Construindo o e-mail para envio do token...");
            String text = "Ol\u00e1, %s!\n\nRecebemos sua solicita\u00e7\u00e3o para redefinir sua senha. Aqui est\u00e1 o c\u00f3digo para redefini\u00e7\u00e3o:\n\nSeu c\u00f3digo de redefini\u00e7\u00e3o: %s\n\nEste c\u00f3digo \u00e9 v\u00e1lido por 30 minutos.\n\nSe voc\u00ea n\u00e3o solicitou esta redefini\u00e7\u00e3o, por favor, desconsidere esta mensagem.\n\nPara redefinir sua senha, use o c\u00f3digo acima no nosso sistema :)\n".formatted(usuario.getUsername(), token);
            this.log.debug("Enviando email...");
            this.sendSimpleMessage(data.getEmail(), "Redefini\u00e7\u00e3o de senha", text);
            this.log.debug("E-mail encaminhado com sucesso!");
            return ResponseEntity.ok().build();
        }
        catch (RuntimeException msg) {
            this.log.error(msg.getMessage());
            return ResponseEntity.badRequest().body((Object)msg.getMessage());
        }
    }

    public ResponseEntity validateChangePasswordToken(TokenTrocaDeSenhaRequestVO data) {
        this.log.debug("Inicializando valida\u00e7\u00e3o do token de redefini\u00e7\u00e3o de senha...");
        EsqueciMinhaSenha esqueciMinhaSenha = this.esqueciMinhaSenhaDAO.findByTokenNovaSenha(data.getToken());
        if (esqueciMinhaSenha == null) {
            this.log.debug("N\u00e3o foi poss\u00edvel achar este token em nosso sistema.");
            return ResponseEntity.notFound().build();
        }
        if (esqueciMinhaSenha.getStatus() != TokenEsqueciMinhaSenhaStatus.ATIVO) {
            this.log.debug("Token j\u00e1 utilizado anteriormente.");
            return ResponseEntity.badRequest().body((Object)"Token j\u00e1 utilizado anteriormente");
        }
        if (esqueciMinhaSenha.getDatHorExpiracaoToken().isBefore(LocalDateTime.now())) {
            this.log.debug("Token j\u00e1 expirado.");
            return ResponseEntity.badRequest().body((Object)"Token j\u00e1 expirado.");
        }
        this.log.debug("Token validado com sucesso!");
        return ResponseEntity.ok().build();
    }

    public String givenUsingJava8_whenGeneratingRandomAlphanumericString_thenCorrect() {
        int leftLimit = 48;
        int rightLimit = 122;
        int targetStringLength = 6;
        Random random = new Random();
        String generatedString = random.ints(leftLimit, rightLimit + 1).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(targetStringLength).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
        return generatedString;
    }
}

