/*
 * Decompiled with CFR 0.152.
 */
package br.com.pavesys.beans;

import br.com.pavesys.beans.UsuarioRole;
import br.com.pavesys.beans.UsuarioStatus;
import br.com.pavesys.beans.ViaSegura;
import com.fasterxml.jackson.annotation.JsonFormat;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

@Entity
@Table(name="usuario")
public class Usuario
implements UserDetails {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="oid_usuario")
    private Integer id;
    @Column(name="username", nullable=false)
    private String username;
    @Column(name="email", nullable=false, length=60)
    private String email;
    @Column(name="empresa", nullable=false)
    private String empresa;
    @Column(name="status", nullable=false)
    private UsuarioStatus status;
    @Column(name="via_segura", nullable=false)
    private ViaSegura viaSegura;
    @Column(name="dat_expiracao", nullable=true)
    @Temporal(value=TemporalType.DATE)
    @JsonFormat(pattern="yyyy-MM-dd")
    private LocalDate datExpiracao;
    @Column(name="password", nullable=false)
    private String password;
    @Column(name="role", nullable=false)
    private UsuarioRole role;

    public Usuario(String username, String email, String empresa, String password, LocalDate datExpiracao, ViaSegura viaSegura, UsuarioRole role) {
        this.username = username;
        this.email = email;
        this.empresa = empresa;
        this.password = password;
        this.datExpiracao = datExpiracao;
        this.viaSegura = viaSegura;
        this.role = role;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        if (this.role == UsuarioRole.ADMIN) {
            return List.of(new SimpleGrantedAuthority("ROLE_ADMIN"), new SimpleGrantedAuthority("ROLE_USER"));
        }
        return List.of(new SimpleGrantedAuthority("ROLE_USER"));
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Usuario)) {
            return false;
        }
        Usuario other = (Usuario)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$empresa = this.getEmpresa();
        String other$empresa = other.getEmpresa();
        if (this$empresa == null ? other$empresa != null : !this$empresa.equals(other$empresa)) {
            return false;
        }
        UsuarioStatus this$status = this.getStatus();
        UsuarioStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        ViaSegura this$viaSegura = this.getViaSegura();
        ViaSegura other$viaSegura = other.getViaSegura();
        if (this$viaSegura == null ? other$viaSegura != null : !this$viaSegura.equals(other$viaSegura)) {
            return false;
        }
        LocalDate this$datExpiracao = this.getDatExpiracao();
        LocalDate other$datExpiracao = other.getDatExpiracao();
        if (this$datExpiracao == null ? other$datExpiracao != null : !((Object)this$datExpiracao).equals(other$datExpiracao)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        UsuarioRole this$role = this.getRole();
        UsuarioRole other$role = other.getRole();
        return !(this$role == null ? other$role != null : !this$role.equals(other$role));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Usuario;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $empresa = this.getEmpresa();
        result = result * 59 + ($empresa == null ? 43 : $empresa.hashCode());
        UsuarioStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        ViaSegura $viaSegura = this.getViaSegura();
        result = result * 59 + ($viaSegura == null ? 43 : $viaSegura.hashCode());
        LocalDate $datExpiracao = this.getDatExpiracao();
        result = result * 59 + ($datExpiracao == null ? 43 : ((Object)$datExpiracao).hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        UsuarioRole $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Usuario(id=" + this.getId() + ", username=" + this.getUsername() + ", email=" + this.getEmail() + ", empresa=" + this.getEmpresa() + ", status=" + String.valueOf(this.getStatus()) + ", viaSegura=" + String.valueOf(this.getViaSegura()) + ", datExpiracao=" + String.valueOf(this.getDatExpiracao()) + ", password=" + this.getPassword() + ", role=" + String.valueOf(this.getRole()) + ")";
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getEmpresa() {
        return this.empresa;
    }

    @Generated
    public UsuarioStatus getStatus() {
        return this.status;
    }

    @Generated
    public ViaSegura getViaSegura() {
        return this.viaSegura;
    }

    @Generated
    public LocalDate getDatExpiracao() {
        return this.datExpiracao;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public UsuarioRole getRole() {
        return this.role;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setEmpresa(String empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setStatus(UsuarioStatus status) {
        this.status = status;
    }

    @Generated
    public void setViaSegura(ViaSegura viaSegura) {
        this.viaSegura = viaSegura;
    }

    @JsonFormat(pattern="yyyy-MM-dd")
    @Generated
    public void setDatExpiracao(LocalDate datExpiracao) {
        this.datExpiracao = datExpiracao;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setRole(UsuarioRole role) {
        this.role = role;
    }

    @Generated
    public Usuario() {
    }

    @Generated
    public Usuario(Integer id, String username, String email, String empresa, UsuarioStatus status, ViaSegura viaSegura, LocalDate datExpiracao, String password, UsuarioRole role) {
        this.id = id;
        this.username = username;
        this.email = email;
        this.empresa = empresa;
        this.status = status;
        this.viaSegura = viaSegura;
        this.datExpiracao = datExpiracao;
        this.password = password;
        this.role = role;
    }
}

