package br.com.pavesys.services;

import br.com.pavesys.beans.Usuario;
import br.com.pavesys.beans.UsuarioSessao;
import br.com.pavesys.beans.dao.UsuarioSessaoDAO;
import jakarta.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.Optional;

@Service
public class SessaoService {

    @Autowired
    private UsuarioSessaoDAO usuarioSessaoDAO;

    public Optional<UsuarioSessao> getActiveSessionById(Integer userId) {
        return usuarioSessaoDAO.findActiveSessionByUserId(userId);
    }

    @Transactional
    public UsuarioSessao createSession(Usuario usuario, String token) {

        var activeSession = getActiveSessionById(usuario.getId());

        activeSession.ifPresent(sessao -> {
            sessao.setDatHorLogout(LocalDateTime.now());
            usuarioSessaoDAO.save(sessao);
        });

        UsuarioSessao session = new UsuarioSessao();
        session.setUsuario(usuario);
        session.setDatHorLogin(LocalDateTime.now());
        session.setToken(token);

        return usuarioSessaoDAO.save(session);
    }

    public void closeSession(String token) {

        Integer userId = usuarioSessaoDAO.findUserIdFromActiveSessionByToken(token);

        var activeSession = getActiveSessionById(userId);

        activeSession.ifPresent(sessao -> {
            sessao.setDatHorLogout(LocalDateTime.now());
            usuarioSessaoDAO.save(sessao);
        });

    }
}

