package br.com.pavesys.rests;


import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;

@RestController
@RequestMapping("/api/ping")
public class PingRestServices {

    private static Logger logger = LoggerFactory.getLogger(PingRestServices.class);

    @GetMapping(produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<String> echo() {
        logger.debug("Executando API ECHO");
        try {
            var mapper = new ObjectMapper();
            var serverMap = new HashMap<String, Object>();
            var sdtf = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            serverMap.put("serverTime", sdtf.format(LocalDateTime.now()));

            var jsonData = mapper.writeValueAsString(serverMap);
            return new ResponseEntity<String>(jsonData, HttpStatus.OK);
        } catch (JsonProcessingException msg) {
            logger.error("msg", msg.getMessage());
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, msg.getMessage());
        }
    }

}
