package br.com.pavesys.rests;

import br.com.pavesys.beans.VO.*;
import br.com.pavesys.mail.EmailService;
import br.com.pavesys.services.AuthenticationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/auth")
public class AuthenticationRestServices {

    private Logger log = LoggerFactory.getLogger(AuthenticationRestServices.class);

    @Autowired
    private EmailService emailService;

    @Autowired
    private AuthenticationService authenticationService;

    @PostMapping("/login")
    public ResponseEntity login(@RequestBody AutenticacaoRequestVO data) {
        log.debug("Inicializando login no restServices");
        return authenticationService.loginUser(data);
    }

    @PostMapping("/logout")
    public ResponseEntity logout(@RequestBody LogoutRequestVO data) {
        log.debug("Inicializando logout no restServices");
        return authenticationService.logoutUser(data);
    }

    @PostMapping("/session-check")
    public ResponseEntity sessionCheck(@RequestBody SessionCheckRequestVO data) {
        log.debug("Inicializando session-check no restServices");
        return authenticationService.sessionCheck(data);
    }

    @PostMapping("/resetPassword")
    public ResponseEntity createTokenAndSendMail(@RequestBody TrocaDeSenhaTokenRequestVO data) {
        log.debug("Inicializando criação de token para redefinição de senha e envio de email...");
        return emailService.createChangePasswordToken(data);
    }

    @PostMapping("/validateResetPasswordToken")
    public ResponseEntity validateTokenAndChangePassword(@RequestBody TokenTrocaDeSenhaRequestVO data) {
        return emailService.validateChangePasswordToken(data);
    }

    @PutMapping("/changePasswordByToken")
    public ResponseEntity changePasswordByToken(@RequestBody TrocaDeSenhaByUserRequestVO data) {
        return emailService.changeUserPassword(data);
    }

}
