package br.com.pavesys.rests;

import br.com.pavesys.beans.VO.*;
import br.com.pavesys.services.AdminServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/admin")
public class AdminRestServices {

    @Autowired
    private AdminServices adminServices;

    private static final Logger logger = LoggerFactory.getLogger(AdminRestServices.class);

    @PostMapping("/register")
    public ResponseEntity register(@RequestBody UsuarioRegistroRequestVO data) {
        return adminServices.registerUser(data);
    }

    @PutMapping("/changeUserRole")
    public ResponseEntity changeUserRole(@RequestBody TrocaDeCargoRequestVO data) {
        return adminServices.changeUserRole(data);
    }

    @PutMapping("/changeUserViaSeguraAccess")
    public ResponseEntity changeViaSeguraAccess(@RequestBody TrocaDePermissaoViaSeguraRequestVO data) {
        return adminServices.changeViaSeguraAccess(data);
    }

    @PutMapping("/changeUserPassword")
    public ResponseEntity changeUserPassword(@RequestBody TrocaDeSenhaByAdminRequestVO data) {
        return adminServices.changeUserPassword(data);
    }

    @GetMapping("/list")
    public ResponseEntity<List<ListarUsuariosResponseVO>> listUsers() {
        return adminServices.listUsers();
    }

    @DeleteMapping("/delete/{id}")
    public ResponseEntity deleteUser(@PathVariable Integer id) {
        return adminServices.deleteUser(id);
    }

    @PutMapping("/suspend/{id}")
    public ResponseEntity suspendUser(@PathVariable Integer id) {
        return adminServices.suspendUser(id);
    }

    @PutMapping("/activate/{id}")
    public ResponseEntity activateUser(@PathVariable Integer id) {
        return adminServices.activateUser(id);
    }

    @PutMapping("/renewExpiration/{id}")
    public ResponseEntity renewUserExpiration(@PathVariable Integer id, @RequestBody RenewExpirationRequestVO data) {
        return adminServices.renewUserExpiration(id, data);
    }

}
