package br.com.pavesys.beans.dao;

import br.com.pavesys.beans.UsuarioSessao;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Optional;

@Repository
public interface UsuarioSessaoDAO extends JpaRepository<UsuarioSessao, Integer> {

    // caso futuramente precise listar sessao do usuario tambem
    @Query("SELECT s FROM UsuarioSessao s WHERE s.usuario.id = :usuarioId ORDER BY s.datHorLogin DESC LIMIT 1")
    Optional<UsuarioSessao> findLastLoginByUserId(@Param("usuarioId") Integer usuarioId);

    @Query("SELECT usuario.id FROM UsuarioSessao WHERE token = :token AND datHorLogout IS NULL")
    Integer findUserIdFromActiveSessionByToken(@Param("token") String token);

    // utilizando Optional para nao ficar traatando null pointers
    @Query("SELECT s FROM UsuarioSessao s WHERE s.usuario.id = :usuarioId AND s.datHorLogout IS NULL")
    Optional<UsuarioSessao> findActiveSessionByUserId(@Param("usuarioId") Integer usuarioId);

    @Query("SELECT s FROM UsuarioSessao s WHERE s.token = :token AND s.datHorLogout IS NULL")
    Optional<UsuarioSessao> findByTokenAndDatHorLogoutIsNull(@Param("token") String token);

    @Query("SELECT s FROM UsuarioSessao s WHERE s.token = :token AND s.datHorLogout IS NULL")
    Optional<UsuarioSessao> findLastSessionByToken(@Param("token") String token);

    @Modifying
    @Query("DELETE FROM UsuarioSessao s WHERE s.usuario.id = :usuarioId")
    Integer deleteSessionsByUserId(@Param("usuarioId") Integer usuarioId);


}
