package br.com.pavesys.beans;

import jakarta.persistence.*;
import lombok.Data;

import java.time.LocalDateTime;

@Entity
@Table(name="usuario_sessao")
@Data
public class UsuarioSessao {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "oid_sessao")
    private Integer sessaoID;

    @ManyToOne
    @JoinColumn(name = "oid_usuario", nullable = false)
    private Usuario usuario;

    @Column(name = "dat_hor_login")
    @Temporal(TemporalType.TIMESTAMP)
    private LocalDateTime datHorLogin;

    @Column(name = "dat_hor_logout")
    @Temporal(TemporalType.TIMESTAMP)
    private LocalDateTime datHorLogout;

    @Column(name = "token", nullable = false, unique = true)
    private String token;

}
