package br.com.pavesys.beans;

import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;

@Entity
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "esqueci_minha_senha")
public class EsqueciMinhaSenha {

    public EsqueciMinhaSenha(Usuario usuario, LocalDateTime datHorExpiracaoToken, String tokenNovaSenha, TokenEsqueciMinhaSenhaStatus status) {
        this.usuario = usuario;
        this.tokenNovaSenha = tokenNovaSenha;
        this.datHorExpiracaoToken = datHorExpiracaoToken;
        this.status = status;
    }

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Integer id;

    @OneToOne(targetEntity = Usuario.class, fetch = FetchType.EAGER)
    @JoinColumn(nullable = false, name = "oid_usuario")
    private Usuario usuario;

    @Column(name = "token_nova_senha", nullable = false)
    private String tokenNovaSenha;

    @Column(name = "token_status", nullable = false)
    private TokenEsqueciMinhaSenhaStatus status;

    @Column(name = "dat_hor_expiracao_token", nullable = false)
    @Temporal(TemporalType.TIMESTAMP)
    private LocalDateTime datHorExpiracaoToken;

}
