using Avalonia.Controls;
using Avalonia.Interactivity;
using Avalonia.Platform.Storage;
using CommunityToolkit.Mvvm.Input;
using pavesys_iRAP.Helper;
using pavesys_iRAP.ViewModels;
using System;
using System.IO;
using pavesys_iRAP.Business;
using System.Linq;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;




namespace pavesys_iRAP.Views
{
    public partial class ProjectsPageView : UserControl
    {
       
        public ProjectsPageView()
        {
            InitializeComponent();
          

        }

       
        private void DataGrid_DoubleTapped(object? sender, Avalonia.Input.TappedEventArgs e)
        {

        }

        private async void ImportZipClick(object? sender, Avalonia.Interactivity.RoutedEventArgs e)
        {
            // Get top level from the current control. Alternatively, you can use Window reference instead.
            var topLevel = TopLevel.GetTopLevel(this);

            // Start async operation to open the dialog.
            var files = await topLevel.StorageProvider.OpenFilePickerAsync(new FilePickerOpenOptions
            {
                Title = "Import Zip",
                AllowMultiple = false
            });

            var dataCtx = this.DataContext as ProjectsPageViewModel;
            if (files.Count >= 1)
            {
                if (files.ElementAt(0).Name.EndsWith(".zip"))
                {
                    var path = files[0].TryGetLocalPath();
                    dataCtx.ImportZip(path);
                }
                else 
                { 
                }
            }
        }

        //private void DataGrid_SelectionChanged(object? sender, Avalonia.Controls.SelectionChangedEventArgs e)
        //{
        //    var dataCtx = this.DataContext as ProjectsPageViewModel;
        //    var codings = CrudHelper.FindCodingsByProject((int)dataCtx.SelecProject.ProjectId, false);
        //    var sumMeter = 0D;
        //    bool[] codingHasAllPhotos= new bool[codings.Count];

        //    for (int i = 0; i < codings.Count - 1; i++) {
        //        var thisDiff = pavesys_iRAP.Business.InputXML.GetVincentyDistance((double)codings[i].Latitude, (double)codings[i].Longitude, (double)codings[i+1].Latitude, (double)codings[i+1].Longitude);
        //        sumMeter += thisDiff;
        //        if (thisDiff >= 99) {
        //            Debug.WriteLine($"{i} - {thisDiff}");
        //        }
        //        else {
        //            Debug.WriteLine($"{i} - {thisDiff} <<-------------------");
        //        }
        //    }
        //    Debug.WriteLine($"Lat {codings[0].Latitude} - Lon {codings[0].Longitude} Total = {sumMeter}");
        //}

        private string GetPythonExecutablePath()
        {
            // Construct the path to the bundled Python interpreter inside the application folder
            string pythonPath = Path.Combine(@"D:\OTI Software\Desktop\OTI\Repo iRAP", "ViaSeguraModule","scripts", "python.exe");
            return pythonPath;
        }

       

        private async void ImportCsvClick(object? sender, Avalonia.Interactivity.RoutedEventArgs e)
        {
            // Get top level from the current control. Alternatively, you can use Window reference instead.
            var topLevel = TopLevel.GetTopLevel(this);

            // Start async operation to open the dialog.
            var files = await topLevel.StorageProvider.OpenFilePickerAsync(new FilePickerOpenOptions
            {
                Title = "Import Csv",
                AllowMultiple = false
            });

            var dataCtx = this.DataContext as ProjectsPageViewModel;
            if (files.Count >= 1)
            {
                if (files.ElementAt(0).Name.EndsWith(".csv"))
                {
                    var path = files[0].TryGetLocalPath();
                    dataCtx.ImportZip(path);
                }
                else
                {
                }
            }
        }
    }
 }
