using Avalonia.Controls;
using Avalonia.Interactivity;
using Avalonia.Platform.Storage;
using pavesys_iRAP.Helper;
using pavesys_iRAP.ViewModels;
using System;
using System.IO;
using System.Linq;
using System.Reflection;

namespace pavesys_iRAP.Views
{
    public partial class NewProjectPageView : UserControl
    {
        private async void FolderButtonClick(object sender, RoutedEventArgs e)
        {
            var topLevel = TopLevel.GetTopLevel(this);
            var folder = await topLevel.StorageProvider.OpenFolderPickerAsync(new FolderPickerOpenOptions
            {
                Title = "XML Path",
                AllowMultiple = false
            });

            var DataCtx = this.DataContext as NewProjectPageViewModel;
            if (folder.Count > 0)
            {
                var path = folder[0].TryGetLocalPath();
                DataCtx.ProjPath = path;
                //Set the items in the xml picker combobox.
                var xmlFiles = Directory.EnumerateFiles(path, "*.xml", SearchOption.TopDirectoryOnly);
                //.Where(file => file.EndsWith(".xml"));
                if (xmlFiles.Count() > 0)
                {
                    DataCtx.XmlFiles = new(xmlFiles);
                    DataCtx.IsPhotosNotSelected = true;
                }
                else
                {
                    await DialogHelper.ShowOkDialog("Error", "NoXmlFile");

                }
            }
            
        }

        private async void CsvFileClick(object sender, RoutedEventArgs e)
        {
            var topLevel = TopLevel.GetTopLevel(this)!;

            var files = await topLevel.StorageProvider.OpenFilePickerAsync(new FilePickerOpenOptions
            {
                Title = "Pick csv file",
                AllowMultiple = false
            });

            var DataCtx = this.DataContext as NewProjectPageViewModel;
            if (files.Count > 0)
            {
                if (files.ElementAt(0).Name.EndsWith(".csv"))
                {
                    DataCtx.CsvFilePath = files.ElementAt(0).TryGetLocalPath();
                   // var lines = File.ReadAllLines(DataCtx.CsvFilePath);
                   // lines = lines.Skip(1).ToArray();
                   //var fieldinfo = typeof(NewProjectPageViewModel).GetField("ProjEndKM", BindingFlags.NonPublic | BindingFlags.Instance );
                   // fieldinfo.SetValue(DataCtx, Decimal.Parse(lines.Last().Split(";")[6]) + 0.1M);
                   // DataCtx.projInitialKM = Decimal.Parse(lines[0].Split(";")[6]);
                    //DataCtx.projEndKM = Decimal.Parse(lines.Last().Split(";")[6]) + 0.1M;
                }
                else
                {
                    await DialogHelper.ShowOkDialog("Error", "PickCsv");
                }
            }
        }
        public NewProjectPageView()
        {
            InitializeComponent();
           
        }

        private void TabControl_SelectionChanged(object? sender, Avalonia.Controls.SelectionChangedEventArgs e)
        {
            var DataCtx = this.DataContext as NewProjectPageViewModel;
            var tabControl = sender as TabControl;
            if (tabControl!.SelectedIndex == 0) {
                if((DataCtx?.CsvFilePath != null || DataCtx?.CsvFilePath != string.Empty)  && DataCtx is not null) 
                    DataCtx.CsvFilePath = string.Empty;
            }
        }
    }
}
