using Avalonia;
using Avalonia.Controls;
using HarfBuzzSharp;
using pavesys_iRAP.Business;
using pavesys_iRAP.Helper;
using pavesys_iRAP.ViewModels;
using Serilog;
using System;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Threading.Tasks;

namespace pavesys_iRAP.Views
{
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();

            //Used to initialize the application in a localized language
            Localizer.Localizer.Instance.LoadLanguage(ConfigManager.LoadConfig().GlobalConfig.Language);
            //Initialize the static class owner window as this.
            DialogHelper.OwnerControl = this;
            DialogHelper.window = this;

        }

        private bool _canClose = false;
        private async void Window_Closing(object? sender, Avalonia.Controls.WindowClosingEventArgs e)
        {
            try
            {
                if (!_canClose)
                {
                    
                    e.Cancel = true;

                    _canClose = await AuthModule.LogOut(); 

                    if (_canClose) { Closing -= Window_Closing; this.Close(); }
                }


                base.OnClosing(e);
            }
            catch (Exception ex) 
            {
                Log.Debug(ex, "Erro Logout");
            }
           
        }
    }
}