using Avalonia.Controls;
using Avalonia.Interactivity;
using Avalonia.Platform.Storage;
using pavesys_iRAP.ViewModels;
using System;
using System.Diagnostics;
using System.IO;
using System.Linq;

namespace pavesys_iRAP.Views
{
    public partial class EditProjectPageView : UserControl
    {
        private async void FolderButtonClick(object sender, RoutedEventArgs e)
        {
            var topLevel = TopLevel.GetTopLevel(this);
            
            var files = await topLevel.StorageProvider.OpenFilePickerAsync(new FilePickerOpenOptions
            {
                Title = "Open xlsx file",
                AllowMultiple = false
            });

            if (files.Count > 0) {
                var dt = this.DataContext as EditProjectPageViewModel;
                if (files.ElementAt(0).Name.EndsWith(".xlsx") || files.ElementAt(0).Name.EndsWith(".csv"))
                {
                    //Taking the substring after 8 characters because files.elements all have some rubbish 
                    // i.e:"file/// "
                    var path = files.ElementAt(0).TryGetLocalPath();
                    dt.XlsxFile = Path.GetFullPath(path);
                }
                else {
                }
                
            }

        }

        public EditProjectPageView()
        {
            InitializeComponent();
        }

    }
}
