using Avalonia.Controls;
using Avalonia.Interactivity;
using Avalonia.Platform.Storage;
using HarfBuzzSharp;
using pavesys_iRAP.Helper;
using pavesys_iRAP.Localizer;
using pavesys_iRAP.ViewModels;
using System;
using System.IO;

namespace pavesys_iRAP.Views
{
    public partial class ConfigPageView : UserControl
    {

        public ConfigPageView()
        {
            InitializeComponent();
        }

        private void OnLanguageChanged(object sender, SelectionChangedEventArgs args)
        {
            var cb = sender as ComboBox;
            string language = string.Empty;
            switch (cb.SelectedIndex) {
                case 0:
                    language = "pt-BR";
                    break; 
                case 1:
                    language = "en-US";
                    break; 
                case 2:
                    language = "es";
                    break;
            }
            Localizer.Localizer.Instance.LoadLanguage(language);
            var dataCtx = this.DataContext as ConfigPageViewModel;
            dataCtx.language = language;
            
        }

        private async void FolderButtonClick(object sender, RoutedEventArgs e)
        {
            var topLevel = TopLevel.GetTopLevel(this);
            var folder = await topLevel.StorageProvider.OpenFolderPickerAsync(new FolderPickerOpenOptions
            {
                Title = "Export Path",
                AllowMultiple = false
            });

            var DataCtx = this.DataContext as ConfigPageViewModel;
            if (folder.Count > 0)
            {
                var path = folder[0].TryGetLocalPath();
                DataCtx.ExportPath = path;
                
                
            }

        }

        private void ComboBox_SelectionChanged(object? sender, Avalonia.Controls.SelectionChangedEventArgs e)
        {
            var cb = sender as ComboBox;
            var stretchType = string.Empty;
            switch (cb.SelectedIndex)
            {
                case 0:
                    stretchType = "None";
                    break;
                case 1:
                    stretchType = "Fill";
                    break;
                case 2:
                    stretchType = "Uniform";
                    break;
                case 3:
                    stretchType = "UniformToFill";
                    break;
            }
            var dtx = this.DataContext as ConfigPageViewModel;
            dtx.currentStretch = stretchType;
        }
    }
}
