﻿using Avalonia.Notification;
using Avalonia.Layout;
using Avalonia.Media;
using CommunityToolkit.Mvvm.Input;
using System.Diagnostics;
using Avalonia.Controls;
using System;
using System.Collections.Generic;
using CommunityToolkit.Mvvm.ComponentModel;



namespace pavesys_iRAP.ViewModels
{

    public partial class MainPageViewModel : ViewModelBase
    {
        public bool hasMaximized;

        public bool isUserAdmin { get; set; } = false;
        public INotificationMessageManager Manager { get; set; } = new NotificationMessageManager();
        public List<INotificationMessage> Messages { get; } = new List<INotificationMessage>();
        [ObservableProperty]
        private bool isNotLoading = true;

        //Deactivates the buttons in main page while loading notification isn't dismissed manually in code.
        public void ShowLoadingQueryNotification()
        {
            IsNotLoading = false;
            Messages.Add(Manager.CreateMessage()
            .Accent("#F15B19") //ff1658b5
            .Background("#1658B5")
            .HasHeader(Localizer.Localizer.Instance["LoadingCodings"])
            .HasMessage(Localizer.Localizer.Instance["ChangeToCodings"])
            .Animates(true)
            .WithOverlay(new ProgressBar
            {
                VerticalAlignment = VerticalAlignment.Bottom,
                HorizontalAlignment = HorizontalAlignment.Stretch,
                Height = 3,
                BorderThickness = new Avalonia.Thickness(0),
                Foreground = new SolidColorBrush(Color.FromArgb(128, 255, 255, 255)),
                Background = Brushes.Transparent,
                IsIndeterminate = true,
                IsHitTestVisible = true
            })
            .Queue());
        }
        public void DismissLoadingNotification()
        {
            Messages.Clear();
            IsNotLoading = true;
        }

        public MainPageViewModel()
        {
        }
    }
}
