﻿using Avalonia.Media.Imaging;
using CommunityToolkit.Mvvm.ComponentModel;
using CommunityToolkit.Mvvm.Input;
using pavesys_iRAP.Business;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;


namespace pavesys_iRAP.ViewModels
{
    public record PhotoInfo(string fileName);
    public partial class ImageSelectionPageViewModel : ViewModelBase
    {
        public InputXML xmlLog;


        public bool isFirstPhotoSelected = false;
        public bool isLastPhotoSelected = false;
        [ObservableProperty]
        private Bitmap? mainImage;
        [ObservableProperty]
        private string firstImage;
        [ObservableProperty]
        private string lastImage;

        private int selectedIndex;
        public int SelectedIndex
        {
            get => selectedIndex;
            set
            {
                SetProperty(ref selectedIndex, value);
                OnPropertyChanged();
                loadPhoto();
            }
        }
        [ObservableProperty]
        private PhotoInfo selectedPhoto;
        public PhotoInfo tempSelectedPhoto;
        public int tempSelectedIndex;

        public string folderPath;
        public ObservableCollection<PhotoInfo> photoList { get; set; }
        public RelayCommand nextPhoto { get; }
        public RelayCommand prevPhoto { get; }
        public ImageSelectionPageViewModel()
        {
            photoList = new();
            nextPhoto = new(NextPhoto);
            prevPhoto = new(PreviousPhoto);
            SelectedIndex = 0;
        }
        public void loadPhotosList(string camPath)
        {
            folderPath = camPath;
            SelectedIndex = 0;
            string[] photos = Directory.GetFiles(camPath);
            foreach (string photo in photos)
            {
                photoList.Add(new PhotoInfo(Path.GetFileName(photo)));
            }
            if (!isFirstPhotoSelected)
                FirstImage = photoList.First().fileName;
            if (!isLastPhotoSelected)
                LastImage = photoList.Last().fileName;
            MainImage = new Bitmap(Path.Combine(camPath, photoList.First().fileName));
        }

        public void loadPhoto()
        {
            if (SelectedPhoto != null)
                MainImage = new Bitmap(Path.Combine(folderPath, SelectedPhoto.fileName));
        }

        private void NextPhoto()
        {

            if (SelectedIndex < photoList.Count)
            {
                SelectedIndex++;
                loadPhoto();
            }
        }

        private void PreviousPhoto()
        {
            if (SelectedIndex > 0)
            {
                SelectedIndex--;
                loadPhoto();
            }
        }

        public void SetFirstImage()
        {
            FirstImage = SelectedPhoto.fileName;
        }
        public void SetLastImage()
        {
            LastImage = SelectedPhoto.fileName;
        }
        public void SetTemps()
        {
            tempSelectedIndex = SelectedIndex;
            tempSelectedPhoto = SelectedPhoto;
        }
    }
}
