﻿using CommunityToolkit.Mvvm.ComponentModel;
using pavesys_iRAP.Helper;
using pavesys_iRAP.DTO;
using pavesys_iRAP.Business;

namespace pavesys_iRAP.ViewModels
{
    public partial class EditProjectPageViewModel : ViewModelBase
    {
        Project proj;
        [ObservableProperty]
        private string projRoad;
        [ObservableProperty]
        private string projDescription;
        [ObservableProperty]
        private string projEncoder;
        [ObservableProperty]
        private string xlsxFile;
        [ObservableProperty]
        private string projTrecho;
        [ObservableProperty]
        private decimal projInitialKM;
        [ObservableProperty]
        private decimal projEndKM;
        [ObservableProperty]
        private int projDisplacement;
        [ObservableProperty]
        private decimal projPulse;
        [ObservableProperty]
        private string projXmlPath;

        public void SetContext(int projId)
        {
            proj = CrudHelper.GetProjectById(projId);
            ProjRoad = proj.Road;
            ProjDescription = proj.ProjectDescription;
            ProjEncoder = proj.CoderName;
            ProjTrecho = proj.Section;
        }

        public void SaveProjEdit() {
            proj.Road = ProjRoad;
            proj.ProjectDescription = ProjDescription;
            proj.CoderName = ProjEncoder;
            proj.Section = ProjTrecho;
            if(XlsxFile != null  || XlsxFile != "" ) {
                if (XlsxFile.EndsWith(".xlsx"))
                    XlsxHandler.InputXlsx((int)proj.ProjectId, XlsxFile);
                else if (xlsxFile.EndsWith(".csv"))
                    XlsxHandler.InputCsv((int)proj.ProjectId, XlsxFile);
            }
            CrudHelper.dbCtx.SaveChanges();
        }
    }
}
