﻿using CommunityToolkit.Mvvm.ComponentModel;
using pavesys_iRAP.Helper;

namespace pavesys_iRAP.ViewModels
{
    public partial class ConfigPageViewModel : ViewModelBase
    {
        public string initialLanguage { get; set; }
        public string language { get; set; }
        [ObservableProperty]
        private int selectedLanguage;
        [ObservableProperty]
        private int selectedStretch;
        [ObservableProperty]
        private string exportPath;
        [ObservableProperty]
        private bool showTooltips;

        [ObservableProperty]
        private bool twoScreenMode;
        public string currentStretch { get; set; }

        [ObservableProperty]
        private double inputErrorLimit;
        public void configLanguage()
        {
            //Loads the configured language given in config.json
            initialLanguage = ConfigManager.LoadConfig().GlobalConfig.Language;
            if (initialLanguage == "pt-BR")
                selectedLanguage = 0;
            else if (initialLanguage == "en-US")
                selectedLanguage = 1;
            else
                selectedLanguage = 2; //Spanish
        }

        public void configStretch()
        {
            var initialStretch = ConfigManager.GetStretchType();
            switch (initialStretch)
            {
                case Avalonia.Media.Stretch.None:
                    SelectedStretch = 0;
                    break;
                case Avalonia.Media.Stretch.Fill:
                    SelectedStretch = 1;
                    break;
                case Avalonia.Media.Stretch.Uniform:
                    SelectedStretch = 2;
                    break;
                case Avalonia.Media.Stretch.UniformToFill:
                    SelectedStretch = 3;
                    break;
                
            }
        }
        public ConfigPageViewModel()
        {
            InputErrorLimit = ConfigManager.GetInputErrorLimit();
            ExportPath = ConfigManager.GetExportPath();
            ShowTooltips = ConfigManager.GetShowTooltips();
            TwoScreenMode = ConfigManager.GetTwoScreenMode();

        }
    }
}
