﻿using Avalonia;
using Avalonia.Logging;
using Avalonia.ReactiveUI;
using pavesys_iRAP.Helper;
using System;
using Serilog;
using Serilog.Exceptions;
using pavesys_iRAP.Business;
using System.Diagnostics;
using pavesys_iRAP.DTO;
using System.Collections.ObjectModel;
using System.IO;
using System.Security.Principal;


namespace pavesys_iRAP
{
    internal sealed class Program
    {
        // Initialization code. Don't use any Avalonia, third-party APIs or any
        // SynchronizationContext-reliant code before AppMain is called: things aren't initialized
        // yet and stuff might break.
        [STAThread]
        public static void Main(string[] args)
        {
            Log.Logger = new LoggerConfiguration()
                .MinimumLevel.Debug()
                .WriteTo.File($"{Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.CommonApplicationData),"Pavesys","iRap","logs")}/log{DateTime.Now.ToShortDateString().Replace("/","")}.txt")
                .Enrich.WithExceptionDetails()
                .CreateLogger();
            
            Log.Information("Application Started");
            ConfigManager.LoadConfig();
            Log.Debug("Config Loaded Successfully");

            //var adm = new WindowsPrincipal(WindowsIdentity.GetCurrent()).IsInRole(WindowsBuiltInRole.Administrator);
            //Log.Debug($"Admin Permissions = {adm}");

            try
            {
                BuildAvaloniaApp().StartWithClassicDesktopLifetime(args);
                Log.Debug("Avalonia Exited Correctly");
            } catch (Exception ex) {
                Log.Error(ex,"Problem at Avalonia");
                //Environment.Exit(2);
            }
        }

        // Avalonia configuration, don't remove; also used by visual designer.
        public static AppBuilder BuildAvaloniaApp()
            => AppBuilder.Configure<App>()
                .UsePlatformDetect()
                .WithInterFont()
                .LogToTrace();
    }
}
