﻿using System;
using Microsoft.EntityFrameworkCore.Migrations;

#nullable disable

namespace pavesys_iRAP.Migrations
{
    /// <inheritdoc />
    public partial class InitialCreate : Migration
    {
        /// <inheritdoc />
        protected override void Up(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.EnsureSchema(
                name: "dbo");

            migrationBuilder.CreateTable(
                name: "coding",
                schema: "dbo",
                columns: table => new
                {
                    codingId = table.Column<int>(type: "int", nullable: false)
                        .Annotation("SqlServer:Identity", "1, 1"),
                    projectId = table.Column<int>(type: "int", nullable: false),
                    coderName = table.Column<string>(type: "nvarchar(max)", nullable: false),
                    codingDate = table.Column<DateTime>(type: "datetime2", nullable: false),
                    roadSurveyDate = table.Column<DateTime>(type: "datetime2", nullable: true),
                    auditorName = table.Column<string>(type: "nvarchar(max)", nullable: true),
                    auditingDate = table.Column<DateTime>(type: "datetime2", nullable: true),
                    initialKm = table.Column<decimal>(type: "decimal(18,2)", nullable: true),
                    finalKm = table.Column<decimal>(type: "decimal(18,2)", nullable: true),
                    roadName = table.Column<string>(type: "nvarchar(max)", nullable: false),
                    section = table.Column<string>(type: "nvarchar(max)", nullable: false),
                    distance = table.Column<decimal>(type: "decimal(18,2)", nullable: true),
                    length = table.Column<decimal>(type: "decimal(18,2)", nullable: true),
                    latitude = table.Column<decimal>(type: "decimal(12,8)", precision: 12, scale: 8, nullable: true),
                    longitude = table.Column<decimal>(type: "decimal(12,8)", precision: 12, scale: 8, nullable: true),
                    landmark = table.Column<string>(type: "nvarchar(max)", nullable: false),
                    comments = table.Column<string>(type: "nvarchar(max)", nullable: false),
                    originalCodingId = table.Column<int>(type: "int", nullable: true),
                    carriageWay = table.Column<int>(type: "int", nullable: true),
                    upgradeCost = table.Column<int>(type: "int", nullable: true),
                    motorcycleObservedFlow = table.Column<int>(type: "int", nullable: true),
                    bicycleObservedFlow = table.Column<int>(type: "int", nullable: true),
                    pedestrianObservedFlow = table.Column<int>(type: "int", nullable: true),
                    pedestrianObservedAlongRoadDriver = table.Column<int>(type: "int", nullable: true),
                    pedestrianObservedAlongRoadPassenger = table.Column<int>(type: "int", nullable: true),
                    landUseDrivers = table.Column<int>(type: "int", nullable: true),
                    landUsePassenger = table.Column<int>(type: "int", nullable: true),
                    areaType = table.Column<int>(type: "int", nullable: true),
                    speedLimit = table.Column<int>(type: "int", nullable: true),
                    motorcycleSpeedLimit = table.Column<int>(type: "int", nullable: true),
                    truckSpeedLimit = table.Column<int>(type: "int", nullable: true),
                    differentialSpeeds = table.Column<int>(type: "int", nullable: true),
                    medianType = table.Column<int>(type: "int", nullable: true),
                    centrelineRumbleStrips = table.Column<int>(type: "int", nullable: true),
                    roadsideSeverityDriversSideDistance = table.Column<int>(type: "int", nullable: true),
                    roadsideSeverityDriversSideObject = table.Column<int>(type: "int", nullable: true),
                    roadsideSeverityPassengerSideDistance = table.Column<int>(type: "int", nullable: true),
                    roadsideSeverityPassengerSideObject = table.Column<int>(type: "int", nullable: true),
                    shoulderRumbleStrips = table.Column<int>(type: "int", nullable: true),
                    pavedShoulderDriversSide = table.Column<int>(type: "int", nullable: true),
                    pavedShoulderPassengerSide = table.Column<int>(type: "int", nullable: true),
                    intersectionType = table.Column<int>(type: "int", nullable: true),
                    intersectionChannelisation = table.Column<int>(type: "int", nullable: true),
                    intersectingRoadVolume = table.Column<int>(type: "int", nullable: true),
                    intersectionQuality = table.Column<int>(type: "int", nullable: true),
                    propertyAccessPoints = table.Column<int>(type: "int", nullable: true),
                    numberLanes = table.Column<int>(type: "int", nullable: true),
                    laneWidth = table.Column<int>(type: "int", nullable: true),
                    curvature = table.Column<int>(type: "int", nullable: true),
                    qualityCurve = table.Column<int>(type: "int", nullable: true),
                    grade = table.Column<int>(type: "int", nullable: true),
                    roadCondition = table.Column<int>(type: "int", nullable: true),
                    skidResistanceGrip = table.Column<int>(type: "int", nullable: true),
                    delineation = table.Column<int>(type: "int", nullable: true),
                    streetLighting = table.Column<int>(type: "int", nullable: true),
                    pedestrianCrossingInspectedRoad = table.Column<int>(type: "int", nullable: true),
                    pedestrianCrossingQuality = table.Column<int>(type: "int", nullable: true),
                    pedestrianCrossingFacilitiesSideRoad = table.Column<int>(type: "int", nullable: true),
                    pedestrianFencing = table.Column<int>(type: "int", nullable: true),
                    speedManagementTrafficCalming = table.Column<int>(type: "int", nullable: true),
                    vehicleParking = table.Column<int>(type: "int", nullable: true),
                    sidewalkDriversSide = table.Column<int>(type: "int", nullable: true),
                    sidewalkPassengerSide = table.Column<int>(type: "int", nullable: true),
                    serviceRoad = table.Column<int>(type: "int", nullable: true),
                    facilitiesMotorisedTwoWheelers = table.Column<int>(type: "int", nullable: true),
                    bicycleFacility = table.Column<int>(type: "int", nullable: true),
                    roadworks = table.Column<int>(type: "int", nullable: true),
                    sightDistance = table.Column<int>(type: "int", nullable: true),
                    vehicleFlow = table.Column<int>(type: "int", nullable: true),
                    motorcyclePercentual = table.Column<int>(type: "int", nullable: true),
                    pedestrianPeakHourFlowAcrossRoad = table.Column<int>(type: "int", nullable: true),
                    pedestrianPeakHourFlowAlongRoadDriver = table.Column<int>(type: "int", nullable: true),
                    pedestrianPeakHourFlowAlongRoadPassenger = table.Column<int>(type: "int", nullable: true),
                    bicyclePeakHourlyFlow = table.Column<int>(type: "int", nullable: true),
                    operatingSpeed85thPercentile = table.Column<int>(type: "int", nullable: true),
                    operatingSpeedMean = table.Column<int>(type: "int", nullable: true),
                    roadsCarsRead = table.Column<int>(type: "int", nullable: true),
                    carStarRatingPolicyTarget = table.Column<int>(type: "int", nullable: true),
                    motorcycleStarRatingPolicyTarget = table.Column<int>(type: "int", nullable: true),
                    pedestrianStarRatingPolicyTarget = table.Column<int>(type: "int", nullable: true),
                    bicycleStarRatingPolicyTarget = table.Column<int>(type: "int", nullable: true),
                    annualFatalityGrowthMultiplier = table.Column<int>(type: "int", nullable: true),
                    schoolZoneWarning = table.Column<int>(type: "int", nullable: true),
                    schoolZoneCrossingSupervisor = table.Column<int>(type: "int", nullable: true),
                    updateDate = table.Column<DateTime>(type: "datetime2", nullable: true)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_coding", x => x.codingId);
                });

            migrationBuilder.CreateTable(
                name: "imageImport",
                schema: "dbo",
                columns: table => new
                {
                    seqImport = table.Column<long>(type: "bigint", nullable: false),
                    cameraType = table.Column<int>(type: "int", nullable: false),
                    externalUrl = table.Column<string>(type: "nvarchar(max)", nullable: false),
                    projectId = table.Column<int>(type: "int", nullable: false),
                    originalProjectId = table.Column<int>(type: "int", nullable: false),
                    externalFileName = table.Column<string>(type: "nvarchar(max)", nullable: false),
                    destinationFileName = table.Column<string>(type: "nvarchar(max)", nullable: false),
                    importDate = table.Column<DateTime>(type: "datetime2", nullable: true)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_imageImport", x => new { x.seqImport, x.cameraType });
                });

            migrationBuilder.CreateTable(
                name: "project",
                schema: "dbo",
                columns: table => new
                {
                    projectId = table.Column<int>(type: "int", nullable: false)
                        .Annotation("SqlServer:Identity", "1, 1"),
                    projectDescription = table.Column<string>(type: "nvarchar(max)", nullable: false),
                    coderName = table.Column<string>(type: "nvarchar(max)", nullable: false),
                    road = table.Column<string>(type: "nvarchar(max)", nullable: false),
                    section = table.Column<string>(type: "nvarchar(max)", nullable: false),
                    kmStart = table.Column<decimal>(type: "decimal(18,2)", nullable: false),
                    kmEnd = table.Column<decimal>(type: "decimal(18,2)", nullable: false),
                    projectPath = table.Column<string>(type: "nvarchar(max)", nullable: false),
                    status = table.Column<int>(type: "int", nullable: false),
                    codingPosition = table.Column<int>(type: "int", nullable: true),
                    surveySheetName = table.Column<string>(type: "nvarchar(max)", nullable: false),
                    originalProjectId = table.Column<int>(type: "int", nullable: true),
                    lastExportDate = table.Column<DateTime>(type: "datetime2", nullable: true),
                    externalUrl = table.Column<string>(type: "nvarchar(max)", nullable: false)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_project", x => x.projectId);
                });

            migrationBuilder.CreateTable(
                name: "user",
                schema: "dbo",
                columns: table => new
                {
                    userId = table.Column<int>(type: "int", nullable: false)
                        .Annotation("SqlServer:Identity", "1, 1"),
                    login = table.Column<string>(type: "nvarchar(max)", nullable: false),
                    name = table.Column<string>(type: "nvarchar(max)", nullable: false),
                    password = table.Column<string>(type: "nvarchar(max)", nullable: false),
                    profileType = table.Column<int>(type: "int", nullable: false),
                    userActive = table.Column<int>(type: "int", nullable: false)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_user", x => x.userId);
                });

            migrationBuilder.CreateTable(
                name: "codingImage",
                schema: "dbo",
                columns: table => new
                {
                    codingId = table.Column<int>(type: "int", nullable: false),
                    imageSeq = table.Column<int>(type: "int", nullable: false),
                    cameraType = table.Column<int>(type: "int", nullable: false),
                    name = table.Column<string>(type: "nvarchar(20)", maxLength: 20, nullable: false),
                    fileDate = table.Column<DateTime>(type: "datetime2", nullable: false)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_codingImage", x => new { x.codingId, x.imageSeq, x.cameraType });
                    table.ForeignKey(
                        name: "FK_codingImage_coding_codingId",
                        column: x => x.codingId,
                        principalSchema: "dbo",
                        principalTable: "coding",
                        principalColumn: "codingId",
                        onDelete: ReferentialAction.Cascade);
                });
        }

        /// <inheritdoc />
        protected override void Down(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.DropTable(
                name: "codingImage",
                schema: "dbo");

            migrationBuilder.DropTable(
                name: "imageImport",
                schema: "dbo");

            migrationBuilder.DropTable(
                name: "project",
                schema: "dbo");

            migrationBuilder.DropTable(
                name: "user",
                schema: "dbo");

            migrationBuilder.DropTable(
                name: "coding",
                schema: "dbo");
        }
    }
}
