﻿namespace pavesys_iRAP.Localizer
{
    using Avalonia.Platform;
    using Newtonsoft.Json;
    using pavesys_iRAP.Helper;
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.IO;
    using System.Text;

    public class Localizer : INotifyPropertyChanged
    {
        private const string IndexerName = "Item";
        private const string IndexerArrayName = "Item[]";
        private Dictionary<string, string> m_Strings = null;

        public bool LoadLanguage(string language)
        {
            Language = language;

            Uri uri = new Uri($"avares://pavesys_iRAP/Assets/i18n/{language}.json");
            if (AssetLoader.Exists(uri))
            {
                using (StreamReader sr = new StreamReader(AssetLoader.Open(uri), Encoding.UTF8))
                {
                    m_Strings = JsonConvert.DeserializeObject<Dictionary<string, string>>(sr.ReadToEnd());
                }
                Invalidate();

                return true;
            }
            return false;
        }

        public string Language { get; private set; }

        public string this[string key]
        {
            get
            {
                if (m_Strings != null && m_Strings.TryGetValue(key, out string res)) {
                    if (key.StartsWith("tip") || key.StartsWith("Tip")) 
                    {
                        if (!ConfigManager.GetShowTooltips())
                        {
                            return null;
                        }
                        res.Replace("\\n", "\n");
                        res.Replace("tip", "");
                        return res;
                    }
                    else
                    {
                        res.Replace("\\n", "\n");
                        return res;
                    }
                }

                return $"{Language}:{key}";
            }
        }

        public static Localizer Instance { get; set; } = new Localizer();
        public event PropertyChangedEventHandler PropertyChanged;

        public void Invalidate()
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(IndexerName));
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(IndexerArrayName));
        }
    }
}