﻿
using Mapsui.Layers;
using Mapsui.Providers;
using Mapsui.Styles.Thematics;
using Mapsui.Styles;
using Mapsui;
using Mapsui.Nts;
using NetTopologySuite.Geometries;
using System.Linq;
using pavesys_iRAP.ViewModels;
using Mapsui.Projections;
using Mapsui.Nts.Extensions;
using System.IO;
using System.Diagnostics;
using System.Xml.Linq;
using SharpKml.Engine;
using SharpKml.Dom;
using Serilog;
using pavesys_iRAP.Business;
using System;
using System.Collections.Generic;
using DocumentFormat.OpenXml.Drawing.Charts;
using DocumentFormat.OpenXml.Office2010.Excel;
using DocumentFormat.OpenXml.Presentation;
using DocumentFormat.OpenXml.Wordprocessing;
using static Mapsui.Styles.LabelStyle;

namespace pavesys_iRAP.Helper
{
    public static class MapHelper
    {
        public static  NetTopologySuite.Geometries.LineString? test;

        public static ILayer CreatePointLayer(MPoint point)
        {
            return new Layer("Point")
            {
                DataSource = new MemoryProvider(new PointFeature(point)),
                Style = SymbolStyles.CreatePinStyle(symbolScale:0.7),
                IsMapInfoLayer = true,
                Name = "Point",
            };
        }

        public static ILayer CreateErrorLabelLayer(MPoint point)
        {
            return new Layer("Point")
            {
                DataSource = new MemoryProvider(new PointFeature(point)),
                Style =  new ThemeStyle(f =>
                {
                    return new SymbolStyle { Fill = new Mapsui.Styles.Brush(new Mapsui.Styles.Color(0, 0, 0, 0)) };
                }),
                IsMapInfoLayer = true,
                Name = "Point",
            };
        }

        public static Mapsui.Styles.LabelStyle CreateErrorLabelStyle() {
            return new Mapsui.Styles.LabelStyle
            {
                Font = new Mapsui.Styles.Font
                {
                    FontFamily = "Verdana",
                    Size = 12.0
                },
                Offset = new Offset
                {
                    X = 0.0,
                    Y = 0.0
                },
                CollisionDetection = false,
                ForeColor = Mapsui.Styles.Color.Black,
                BackColor = new Brush
                {
                    Color = Mapsui.Styles.Color.White
                },
                HorizontalAlignment = HorizontalAlignmentEnum.Center,
                VerticalAlignment = VerticalAlignmentEnum.Center,
                MaxWidth = 0.0,
                LineHeight = 1.0,
                WordWrap = LineBreakMode.NoWrap,
                BorderColor = Mapsui.Styles.Color.Transparent,
                BorderThickness = 1.0,
                Text = "Coordenadas Repetidas",
                
                CornerRounding = 6
                
            };
        }
        public static ILayer CreateFeatureWithDefaultStyle(MPoint[] points)
        {
            var features = new List<IFeature>();
            foreach (var point in points) {
                var featureWithDefaultStyle = new PointFeature(point);
                featureWithDefaultStyle.Styles.Add(CreateErrorLabelStyle());
                features.Add(featureWithDefaultStyle);
            }
            
            return new MemoryLayer {Name = "ErrorPoints" , Features= features };
        }
        public static ILayer CreateLineStringLayer(Coordinate[] points,IStyle? style = null)
        {
            var lineString = new NetTopologySuite.Geometries.LineString(points);

            

            return new MemoryLayer
            {
                Features = new[] { new GeometryFeature { Geometry = lineString } },
                Name = "LineStringLayer",
                Style = style

            };
        }

        public static ILayer CreateLineStringLayer(NetTopologySuite.Geometries.LineString linestring, IStyle? style = null)
        {
            return new MemoryLayer
            {
                Features = new[] { new GeometryFeature { Geometry = linestring } },
                Name = "LineStringLayer",
                Style = style

            };
        }

        public static IStyle CreateLineStringStyle()
        {
            return new VectorStyle
            {
                Fill = null,
                Outline = null, 
#pragma warning disable CS8670 // Object or collection initializer implicitly dereferences possibly null member.
                Line = { Color = new Mapsui.Styles.Color(22,88,181), Width = 4 }
                //ff1658b5
            };
        }

        public static IStyle CreateLineStringErrorStyle()
        {
            return new VectorStyle
            {
                Fill = null,
                Outline = null,
#pragma warning disable CS8670 // Object or collection initializer implicitly dereferences possibly null member.
                Line = { Color = new Mapsui.Styles.Color(220, 10, 10,255), Width = 4 }
            };
        }

        public static IStyle CreateLineStringInterpolatedStyle()
        {
            return new VectorStyle
            {
                Fill = null,
                Outline = null,
#pragma warning disable CS8670 // Object or collection initializer implicitly dereferences possibly null member.
                Line = { Color = new Mapsui.Styles.Color(10, 220, 10, 220), Width = 4 }
            };
        }

        public static IStyle CreateLineStringWillInterpolateStyle()
        {
            return new VectorStyle
            {
                Fill = null,
                Outline = null,
#pragma warning disable CS8670 // Object or collection initializer implicitly dereferences possibly null member.
                Line = { Color = new Mapsui.Styles.Color(220, 150, 10, 220), Width = 4 }
            };
        }

        private static IStyle CreateStyle()
        {
            return new ThemeStyle(f =>
            {
                return CreateSymbol();
            });
        }

        

        private static SymbolStyle CreateSymbol()
        {
            return new SymbolStyle { Fill = new Mapsui.Styles.Brush(new Mapsui.Styles.Color(15, 80, 150, 150)) };
        }

    }
}
