﻿using Avalonia.Controls;
using Avalonia.Media;
using Avalonia.Notification;
using Avalonia.Layout;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using DocumentFormat.OpenXml.Math;
using MsBox.Avalonia.Dto;
using MsBox.Avalonia.Models;
using MsBox.Avalonia;
using MsBox.Avalonia.Enums;
using System.Diagnostics;
using Serilog;
using Avalonia.Data;

namespace pavesys_iRAP.Helper
{
    internal static class DialogHelper
    {
        public static List<INotificationMessage> Messages { get; } = new List<INotificationMessage>();
        public static ContentControl OwnerControl;
        public static Window window;

        public static void ShowLoadingQueryNotification(string Header, string Message, INotificationMessageManager Manager)
        {
            try
            {
                var width = window.Width * (3/5);
                Messages.Add(Manager.CreateMessage()
                .WithAdditionalContent(ContentLocation.Top,
                new TextBlock {
                    Margin = Avalonia.Thickness.Parse($"{width},0,0,0"),
                    VerticalAlignment = VerticalAlignment.Center,
                    HorizontalAlignment = HorizontalAlignment.Center,
                    Height = 25,
                    Text = Header,
                    FontSize = 18
                })
                .Accent("#F15B19") //ff1658b5
                .Background("#1658B5")
                .Animates(true)
                .WithOverlay(new ProgressBar
                {
                    VerticalAlignment = VerticalAlignment.Bottom,
                    HorizontalAlignment = HorizontalAlignment.Stretch,
                    Height = 4,
                    BorderThickness = new Avalonia.Thickness(1),
                    Foreground = new SolidColorBrush(Color.FromArgb(128, 255, 255, 255)),
                    Background = Brushes.Transparent,
                    IsIndeterminate = true,
                    IsHitTestVisible = true
                })
                .Queue());
            }
            catch (Exception ex)
            {
                Log.Error(ex, "Error Showing Notification");
            }
        }
        public static async Task DismissLoadingNotification(INotificationMessageManager Manager)
        {
            Task.Delay(500).Wait();
            foreach (var message in Messages)
            {
                Manager.Dismiss(message);
            }
            Messages.Clear();
        }

        public static async Task<bool> ShowYesNoDialog(string LocalizerKeyTitle, string LocalizerKeyContent, MsBox.Avalonia.Enums.Icon icon = Icon.Error)
        {
            var box = MessageBoxManager.GetMessageBoxCustom(
           new MessageBoxCustomParams
           {
               ButtonDefinitions = new List<ButtonDefinition>
               {
                    new ButtonDefinition { Name = Localizer.Localizer.Instance["Yes"], },
                    new ButtonDefinition { Name = Localizer.Localizer.Instance["No"], },

               },
               ContentHeader = Localizer.Localizer.Instance[LocalizerKeyTitle],
               ContentMessage = Localizer.Localizer.Instance[LocalizerKeyContent],
               Icon = icon,
               WindowStartupLocation = WindowStartupLocation.CenterOwner,
               CanResize = false,
               MaxWidth = 500,
               MaxHeight = 800,
               Width = 400,
               SizeToContent = SizeToContent.Height,
               ShowInCenter = true,
               Topmost = false
           });

            if (await box.ShowWindowAsync() == Localizer.Localizer.Instance["Yes"])
                return true;
            else return false;
        }

        public static async Task<bool> ShowYesNoDialog(string LocalizerKeyTitle, string LocalizerKeyContent, string nonLocalizedContent = "",MsBox.Avalonia.Enums.Icon icon = Icon.Error)
        {
            string contentMessage;
            if (nonLocalizedContent == string.Empty || nonLocalizedContent == "")
            {
                contentMessage = Localizer.Localizer.Instance[LocalizerKeyContent];
            }
            else
            {
                contentMessage = nonLocalizedContent;
            }

            var box = MessageBoxManager.GetMessageBoxCustom(
           new MessageBoxCustomParams
           {
               ButtonDefinitions = new List<ButtonDefinition>
               {
                    new ButtonDefinition { Name = Localizer.Localizer.Instance["Yes"], },
                    new ButtonDefinition { Name = Localizer.Localizer.Instance["No"], },

               },
               ContentHeader = Localizer.Localizer.Instance[LocalizerKeyTitle],
               ContentMessage = contentMessage,
               Icon = icon,
               WindowStartupLocation = WindowStartupLocation.CenterOwner,
               CanResize = false,
               MaxWidth = 500,
               MaxHeight = 800,
               Width = 400,
               SizeToContent = SizeToContent.Height,
               ShowInCenter = true,
               Topmost = false
           });

            if (await box.ShowWindowAsync() == Localizer.Localizer.Instance["Yes"])
                return true;
            else return false;
        }

        public static async Task<bool> ShowYesNoPopUp(string LocalizerKeyTitle, string LocalizerKeyContent, MsBox.Avalonia.Enums.Icon icon = Icon.Error) {
            var box = MessageBoxManager.GetMessageBoxCustom(
           new MessageBoxCustomParams
           {
               ButtonDefinitions = new List<ButtonDefinition>
               {
                    new ButtonDefinition { Name = Localizer.Localizer.Instance["Yes"], },
                    new ButtonDefinition { Name = Localizer.Localizer.Instance["No"], },

               },
               ContentHeader = Localizer.Localizer.Instance[LocalizerKeyTitle],
               ContentMessage = Localizer.Localizer.Instance[LocalizerKeyContent],
               Icon = icon,
               WindowStartupLocation = WindowStartupLocation.CenterOwner,
               CanResize = false,
               MaxWidth = 500,
               MaxHeight = 800,
               Width = 400,
               SizeToContent = SizeToContent.Height,
               ShowInCenter = true,
               Topmost = false
           });

            if (await box.ShowAsync() == Localizer.Localizer.Instance["Yes"])
                return true;
            else return false;
        }
        public static async Task<ButtonResult> ShowOkPopUp(string LocalizerKeyTitle, string LocalizerKeyContent, MsBox.Avalonia.Enums.Icon icon = Icon.Error) {
            int maxWidth = 500;
            int maxHeight = 800;
            var box = MessageBoxManager.GetMessageBoxStandard(
                new MessageBoxStandardParams
                {
                    ButtonDefinitions = ButtonEnum.Ok,
                    //ContentTitle = title,
                    ContentHeader = Localizer.Localizer.Instance[LocalizerKeyTitle],
                    ContentMessage = Localizer.Localizer.Instance[LocalizerKeyContent],

                    Icon = MsBox.Avalonia.Enums.Icon.Error,
                    WindowStartupLocation = WindowStartupLocation.CenterOwner,
                    CanResize = false,
                    Width = 400,
                    MaxWidth = maxWidth,
                    MaxHeight = maxHeight,
                    SizeToContent = SizeToContent.Height,
                    ShowInCenter = true,
                    Topmost = true
                }) ;
            var result = await box.ShowAsPopupAsync(OwnerControl);
            return result;
        }
        public static async Task<ButtonResult> ShowOkDialog(string LocalizerKeyTitle, string LocalizerKeyContent, MsBox.Avalonia.Enums.Icon icon = Icon.Error , string nonLocalizedContent = "")
        {

            //Should change this to a more friendly function use later.
            string contentMessage;
            if(nonLocalizedContent == string.Empty)
            {
                contentMessage = Localizer.Localizer.Instance[LocalizerKeyContent];
            }
            else
            {
                contentMessage = nonLocalizedContent;
            } 
                
            int maxWidth = 500;
            int maxHeight = 800;
            var box = MessageBoxManager.GetMessageBoxStandard(
                new MessageBoxStandardParams
                {
                    ButtonDefinitions = ButtonEnum.Ok,
                    //ContentTitle = title,
                    ContentHeader = Localizer.Localizer.Instance[LocalizerKeyTitle],
                    ContentMessage = contentMessage,

                    Icon = MsBox.Avalonia.Enums.Icon.Error,
                    WindowStartupLocation = WindowStartupLocation.CenterOwner,
                    CanResize = false,
                    Width = 400,
                    MaxWidth = maxWidth,
                    MaxHeight = maxHeight,
                    SizeToContent = SizeToContent.Height,
                    ShowInCenter = true,
                    Topmost = true
                });
            var result = await box.ShowWindowAsync();
            return result;
        }

    }

    
}
