﻿using Mapsui.Utilities;
using Microsoft.Data.SqlClient;
using Microsoft.EntityFrameworkCore;
using pavesys_iRAP.Business;
using pavesys_iRAP.DTO;
using Serilog;
using System;
using System.Diagnostics;
using System.Linq;
using System.Threading.Tasks;

namespace pavesys_iRAP.Helper
{
    internal static class  DatabaseHelper
    {
        public static void InitDatabase()
        {
            if (!BaseHelper.RemoteDatabase)
            {
                // if (BaseHelper.AllowMigration)
                // Database.SetInitializer<PersistenceContext>(new MigrateDatabaseToLatestVersion<PersistenceContext, Configuration>());
            }
            //Database.SetInitializer<PersistenceContext>(null);

            UserHelper user = new UserHelper();
            int countDB = user.CountUser();

            if (countDB == 0)
            {
                user.InsertUser("iRap", "iRap User", "iRap");
            }
        }

        public static void SetupDataBase()
        {
            try
            {
                bool databaseExists =  CrudHelper.dbCtx.Database.CanConnect();

                if (!databaseExists)
                {
                    CrudHelper.dbCtx.Database.Migrate();

                    UserHelper user = new UserHelper();
                    user.InsertUser("admin", "iRap User", "admin");
                }
                else
                {

                    if (CrudHelper.dbCtx.Database.GetPendingMigrations().Any())
                    {
                        CrudHelper.dbCtx.Database.Migrate();
                    }
                }
            }
            catch (Exception e)
            {
                Log.Error(e, "Failed to setup database or apply migrations");
            }
            finally
            {
                CrudHelper.RefreshContext();
            }
        }

        public static string MakeConnectionString(ConfigType cfgType)
        {
            if (cfgType == null)
                return null;

            if (cfgType.DatabaseType == 1)
            {
                var builder = new SqlConnectionStringBuilder();
                builder["Data Source"] = string.Format("{0},{1}", cfgType.DatabaseHost, cfgType.DatabasePort);
                builder["Database"] = cfgType.DatabaseName;
                builder["User Id"] = cfgType.DatabaseUser;
                builder["Password"] = cfgType.DatabasePasswd;
                builder["Connect Timeout"] = 30;
                return builder.ToString().Replace("\"", "");
            }
            else if (cfgType.DatabaseType == 2)
            {
                /*
                var builder = new SQLiteConnectionStringBuilder();
                builder["Data Source"] = String.Format("{0};Version=3", cfgType.DatabaseName);
                return builder.ToString().Replace("\"", "");
                */

                var builder = new SqlConnectionStringBuilder();
                builder["Data Source"] = string.Format("(LocalDB)\\MSSQLLocalDB; AttachDbFilename = {0}", cfgType.DatabaseName);
                builder["Integrated Security"] = true;
                builder["Connect Timeout"] = 30;
                builder["Trusted_Connection"] = true;

                return builder.ToString().Replace("\"", "");
            }

            return null;
        }
    }
}
