﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace pavesys_iRAP.DTO
{
    public enum ProfileType
    {
        ADMIN, CODER, AUDIT
    }

    [Table("user", Schema = "dbo")]
    public class User : INotifyPropertyChanged
    {
        public int _userId;
        public string _login;
        public string _name;
        public string _password;
        public int _profileType;
        public int _active;

        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        [Column("userId")]
        public int UserId
        {
            get { return _userId; }
            set
            {
                _userId = value;
                NotifyPropertyChanged("UserId");
            }
        }

        [Column("login")]
        public string Login
        {
            get { return _login; }
            set
            {
                _login = value;
                NotifyPropertyChanged("Login");
            }
        }

        [Column("name")]
        public string Name
        {
            get { return _name; }
            set
            {
                _name = value;
                NotifyPropertyChanged("Name");
            }
        }

        [Column("password")]
        public string Password
        {
            get { return _password; }
            set
            {
                _password = value;
                NotifyPropertyChanged("Password");
            }
        }

        [Column("profileType")]
        public int ProfileType
        {
            get { return _profileType; }
            set
            {
                _profileType = value;
                NotifyPropertyChanged("ProfileType");
            }
        }

        [Column("userActive")]
        public int Active
        {
            get { return _active; }
            set
            {
                _active = value;
                NotifyPropertyChanged("Active");
            }
        }

        [NotMapped]
        public string ProfileTypeDesc
        {
            get
            {
                if (ProfileType == 0)
                    return "Administrador";
                else if (ProfileType == 1)
                    return "Codificador";
                else if (ProfileType == 2)
                    return "Auditor";

                return null;
            }
        }

        [NotMapped]
        public bool UserActive
        {
            get { return Active != 0 && Active == 1; }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void NotifyPropertyChanged(string info)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(info));
            }
        }
    }
}
