﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.ComponentModel.DataAnnotations;

namespace pavesys_iRAP.DTO
{
    public enum StatusProject
    {
        OPEN, ACTIVE, WORKING, CLOSED
    }

    [Table("project", Schema = "dbo")]
    public class Project : INotifyPropertyChanged
    {
        private int? _projectId;
        private string _projectDescription;
        private string _coderName;
        private string _road;
        private string _section;
        private decimal _kmStart;
        private decimal _kmEnd;
        private string _projectPath;
        private int _status;
        private int? _codingPosition;
        private string _surveySheetName;
        private int? _originalProjectId;
        private DateTime? _lastExportDate;
        private string? _externalUrl;
        private bool? _isMph;
        private string? _viaSeguraLabeled;

        // Informações para seleção de projetos
        private bool _selected;

        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        [Column("projectId")]
        public int? ProjectId
        {
            get { return _projectId; }
            set
            {
                _projectId = value;
                NotifyPropertyChanged("ProjectId");
            }
        }

        [Column("projectDescription")]
        public string ProjectDescription
        {
            get { return _projectDescription; }
            set
            {
                _projectDescription = value;
                NotifyPropertyChanged("ProjectDescription");
            }
        }

        [Column("coderName")]
        public string CoderName
        {
            get { return _coderName; }
            set
            {
                _coderName = value;
                NotifyPropertyChanged("CoderName");
            }
        }

        [Column("road")]
        public string Road
        {
            get { return _road; }
            set
            {
                _road = value;
                NotifyPropertyChanged("Road");
            }
        }

        [Column("section")]
        public string Section
        {
            get { return _section; }
            set
            {
                _section = value;
                NotifyPropertyChanged("Section");
            }
        }

        [Column("isMph")]
        public bool? IsMph
        {
            get { return _isMph; }
            set
            {
                _isMph= value;
                NotifyPropertyChanged("IsMph");
            }
        }

        [Column("kmStart")]
        public decimal KmStart
        {
            get { return _kmStart; }
            set
            {
                _kmStart = value;
                NotifyPropertyChanged("KmStart");
            }
        }

        [Column("kmEnd")]
        public decimal KmEnd
        {
            get { return _kmEnd; }
            set
            {
                _kmEnd = value;
                NotifyPropertyChanged("KmEnd");
            }
        }

        [Column("projectPath")]
        public string ProjectPath
        {
            get { return _projectPath; }
            set
            {
                _projectPath = value;
                NotifyPropertyChanged("ProjectPath");
            }
        }

        [Column("status")]
        public int Status
        {
            get { return _status; }
            set
            {
                _status = value;
                NotifyPropertyChanged("Status");
            }
        }

        [Column("codingPosition")]
        public int? CodingPosition
        {
            get { return _codingPosition; }
            set
            {
                _codingPosition = value;
                NotifyPropertyChanged("CodingPosition");
            }
        }
        [Column("viaSeguraLabeled")]
        public string? ViaSeguraLabeled
        {
            get { return _viaSeguraLabeled; }
            set
            {
                _viaSeguraLabeled = value;
                NotifyPropertyChanged("ViaSeguraLabeled");
            }
        }

        [Column("surveySheetName")]
        public string SurveySheetName
        {
            get { return _surveySheetName; }
            set
            {
                _surveySheetName = value;
                NotifyPropertyChanged("SurveySheetName");
            }
        }

        [Column("originalProjectId")]
        public int? OriginalProjectId
        {
            get { return _originalProjectId; }
            set
            {
                _originalProjectId = value;
                NotifyPropertyChanged("OriginalProjectId");
            }
        }

        [Column("lastExportDate")]
        public DateTime? LastExportDate
        {
            get { return _lastExportDate; }
            set
            {
                _lastExportDate = value;
                NotifyPropertyChanged("LastExportDate");
            }
        }

        [Column("externalUrl")]
        public string? ExternalUrl
        {
            get { return _externalUrl; }
            set { _externalUrl = value; }
        }

        [NotMapped]
        public bool Selected
        {
            get { return _selected; }
            set { _selected = value; }
        }

        public Project()
        {
            Status = StatusProject.OPEN.GetHashCode();
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void NotifyPropertyChanged(string info)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(info));
            }
        }
    }
}
