﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace pavesys_iRAP.DTO.Import
{
    [Table("imageImport", Schema = "dbo")]
    public class ImageImport
    {
        private long _seqImport;
        private string _externalUrl;
        private int _projectId;
        private int _originalProjectId;
        private int _cameraType;
        private string _externalFileName;
        private string _destinationFileName;
        private DateTime? _importDate;

        public ImageImport()
        {
            _seqImport = DateTime.Now.Ticks;
        }

        [Key, Column("seqImport", Order = 0)]
        public long SeqImport
        {
            get { return _seqImport; }
            set { _seqImport = value; }
        }

        [Key, Column("cameraType", Order = 1)]
        public int CameraType
        {
            get { return _cameraType; }
            set { _cameraType = value; }
        }

        [Column("externalUrl")]
        public string ExternalUrl
        {
            get { return _externalUrl; }
            set { _externalUrl = value; }
        }

        [Column("projectId")]
        public int ProjectId
        {
            get { return _projectId; }
            set { _projectId = value; }
        }

        [Column("originalProjectId")]
        public int OriginalProjectId
        {
            get { return _originalProjectId; }
            set { _originalProjectId = value; }
        }

        [Column("externalFileName")]
        public string ExternalFileName
        {
            get { return _externalFileName; }
            set { _externalFileName = value; }
        }

        [Column("destinationFileName")]
        public string DestinationFileName
        {
            get { return _destinationFileName; }
            set { _destinationFileName = value; }
        }

        [Column("importDate")]
        public DateTime? ImportDate
        {
            get { return _importDate; }
            set { _importDate = value; }
        }
    }
}
