﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace pavesys_iRAP.DTO
{
    public class ConfigType
    {
        /// <summary>
        /// Group Section Name
        /// </summary>
        public string SectionName { get; set; }
        /// <summary>
        /// Configuration Name
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// 0 = Local; 1 = Remote
        /// </summary>
        public int Type { get; set; }

        /// <summary>
        /// 0 = SQL Server; 1 = SQLite
        /// </summary>
        public int DatabaseType { get; set; }

        /// <summary>
        /// HostName for datase
        /// </summary>
        public string DatabaseHost { get; set; }

        /// <summary>
        /// Database port
        /// </summary>
        public int DatabasePort { get; set; }

        /// <summary>
        /// Nome do banco de dados SQL
        /// </summary>
        public string DatabaseName { get; set; }

        /// <summary>
        /// Username  for database
        /// </summary>
        public string DatabaseUser { get; set; }

        /// <summary>
        /// Password for database
        /// </summary>
        public string DatabasePasswd { get; set; }


        /// <summary>
        /// Repository Path for Images
        /// </summary>
        public string LocalPath { get; set; }

        /// <summary>
        /// Remote Repo Path for Images and Files
        /// </summary>
        public string RemotePath { get; set; }

        /// <summary>
        /// Allow Migration (DB Migration)
        /// </summary>
        public bool AllowMigration { get; set; }

        /// <summary>
        /// ConfigType.ToString()
        /// </summary>
        /// <returns></returns>
        public override string ToString()
        {
            StringBuilder output = new StringBuilder();

            output.Append(" sectionName=").Append(SectionName);
            output.Append(",name=").Append(Name);
            output.Append(",type=").Append(Type);
            output.Append(",databaseType=").Append(DatabaseType);
            output.Append(",databaseHost=").Append(DatabaseHost);
            output.Append(",databasePort=").Append(DatabasePort);
            output.Append(",databaseName=").Append(DatabaseName);
            output.Append(",databaseUser=").Append(DatabaseUser);
            output.Append(",databasePasswd=").Append(DatabasePasswd);
            output.Append(",localPath=").Append(LocalPath);
            output.Append(",remotePath=").Append(RemotePath);
            output.Append(",allowMigration=").Append(AllowMigration);

            return output.ToString();
        }
    }
}
