﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.EntityFrameworkCore;
using Newtonsoft.Json;

namespace pavesys_iRAP.DTO
{
    [Table("codingImage", Schema = "dbo")]
    public class CodingImage
    {
        [Column("codingId", Order = 0)]
        public int? CodingId { get; set; }

        [Column("imageSeq", Order = 1)]
        public int Sequence { get; set; }

        [Column("cameraType", Order = 2)]
        public int Type { get; set; }

        [Column("name")]
        [MaxLength(20)]
        [Required]
        public string ImageName { get; set; }

        [Column("fileDate")]
        public DateTime FileDate { get; set; }

        [ForeignKey("CodingId")]
        [JsonIgnore]
        public virtual Coding Coding { get; set; }


    }
}
