﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace pavesys_iRAP.DTO
{
    [Table("coding", Schema = "dbo")]
    public class Coding : INotifyPropertyChanged
    {   
        private int? _codingId;
        private int _projectId;
        private string _coderName;
        private DateTime _codingDate;
        private DateTime? _roadSurveyDate;
        private string? _auditorName;
        private DateTime? _auditingDate;
        private decimal? _initialKm;
        private decimal? _finalKm;
        private string _roadName;
        private string _section;
        private decimal? _distance;
        private decimal? _length;
        private decimal? _latitude;
        private decimal? _longitude;
        private string? _landmark;
        private string? _comments;
        private int? _originalCodingId;

        private int? _carriageWay;
        private int? _upgradeCost;
        private int? _motorcycleObserveredFlow;
        private int? _bicycleObservedFlow;
        private int? _pedestrianObservedFlow;
        private int? _pedestrianObservedAlongRoadDriver;
        private int? _pedestrianObservedAlongRoadPassenger;
        private int? _landUseDrivers;
        private int? _landUsePassenger;
        private int? _areaType;
        private int? _speedLimit;
        private int? _motorcycleSpeedLimit;
        private int? _truckSpeedLimit;
        private int? _differentialSpeeds;
        private int? _medianType;
        private int? _centrelineRumbleStrips;
        private int? _roadsideSeverityDriversSideDistance;
        private int? _roadsideSeverityDriversSideObject;
        private int? _roadsideSeverityPassengerSideDistance;
        private int? _roadsideSeverityPassengerSideObject;
        private int? _shoulderRumbleStrips;
        private int? _pavedShoulderDriversSide;
        private int? _pavedShoulderPassengerSide;
        private int? _intersectionType;
        private int? _intersectionChannelisation;
        private int? _intersectingRoadVolume;
        private int? _intersectionQuality;
        private int? _propertyAccessPoints;
        private int? _numberLanes;
        private int? _laneWidth;
        private int? _curvature;
        private int? _qualityCurve;
        private int? _grade;
        private int? _roadCondition;
        private int? _skidResistanceGrip;
        private int? _delineation;
        private int? _streetLighting;
        private int? _pedestrianCrossingInspectedRoad;
        private int? _pedestrianCrossingQuality;
        private int? _pedestrianCrossingFacilitiesSideRoad;
        private int? _pedestrianFencing;
        private int? _speedManagementTrafficCalming;
        private int? _vehicleParking;
        private int? _sidewalkDriversSide;
        private int? _sidewalkPassengerSide;
        private int? _serviceRoad;
        private int? _facilitiesMotorisedTwoWheelers;
        private int? _bicycleFacility;
        private int? _roadworks;
        private int? _sightDistance;
        private int? _vehicleFlow;
        private int? _motorcyclePercentual;
        private int? _pedestrianPeakHourFlowAcrossRoad;
        private int? _pedestrianPeakHourFlowAlongRoadDriver;
        private int? _pedestrianPeakHourFlowAlongRoadPassenger;
        private int? _bicyclePeakHourlyFlow;
        private int? _operatingSpeed85thPercentile;
        private int? _operatingSpeedMean;
        private int? _roadsCarsRead;
        private int? _carStarRatingPolicyTarget;
        private int? _motorcycleStarRatingPolicyTarget;
        private int? _pedestrianStarRatingPolicyTarget;
        private int? _bicycleStarRatingPolicyTarget;
        private int? _annualFatalityGrowthMultiplier;
        private int? _schoolZoneWarning;
        private int? _schoolZoneCrossingSupervisor;
        private DateTime? _updateDate;

        //Adicionado conforme iRap Antigo
        public virtual ICollection<CodingImage> ImagesCam { get; set; }
        public Coding()
        {
            AnnualFatalityGrowthMultiplier = 1;

            this.ImagesCam = new List<CodingImage>();
        }

        /// <summary>
        /// Identificador do lançamento no iRap
        /// </summary>
        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        [Column("codingId")]
        public int? CodingId
        {
            get { return _codingId; }
            set
            {
                _codingId = value;
                NotifyPropertyChanged("CodingId");
            }
        }

        /// <summary>
        /// Identificador do projeto
        /// </summary>
        [Column("projectId")]
        public int ProjectId
        {
            get { return _projectId; }
            set
            {
                _projectId = value;
                NotifyPropertyChanged("ProjectId");
            }
        }

        /// <summary>
        /// Nome do codificador
        /// </summary>
        [Column("coderName")]
        public string CoderName
        {
            get { return _coderName; }
            set
            {
                _coderName = value;
                NotifyPropertyChanged("CoderName");
            }
        }

        /// <summary>
        /// Data da codificação
        /// </summary>
        [Column("codingDate")]
        public DateTime CodingDate
        {
            get { return _codingDate; }
            set
            {
                _codingDate = value;

                NotifyPropertyChanged("CodingDate");
            }
        }

        /// <summary>
        /// Data da coleta das imagens em campo
        /// </summary>
        [Column("roadSurveyDate")]
        public DateTime? RoadSurveyDate
        {
            get { return _roadSurveyDate; }
            set
            {
                _roadSurveyDate = value;
                NotifyPropertyChanged("RoadSurveyDate");
            }
        }

        /// <summary>
        /// Nome do usuário auditor
        /// </summary>
        [Column("auditorName")]
        public string? AuditorName
        {
            get { return _auditorName; }
            set
            {
                _auditorName = value;
                NotifyPropertyChanged("AuditorName");
            }
        }

        /// <summary>
        /// Data/Hora da auditoria, quando em Auditoria
        /// </summary>
        [Column("auditingDate")]
        public DateTime? AuditingDate
        {
            get { return _auditingDate; }
            set
            {
                _auditingDate = value;
                NotifyPropertyChanged("AuditingDate");
            }
        }

        /// <summary>
        /// KM Inicial do levantamento, aglutinado em 100m
        /// </summary>
        [Column("initialKm")]
        public decimal? InitialKm
        {
            get { return _initialKm; }
            set
            {
                _initialKm = value;
                NotifyPropertyChanged("InitialKm");
            }
        }

        [Column("finalKm")]
        public decimal? FinalKm
        {
            get { return _finalKm; }
            set
            {
                _finalKm = value;
                NotifyPropertyChanged("FinalKm");
            }
        }

       

        /// <summary>
        /// Nome da Rodovia
        /// </summary>
        [Column("roadName")]
        public string RoadName
        {
            get { return _roadName; }
            set
            {
                _roadName = value;
                NotifyPropertyChanged("RoadName");
            }
        }

        /// <summary>
        /// Trecho
        /// </summary>
        [Column("section")]
        public string Section
        {
            get { return _section; }
            set
            {
                _section = value;
                NotifyPropertyChanged("Section");
            }
        }

        /// <summary>
        ///  Distância
        /// </summary>
        [Column("distance")]
        public decimal? Distance
        {
            get { return _distance; }
            set
            {
                _distance = value;
                NotifyPropertyChanged("Distance");
            }
        }

        /// <summary>
        /// Comprimento do segmento
        /// </summary>
        [Column("length")]
        public decimal? Length
        {
            get { return _length; }
            set
            {
                _length = value;
                NotifyPropertyChanged("Length");
            }
        }

        /// <summary>
        /// Latitude
        /// </summary>
        [Column("latitude")]
        public decimal? Latitude
        {
            get { return _latitude; }
            set
            {
                _latitude = value;
                NotifyPropertyChanged("Latitude");
            }
        }

        /// <summary>
        /// Longitude
        /// </summary>
        [Column("longitude")]
        public decimal? Longitude
        {
            get { return _longitude; }
            set
            {
                _longitude = value;
                NotifyPropertyChanged("Longitude");
            }
        }

        /// <summary>
        /// Marcos
        /// </summary>
        [Column("landmark")]
        public string? Landmark
        {
            get { return _landmark; }
            set
            {
                _landmark = value;
                NotifyPropertyChanged("Landmark");
            }
        }

        /// <summary>
        /// Comentários
        /// </summary>
        [Column("comments")]
        public string? Comments
        {
            get { return _comments; }
            set
            {
                _comments = value;
                NotifyPropertyChanged("Comments");
            }
        }

        /// <summary>
        /// Original CodingId (Exported)
        /// </summary>
        [Column("originalCodingId")]
        public int? OriginalCodingId
        {
            get { return _originalCodingId; }
            set
            {
                _originalCodingId = value;
                NotifyPropertyChanged("OriginalCodingId");
            }
        }

        /// <summary>
        /// Etiqueta de pista
        /// </summary>
        [Column("carriageWay")]
        public int? CarriageWay
        {
            get { return _carriageWay; }
            set
            {
                _carriageWay = value;
                NotifyPropertyChanged("CarriageWay");
            }
        }

        /// <summary>
        /// Custo dos melhoramentos
        /// </summary>
        [Column("upgradeCost")]
        public int? UpgradeCost
        {
            get { return _upgradeCost; }
            set
            {
                _upgradeCost = value;
                NotifyPropertyChanged("UpgradeCost");
            }
        }

        /// <summary>
        /// Fluxo observado de motocicletas
        /// </summary>
        [Column("motorcycleObservedFlow")]
        public int? MotorcycleObserveredFlow
        {
            get { return _motorcycleObserveredFlow; }
            set
            {
                _motorcycleObserveredFlow = value;
                NotifyPropertyChanged("MotorcycleObserveredFlow");
            }
        }

        /// <summary>
        /// Fluxo observado de bicicletas
        /// </summary>
        [Column("bicycleObservedFlow")]
        public int? BicycleObservedFlow
        {
            get { return _bicycleObservedFlow; }
            set
            {
                _bicycleObservedFlow = value;
                NotifyPropertyChanged("BicycleObservedFlow");
            }
        }

        /// <summary>
        /// Fluxo observado de pedestres atravessando a rodovia
        /// </summary>
        [Column("pedestrianObservedFlow")]
        public int? PedestrianObservedFlow
        {
            get { return _pedestrianObservedFlow; }
            set
            {
                _pedestrianObservedFlow = value;
                NotifyPropertyChanged("PedestrianObservedFlow");
            }
        }

        /// <summary>
        /// Fluxo observado de pedestres ao longo da via – lado do condutor
        /// </summary>
        [Column("pedestrianObservedAlongRoadDriver")]
        public int? PedestrianObservedAlongRoadDriver
        {
            get { return _pedestrianObservedAlongRoadDriver; }
            set
            {
                _pedestrianObservedAlongRoadDriver = value;
                NotifyPropertyChanged("PedestrianObservedAlongRoadDriver");
            }
        }

        /// <summary>
        /// Fluxo observado de pedestres ao longo da via – lado do passageiro   
        /// </summary>
        [Column("pedestrianObservedAlongRoadPassenger")]
        public int? PedestrianObservedAlongRoadPassenger
        {
            get { return _pedestrianObservedAlongRoadPassenger; }
            set
            {
                _pedestrianObservedAlongRoadPassenger = value;
                NotifyPropertyChanged("PedestrianObservedAlongRoadPassenger");
            }
        }

        /// <summary>
        /// Uso do solo - lado do condutor
        /// </summary>
        [Column("landUseDrivers")]
        public int? LandUseDrivers
        {
            get { return _landUseDrivers; }
            set
            {
                _landUseDrivers = value;
                NotifyPropertyChanged("LandUseDrivers");
            }
        }

        /// <summary>
        /// Uso do solo - lado do passageiro    
        /// </summary>
        [Column("landUsePassenger")]
        public int? LandUsePassenger
        {
            get { return _landUsePassenger; }
            set
            {
                _landUsePassenger = value;
                NotifyPropertyChanged("LandUsePassenger");
            }
        }

        /// <summary>
        /// Tipo de área
        /// </summary>
        [Column("areaType")]
        public int? AreaType
        {
            get { return _areaType; }
            set
            {
                _areaType = value;
                NotifyPropertyChanged("AreaType");
            }
        }

        /// <summary>
        /// Limite de Velocidade
        /// </summary>
        [Column("speedLimit")]
        public int? SpeedLimit
        {
            get { return _speedLimit; }
            set
            {
                _speedLimit = value;
                NotifyPropertyChanged("SpeedLimit");
            }
        }

        /// <summary>
        /// Limite de Velocidade para Motocicletas
        /// </summary>
        [Column("motorcycleSpeedLimit")]
        public int? MotorcycleSpeedLimit
        {
            get { return _motorcycleSpeedLimit; }
            set
            {
                _motorcycleSpeedLimit = value;
                NotifyPropertyChanged("MotorcycleSpeedLimit");
            }
        }

        /// <summary>
        /// Limite de Velocidade para Caminhões
        /// </summary>
        [Column("truckSpeedLimit")]
        public int? TruckSpeedLimit
        {
            get { return _truckSpeedLimit; }
            set
            {
                _truckSpeedLimit = value;
                NotifyPropertyChanged("TruckSpeedLimit");
            }
        }

        /// <summary>
        /// Diferencial de velocidades
        /// </summary>
        [Column("differentialSpeeds")]
        public int? DifferentialSpeeds
        {
            get { return _differentialSpeeds; }
            set
            {
                _differentialSpeeds = value;
                NotifyPropertyChanged("DifferentialSpeeds");
            }
        }

        /// <summary>
        /// Tipo de canteiro central
        /// </summary>
        [Column("medianType")]
        public int? MedianType
        {
            get { return _medianType; }
            set
            {
                _medianType = value;
                NotifyPropertyChanged("MedianType");
            }
        }

        /// <summary>
        /// Sonorizadores ao longo do eixo da pista
        /// </summary>
        [Column("centrelineRumbleStrips")]
        public int? CentrelineRumbleStrips
        {
            get { return _centrelineRumbleStrips; }
            set
            {
                _centrelineRumbleStrips = value;
                NotifyPropertyChanged("CentrelineRumbleStrips");
            }
        }

        /// <summary>
        /// Severidade lateral – distância do lado do condutor
        /// </summary>
        [Column("roadsideSeverityDriversSideDistance")]
        public int? RoadsideSeverityDriversSideDistance
        {
            get { return _roadsideSeverityDriversSideDistance; }
            set
            {
                _roadsideSeverityDriversSideDistance = value;
                NotifyPropertyChanged("RoadsideSeverityDriversSideDistance");
            }
        }

        /// <summary>
        /// Severidade lateral – objeto do lado do condutor
        /// </summary>
        [Column("roadsideSeverityDriversSideObject")]
        public int? RoadsideSeverityDriversSideObject
        {
            get { return _roadsideSeverityDriversSideObject; }
            set
            {
                _roadsideSeverityDriversSideObject = value;
                NotifyPropertyChanged("RoadsideSeverityDriversSideObject");
            }
        }

        /// <summary>
        /// Severidade lateral – distância do lado do passageiro
        /// </summary>
        [Column("roadsideSeverityPassengerSideDistance")]
        public int? RoadsideSeverityPassengerSideDistance
        {
            get { return _roadsideSeverityPassengerSideDistance; }
            set
            {
                _roadsideSeverityPassengerSideDistance = value;
                NotifyPropertyChanged("RoadsideSeverityPassengerSideDistance");
            }
        }

        /// <summary>
        /// Severidade lateral – objeto do lado do passageiro
        /// </summary>
        [Column("roadsideSeverityPassengerSideObject")]
        public int? RoadsideSeverityPassengerSideObject
        {
            get { return _roadsideSeverityPassengerSideObject; }
            set
            {
                _roadsideSeverityPassengerSideObject = value;
                NotifyPropertyChanged("RoadsideSeverityPassengerSideObject");
            }
        }

        /// <summary>
        /// Sonorizadores ao longo do acostamento
        /// </summary>
        [Column("shoulderRumbleStrips")]
        public int? ShoulderRumbleStrips
        {
            get { return _shoulderRumbleStrips; }
            set
            {
                _shoulderRumbleStrips = value;
                NotifyPropertyChanged("ShoulderRumbleStrips");
            }
        }

        /// <summary>
        /// Largura de acostamento pavimentado - lado do condutor
        /// </summary>
        [Column("pavedShoulderDriversSide")]
        public int? PavedShoulderDriversSide
        {
            get { return _pavedShoulderDriversSide; }
            set
            {
                _pavedShoulderDriversSide = value;
                NotifyPropertyChanged("PavedShoulderDriversSide");
            }
        }

        /// <summary>
        /// Largura de acostamento pavimentado - lado do passageiro
        /// </summary>
        [Column("pavedShoulderPassengerSide")]
        public int? PavedShoulderPassengerSide
        {
            get { return _pavedShoulderPassengerSide; }
            set
            {
                _pavedShoulderPassengerSide = value;
                NotifyPropertyChanged("PavedShoulderPassengerSide");
            }
        }

        /// <summary>
        /// Tipo de interseção
        /// </summary>
        [Column("intersectionType")]
        public int? IntersectionType
        {
            get { return _intersectionType; }
            set
            {
                _intersectionType = value;
                NotifyPropertyChanged("IntersectionType");
            }
        }

        /// <summary>
        /// Canalização da interseção
        /// </summary>
        [Column("intersectionChannelisation")]
        public int? IntersectionChannelisation
        {
            get { return _intersectionChannelisation; }
            set
            {
                _intersectionChannelisation = value;
                NotifyPropertyChanged("IntersectionChannelisation");
            }
        }

        /// <summary>
        /// Volume de tráfego na via transversal
        /// </summary>
        [Column("intersectingRoadVolume")]
        public int? IntersectingRoadVolume
        {
            get { return _intersectingRoadVolume; }
            set
            {
                _intersectingRoadVolume = value;
                NotifyPropertyChanged("IntersectionRoadVolume");
            }
        }

        /// <summary>
        /// Qualidade da interseção
        /// </summary>
        [Column("intersectionQuality")]
        public int? IntersectionQuality
        {
            get { return _intersectionQuality; }
            set
            {
                _intersectionQuality = value;
                NotifyPropertyChanged("IntersectionQuality");
            }
        }

        /// <summary>
        /// Pontos de acesso a propriedades
        /// </summary>
        [Column("propertyAccessPoints")]
        public int? PropertyAccessPoints
        {
            get { return _propertyAccessPoints; }
            set
            {
                _propertyAccessPoints = value;
                NotifyPropertyChanged("PropertyAccessPoints");
            }
        }

        /// <summary>
        /// Número de faixas
        /// </summary>
        [Column("numberLanes")]
        public int? NumberLanes
        {
            get { return _numberLanes; }
            set
            {
                _numberLanes = value;
                NotifyPropertyChanged("NumberLanes");
            }
        }

        /// <summary>
        /// Largura da faixa
        /// </summary>
        [Column("laneWidth")]
        public int? LaneWidth
        {
            get { return _laneWidth; }
            set
            {
                _laneWidth = value;
                NotifyPropertyChanged("LaneWidth");
            }
        }

        /// <summary>
        /// Curvatura
        /// </summary>
        [Column("curvature")]
        public int? Curvature
        {
            get { return _curvature; }
            set
            {
                _curvature = value;
                NotifyPropertyChanged("Curvature");
            }
        }

        /// <summary>
        /// Qualidade da curva
        /// </summary>
        [Column("qualityCurve")]
        public int? QualityCurve
        {
            get { return _qualityCurve; }
            set
            {
                _qualityCurve = value;
                NotifyPropertyChanged("QualityCurve");
            }
        }

        /// <summary>
        /// Inclinação
        /// </summary>
        [Column("grade")]
        public int? Grade
        {
            get { return _grade; }
            set
            {
                _grade = value;
                NotifyPropertyChanged("Grade");
            }
        }

        /// <summary>
        /// Condição da rodovia
        /// </summary>
        [Column("roadCondition")]
        public int? RoadCondition
        {
            get { return _roadCondition; }
            set
            {
                _roadCondition = value;
                NotifyPropertyChanged("RoadCondition");
            }
        }

        /// <summary>
        /// Resistência ao deslizamento/aderência
        /// </summary>
        [Column("skidResistanceGrip")]
        public int? SkidResistanceGrip
        {
            get { return _skidResistanceGrip; }
            set
            {
                _skidResistanceGrip = value;
                NotifyPropertyChanged("SkidResistanceGrip");
            }
        }

        /// <summary>
        /// Delineamento
        /// </summary>
        [Column("delineation")]
        public int? Delineation
        {
            get { return _delineation; }
            set
            {
                _delineation = value;
                NotifyPropertyChanged("Delineation");
            }
        }

        /// <summary>
        /// Iluminação pública da via
        /// </summary>
        [Column("streetLighting")]
        public int? StreetLighting
        {
            get { return _streetLighting; }
            set
            {
                _streetLighting = value;
                NotifyPropertyChanged("StreetLighting");
            }
        }

        /// <summary>
        /// Infraestrutura para travessia de pedestres – na rodovia inspeção
        /// </summary>
        [Column("pedestrianCrossingInspectedRoad")]
        public int? PedestrianCrossingInspectedRoad
        {
            get { return _pedestrianCrossingInspectedRoad; }
            set
            {
                _pedestrianCrossingInspectedRoad = value;
                NotifyPropertyChanged("PedestrianCrossingInspectedRoad");
            }
        }

        /// <summary>
        /// Qualidade da travessia de pedestres
        /// </summary>
        [Column("pedestrianCrossingQuality")]
        public int? PedestrianCrossingQuality
        {
            get { return _pedestrianCrossingQuality; }
            set
            {
                _pedestrianCrossingQuality = value;
                NotifyPropertyChanged("PedestrianCrossingQuality");
            }
        }

        /// <summary>
        /// Infraestrutura para travessia de pedestres – na via transversal
        /// </summary>
        [Column("pedestrianCrossingFacilitiesSideRoad")]
        public int? PedestrianCrossingFacilitiesSideRoad
        {
            get { return _pedestrianCrossingFacilitiesSideRoad; }
            set
            {
                _pedestrianCrossingFacilitiesSideRoad = value;
                NotifyPropertyChanged("PedestrianCrossingFacilitiesSideRoad");
            }
        }

        /// <summary>
        /// Canalização de pedestres
        /// </summary>
        [Column("pedestrianFencing")]
        public int? PedestrianFencing
        {
            get { return _pedestrianFencing; }
            set
            {
                _pedestrianFencing = value;
                NotifyPropertyChanged("PedestrianFencing");
            }
        }

        /// <summary>
        /// Gestão de velocidade/redutor de velocidade
        /// </summary>
        [Column("speedManagementTrafficCalming")]
        public int? SpeedManagementTrafficCalming
        {
            get { return _speedManagementTrafficCalming; }
            set
            {
                _speedManagementTrafficCalming = value;
                NotifyPropertyChanged("SpeedManagementTrafficCalming");
            }
        }

        /// <summary>
        /// Estacionamento para veículos
        /// </summary>
        [Column("vehicleParking")]
        public int? VehicleParking
        {
            get { return _vehicleParking; }
            set
            {
                _vehicleParking = value;
                NotifyPropertyChanged("VehicleParking");
            }
        }

        /// <summary>
        /// Calçada ou caminho informal - do lado do condutor
        /// </summary>
        [Column("sidewalkDriversSide")]
        public int? SidewalkDriversSide
        {
            get { return _sidewalkDriversSide; }
            set
            {
                _sidewalkDriversSide = value;
                NotifyPropertyChanged("SidewalkDriversSide");
            }
        }

        /// <summary>
        /// Calçada ou caminho informal - do lado do passageiro
        /// </summary>
        [Column("sidewalkPassengerSide")]
        public int? SidewalkPassengerSide
        {
            get { return _sidewalkPassengerSide; }
            set
            {
                _sidewalkPassengerSide = value;
                NotifyPropertyChanged("SidewalkPassengerSide");
            }
        }

        /// <summary>
        /// Rua lateral
        /// </summary>
        [Column("serviceRoad")]
        public int? ServiceRoad
        {
            get { return _serviceRoad; }
            set
            {
                _serviceRoad = value;
                NotifyPropertyChanged("ServiceRoad");
            }
        }

        /// <summary>
        /// Infraestrutura para veículos motorizados de duas rodas
        /// </summary>
        [Column("facilitiesMotorisedTwoWheelers")]
        public int? FacilitiesMotorisedTwoWheelers
        {
            get { return _facilitiesMotorisedTwoWheelers; }
            set
            {
                _facilitiesMotorisedTwoWheelers = value;
                NotifyPropertyChanged("FacilitiesMotorisedTwoWheelers");
            }
        }

        /// <summary>
        /// Infraestrutura para bicicletas
        /// </summary>
        [Column("bicycleFacility")]
        public int? BicycleFacility
        {
            get { return _bicycleFacility; }
            set
            {
                _bicycleFacility = value;
                NotifyPropertyChanged("BicycleFacility");
            }
        }

        /// <summary>
        /// Obras viárias
        /// </summary>
        [Column("roadworks")]
        public int? Roadworks
        {
            get { return _roadworks; }
            set
            {
                _roadworks = value;
                NotifyPropertyChanged("Roadworks");
            }
        }

        /// <summary>
        /// Distância de visibilidade
        /// </summary>
        [Column("sightDistance")]
        public int? SightDistance
        {
            get { return _sightDistance; }
            set
            {
                _sightDistance = value;
                NotifyPropertyChanged("SightDistance");
            }
        }

        /// <summary>
        /// Fluxo de veículos (VMDA)
        /// </summary>
        [Column("vehicleFlow")]
        public int? VehicleFlow
        {
            get { return _vehicleFlow; }
            set
            {
                _vehicleFlow = value;
                NotifyPropertyChanged("VehicleFlow");
            }
        }

        /// <summary>
        /// Percentagem (%) de motocicletas
        /// </summary>
        [Column("motorcyclePercentual")]
        public int? MotorcyclePercentual
        {
            get { return _motorcyclePercentual; }
            set
            {
                _motorcyclePercentual = value;
                NotifyPropertyChanged("MotorcyclePercentual");
            }
        }

        /// <summary>
        /// Fluxo de pedestres atravessando a via em horário de pico
        /// </summary>
        [Column("pedestrianPeakHourFlowAcrossRoad")]
        public int? PedestrianPeakHourFlowAcrossRoad
        {
            get { return _pedestrianPeakHourFlowAcrossRoad; }
            set
            {
                _pedestrianPeakHourFlowAcrossRoad = value;
                NotifyPropertyChanged("PedestrianPeakHourFlowAcrossRoad");
            }
        }

        /// <summary>
        /// Fluxo de pedestres na hora de pico ao longo da rodovia do lado do condutor
        /// </summary>
        [Column("pedestrianPeakHourFlowAlongRoadDriver")]
        public int? PedestrianPeakHourFlowAlongRoadDriver
        {
            get { return _pedestrianPeakHourFlowAlongRoadDriver; }
            set
            {
                _pedestrianPeakHourFlowAlongRoadDriver = value;
                NotifyPropertyChanged("PedestrianPeakHourFlowAlongRoadDriver");
            }
        }

        /// <summary>
        /// Fluxo de pedestres na hora de pico ao longo da rodovia do lado do passageiro
        /// </summary>
        [Column("pedestrianPeakHourFlowAlongRoadPassenger")]
        public int? PedestrianPeakHourFlowAlongRoadPassenger
        {
            get { return _pedestrianPeakHourFlowAlongRoadPassenger; }
            set
            {
                _pedestrianPeakHourFlowAlongRoadPassenger = value;
                NotifyPropertyChanged("PedestrianPeakHourFlowAlongRoadPassenger");
            }
        }

        /// <summary>
        /// Fluxo de bicicletas no horário de pico
        /// </summary>
        [Column("bicyclePeakHourlyFlow")]
        public int? BicyclePeakHourlyFlow
        {
            get { return _bicyclePeakHourlyFlow; }
            set
            {
                _bicyclePeakHourlyFlow = value;
                NotifyPropertyChanged("BicyclePeakHourlyFlow");
            }
        }

        /// <summary>
        /// Velocidade de operação (percentil 85)
        /// </summary>
        [Column("operatingSpeed85thPercentile")]
        public int? OperatingSpeed85thPercentile
        {
            get { return _operatingSpeed85thPercentile; }
            set
            {
                _operatingSpeed85thPercentile = value;
                NotifyPropertyChanged("OperatingSpeed85thPercentile");
            }
        }

        /// <summary>
        /// Velocidade de operação (médio)
        /// </summary>
        [Column("operatingSpeedMean")]
        public int? OperatingSpeedMean
        {
            get { return _operatingSpeedMean; }
            set
            {
                _operatingSpeedMean = value;
                NotifyPropertyChanged("OperatingSpeedMean");
            }
        }

        /// <summary>
        /// Vias que os veículos podem ler
        /// </summary>
        [Column("roadsCarsRead")]
        public int? RoadsCarsRead
        {
            get { return _roadsCarsRead; }
            set
            {
                _roadsCarsRead = value;
                NotifyPropertyChanged("RoadsCarsRead");
            }
        }

        /// <summary>
        /// Metas de política de Classificação por Estrelas para carros
        /// </summary>
        [Column("carStarRatingPolicyTarget")]
        public int? CarStarRatingPolicyTarget
        {
            get { return _carStarRatingPolicyTarget; }
            set
            {
                _carStarRatingPolicyTarget = value;
                NotifyPropertyChanged("CarStarRatingPolicyTarget");
            }
        }

        /// <summary>
        /// Metas de política de Classificação por Estrelas para motocicletas
        /// </summary>
        [Column("motorcycleStarRatingPolicyTarget")]
        public int? MotorcycleStarRatingPolicyTarget
        {
            get { return _motorcycleStarRatingPolicyTarget; }
            set
            {
                _motorcycleStarRatingPolicyTarget = value;
                NotifyPropertyChanged("MotorcycleStarRatingPolicyTarget");
            }
        }

        /// <summary>
        /// Metas de política de Classificação por Estrelas para pedestres
        /// </summary>
        [Column("pedestrianStarRatingPolicyTarget")]
        public int? PedestrianStarRatingPolicyTarget
        {
            get { return _pedestrianStarRatingPolicyTarget; }
            set
            {
                _pedestrianStarRatingPolicyTarget = value;
                NotifyPropertyChanged("PedestrianStarRatingPolicyTarget");
            }
        }

        /// <summary>
        /// Metas de política de Classificação por Estrelas para bicicletas
        /// </summary>
        [Column("bicycleStarRatingPolicyTarget")]
        public int? BicycleStarRatingPolicyTarget
        {
            get { return _bicycleStarRatingPolicyTarget; }
            set
            {
                _bicycleStarRatingPolicyTarget = value;
                NotifyPropertyChanged("BicycleStarRatingPolicyTarget");
            }
        }

        /// <summary>
        /// Multiplicador do número anual de fatalidades
        /// </summary>
        [Column("annualFatalityGrowthMultiplier")]
        public int? AnnualFatalityGrowthMultiplier
        {
            get { return _annualFatalityGrowthMultiplier; }
            set
            {
                _annualFatalityGrowthMultiplier = value;
                NotifyPropertyChanged("AnnualFatalityGrowthMultiplier");
            }
        }

        /// <summary>
        /// Advertência de zona escolar
        /// </summary>
        [Column("schoolZoneWarning")]
        public int? SchoolZoneWarning
        {
            get { return _schoolZoneWarning; }
            set
            {
                _schoolZoneWarning = value;
                NotifyPropertyChanged("SchoolZoneWarning");
            }
        }

        /// <summary>
        /// Supervisor de travessia em zona escolar
        /// </summary>
        [Column("schoolZoneCrossingSupervisor")]
        public int? SchoolZoneCrossingSupervisor
        {
            get { return _schoolZoneCrossingSupervisor; }
            set
            {
                _schoolZoneCrossingSupervisor = value;
                NotifyPropertyChanged("SchoolZoneCrossingSupervisor");
            }
        }

        /// <summary>
        /// Data da atualização do registro
        /// </summary>
        [Column("updateDate")]
        public DateTime? UpdateDate
        {
            get { return _updateDate; }
            set
            {
                _updateDate = value;
                NotifyPropertyChanged("UpdateDate");
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void NotifyPropertyChanged(string info)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(info));
            }
        }

    }
}
