﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;


namespace pavesys_iRAP.Business
{
    internal static class RadiusCalc
    {
        public static double Circumcircle_Radius((decimal,decimal) lonlat1, (decimal,decimal) lonlat2, (decimal,decimal) lonlat3) 
        {
            
            var d12 = InputXML.CalculateHaversine((double)lonlat1.Item2,(double)lonlat1.Item1, (double)lonlat2.Item2, (double)lonlat2.Item1);
            var d23 = InputXML.CalculateHaversine((double)lonlat2.Item2, (double)lonlat2.Item1, (double)lonlat3.Item2, (double)lonlat3.Item1);
            var d31 = InputXML.CalculateHaversine((double)lonlat3.Item2, (double)lonlat3.Item1, (double)lonlat1.Item2, (double)lonlat1.Item1);

            var s = (d12 + d23 + d31) / 2;
            var area = Math.Sqrt(s * (s - d12) * (s - d23) * (s - d31));

            return (d12 * d23 * d31) / (4 * area);
        }

        public static int RadiusToIrapIndex(double radius) 
        {
            if (radius <= 200)
            {
                return 4;
            }
            else if (radius > 200 && radius <= 400)
            {
                return 3;
            }
            else if (radius > 400 && radius <= 800)
            {
                return 2;
            }
            else
                return 1;
        }

    }
}
