using Avalonia;
using Avalonia.Controls.ApplicationLifetimes;
using Avalonia.Markup.Xaml;
using pavesys_iRAP.Business;
using pavesys_iRAP.ViewModels;
using pavesys_iRAP.Views;
using System;
using Serilog;
using System.Diagnostics;
using Microsoft.EntityFrameworkCore;
using Microsoft.Data.SqlClient;
using pavesys_iRAP.Helper;
using System.Threading.Tasks;

namespace pavesys_iRAP
{
    public partial class App : Application
    {
        public override void Initialize()
        {
            AvaloniaXamlLoader.Load(this);
        }

        public override async void OnFrameworkInitializationCompleted()
        {
            if (ApplicationLifetime is IClassicDesktopStyleApplicationLifetime desktop)
            {
                // Create the splash screen
                var splashScreenVM = new SplashScreenViewModel();
                var splashScreen = new SplashScreenView
                {
                    DataContext = splashScreenVM
                };

                desktop.MainWindow = splashScreen;
                splashScreen.Show();

                await Task.Delay(2500);
                var mainWin = new MainWindow
                {
                    DataContext = new MainWindowViewModel(),
                };
                desktop.MainWindow = mainWin;
                mainWin.Show();

                // Get rid of the splash screen
                splashScreen.Close();


                try
                {
                    var dbTest = CrudHelper.dbCtx;
                    DatabaseHelper.SetupDataBase();

                }
                catch (Exception e)
                {
                    Log.Fatal(e, "Failed to connect to the database");
                    //Environment.Exit(1);
                }



                desktop.MainWindow = new MainWindow
                {
                    DataContext = new MainWindowViewModel()
                };
            }

            base.OnFrameworkInitializationCompleted();
        }
    }
}