/*! For license information please see LICENSES */
(window.webpackJsonp=window.webpackJsonp||[]).push([[30],{1290:function(e,t,n){var content=n(1291);content.__esModule&&(content=content.default),"string"==typeof content&&(content=[[e.i,content,""]]),content.locals&&(e.exports=content.locals);(0,n(121).default)("16314d7c",content,!0,{sourceMap:!1})},1291:function(e,t,n){var o=n(120)(!1);o.push([e.i,'/*!\n * Viewer.js v1.10.3\n * https://fengyuanchen.github.io/viewerjs\n *\n * Copyright 2015-present Chen Fengyuan\n * Released under the MIT license\n *\n * Date: 2022-02-02T05:14:59.271Z\n */.viewer-close:before,.viewer-flip-horizontal:before,.viewer-flip-vertical:before,.viewer-fullscreen-exit:before,.viewer-fullscreen:before,.viewer-next:before,.viewer-one-to-one:before,.viewer-play:before,.viewer-prev:before,.viewer-reset:before,.viewer-rotate-left:before,.viewer-rotate-right:before,.viewer-zoom-in:before,.viewer-zoom-out:before{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAARgAAAAUCAYAAABWOyJDAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAQPSURBVHic7Zs/iFxVFMa/0U2UaJGksUgnIVhYxVhpjDbZCBmLdAYECxsRFBTUamcXUiSNncgKQbSxsxH8gzAP3FU2jY0kKKJNiiiIghFlccnP4p3nPCdv3p9778vsLOcHB2bfveeb7955c3jvvNkBIMdxnD64a94GHMfZu3iBcRynN7zAOI7TG15gHCeeNUkr8zaxG2lbYDYsdgMbktBsP03jdQwljSXdtBhLOmtjowC9Mg9L+knSlcD8TNKpSA9lBpK2JF2VdDSR5n5J64m0qli399hNFMUlpshQii5jbXTbHGviB0nLNeNDSd9VO4A2UdB2fp+x0eCnaXxWXGA2X0au/3HgN9P4LFCjIANOJdrLr0zzZ+BEpNYDwKbpnQMeAw4m8HjQtM6Z9qa917zPQwFr3M5KgA6J5rTJCdFZJj9/lyvGhsDvwFNVuV2MhhjrK6b9bFiE+j1r87eBl4HDwCF7/U/k+ofAX5b/EXBv5JoLMuILzf3Ap6Z3EzgdqHMCuF7hcQf4HDgeoHnccncqdK/TvSDWffFXI/exICY/xZyqc6XLWF1UFZna4gJ7q8BsRvgd2/xXpo6P+D9dfT7PpECtA3cnWPM0GXGFZh/wgWltA+cDNC7X+AP4GzjZQe+k5dRxuYPeiuXU7e1qwLpDz7dFjXKRaSwuMLvAlG8zZlG+YmiK1HoFqT7wP2z+4Q45TfEGcMt01xLoNZEBTwRqD4BLpnMLeC1A41UmVxsXgXeBayV/Wx20rpTyrpnWRft7p6O/FdqzGrDukPNtkaMoMo3FBdBSQMOnYBCReyf05s126fU9ytfX98+mY54Kxnp7S9K3kj6U9KYdG0h6UdLbkh7poFXMfUnSOyVvL0h6VtIXHbS6nOP+s/Zm9mvyXW1uuC9ohZ72E9uDmXWLJOB1GxsH+DxPftsB8B6wlGDN02TAkxG6+4D3TWsbeC5CS8CDFce+AW500LhhOW2020TRjK3b21HEmgti9m0RonxbdMZeVzV+/4tF3cBpP7E9mKHNL5q8h5g0eYsCMQz0epq8gQrwMXAgcs0FGXGFRcB9wCemF9PkbYqM/Bas7fxLwNeJPdTdpo4itQti8lPMqTpXuozVRVXPpbHI3KkNTB1NfkL81j2mvhDp91HgV9MKuRIqrykj3WPq4rHyL+axj8/qGPmTqi6F9YDlHOvJU6oYcTsh/TYSzWmTE6JT19CtLTJt32D6CmHe0eQn1O8z5AXgT4sx4Vcu0/EQecMydB8z0hUWkTd2t4CrwNEePqMBcAR4mrBbwyXLPWJa8zrXmmLEhNBmfpkuY2102xxrih+pb+ieAb6vGhuA97UcJ5KR8gZ77K+99xxeYBzH6Q3/Z0fHcXrDC4zjOL3hBcZxnN74F+zlvXFWXF9PAAAAAElFTkSuQmCC");background-repeat:no-repeat;background-size:280px;color:transparent;display:block;font-size:0;height:20px;line-height:0;width:20px}.viewer-zoom-in:before{background-position:0 0;content:"Zoom In"}.viewer-zoom-out:before{background-position:-20px 0;content:"Zoom Out"}.viewer-one-to-one:before{background-position:-40px 0;content:"One to One"}.viewer-reset:before{background-position:-60px 0;content:"Reset"}.viewer-prev:before{background-position:-80px 0;content:"Previous"}.viewer-play:before{background-position:-100px 0;content:"Play"}.viewer-next:before{background-position:-120px 0;content:"Next"}.viewer-rotate-left:before{background-position:-140px 0;content:"Rotate Left"}.viewer-rotate-right:before{background-position:-160px 0;content:"Rotate Right"}.viewer-flip-horizontal:before{background-position:-180px 0;content:"Flip Horizontal"}.viewer-flip-vertical:before{background-position:-200px 0;content:"Flip Vertical"}.viewer-fullscreen:before{background-position:-220px 0;content:"Enter Full Screen"}.viewer-fullscreen-exit:before{background-position:-240px 0;content:"Exit Full Screen"}.viewer-close:before{background-position:-260px 0;content:"Close"}.viewer-container{bottom:0;direction:ltr;font-size:0;left:0;line-height:0;overflow:hidden;position:absolute;right:0;-webkit-tap-highlight-color:transparent;top:0;touch-action:none;-webkit-touch-callout:none;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.viewer-container::-moz-selection,.viewer-container ::-moz-selection{background-color:transparent}.viewer-container::selection,.viewer-container ::selection{background-color:transparent}.viewer-container:focus{outline:0}.viewer-container img{display:block;height:auto;max-height:none!important;max-width:none!important;min-height:0!important;min-width:0!important;width:100%}.viewer-canvas{bottom:0;left:0;overflow:hidden;position:absolute;right:0;top:0}.viewer-canvas>img{height:auto;margin:15px auto;max-width:90%!important;width:auto}.viewer-footer{bottom:0;left:0;overflow:hidden;position:absolute;right:0;text-align:center}.viewer-navbar{background-color:rgb(0 0 0/50%);overflow:hidden}.viewer-list{box-sizing:content-box;height:50px;margin:0;overflow:hidden;padding:1px 0}.viewer-list>li{color:transparent;cursor:pointer;float:left;font-size:0;height:50px;line-height:0;opacity:.5;overflow:hidden;transition:opacity .15s;width:30px}.viewer-list>li:focus,.viewer-list>li:hover{opacity:.75}.viewer-list>li:focus{outline:0}.viewer-list>li+li{margin-left:1px}.viewer-list>.viewer-loading{position:relative}.viewer-list>.viewer-loading:after{border-width:2px;height:20px;margin-left:-10px;margin-top:-10px;width:20px}.viewer-list>.viewer-active,.viewer-list>.viewer-active:focus,.viewer-list>.viewer-active:hover{opacity:1}.viewer-player{background-color:#000;bottom:0;cursor:none;display:none;right:0;z-index:1}.viewer-player,.viewer-player>img{left:0;position:absolute;top:0}.viewer-toolbar>ul{display:inline-block;margin:0 auto 5px;overflow:hidden;padding:6px 3px}.viewer-toolbar>ul>li{background-color:rgb(0 0 0/50%);border-radius:50%;cursor:pointer;float:left;height:24px;overflow:hidden;transition:background-color .15s;width:24px}.viewer-toolbar>ul>li:focus,.viewer-toolbar>ul>li:hover{background-color:rgb(0 0 0/80%)}.viewer-toolbar>ul>li:focus{box-shadow:0 0 3px #fff;outline:0;position:relative;z-index:1}.viewer-toolbar>ul>li:before{margin:2px}.viewer-toolbar>ul>li+li{margin-left:1px}.viewer-toolbar>ul>.viewer-small{height:18px;margin-bottom:3px;margin-top:3px;width:18px}.viewer-toolbar>ul>.viewer-small:before{margin:-1px}.viewer-toolbar>ul>.viewer-large{height:30px;margin-bottom:-3px;margin-top:-3px;width:30px}.viewer-toolbar>ul>.viewer-large:before{margin:5px}.viewer-tooltip{background-color:rgb(0 0 0/80%);border-radius:10px;color:#fff;display:none;font-size:12px;height:20px;left:50%;line-height:20px;margin-left:-25px;margin-top:-10px;position:absolute;text-align:center;top:50%;width:50px}.viewer-title{color:#ccc;display:inline-block;font-size:12px;line-height:1.2;margin:0 5% 5px;max-width:90%;opacity:.8;overflow:hidden;text-overflow:ellipsis;transition:opacity .15s;white-space:nowrap}.viewer-title:hover{opacity:1}.viewer-button{background-color:rgb(0 0 0/50%);border-radius:50%;cursor:pointer;height:80px;overflow:hidden;position:absolute;right:-40px;top:-40px;transition:background-color .15s;width:80px}.viewer-button:focus,.viewer-button:hover{background-color:rgb(0 0 0/80%)}.viewer-button:focus{box-shadow:0 0 3px #fff;outline:0}.viewer-button:before{bottom:15px;left:15px;position:absolute}.viewer-fixed{position:fixed}.viewer-open{overflow:hidden}.viewer-show{display:block}.viewer-hide{display:none}.viewer-backdrop{background-color:rgb(0 0 0/50%)}.viewer-invisible{visibility:hidden}.viewer-move{cursor:move;cursor:-webkit-grab;cursor:grab}.viewer-fade{opacity:0}.viewer-in{opacity:1}.viewer-transition{transition:all .3s}@-webkit-keyframes viewer-spinner{0%{transform:rotate(0deg)}to{transform:rotate(1turn)}}@keyframes viewer-spinner{0%{transform:rotate(0deg)}to{transform:rotate(1turn)}}.viewer-loading:after{-webkit-animation:viewer-spinner 1s linear infinite;animation:viewer-spinner 1s linear infinite;border:4px solid rgb(255 255 255/10%);border-left-color:rgb(255 255 255/50%);border-radius:50%;content:"";display:inline-block;height:40px;left:50%;margin-left:-20px;margin-top:-20px;position:absolute;top:50%;width:40px;z-index:1}@media (max-width:767px){.viewer-hide-xs-down{display:none}}@media (max-width:991px){.viewer-hide-sm-down{display:none}}@media (max-width:1199px){.viewer-hide-md-down{display:none}}',""]),e.exports=o},1292:function(e,t,n){"use strict";(function(e){n.d(t,"a",(function(){return ue}));var o=n(992),r=n.n(o),l=n(14);const c="undefined"!=typeof window&&null!==window;!function(){if(c&&"IntersectionObserver"in window&&"IntersectionObserverEntry"in window&&"intersectionRatio"in window.IntersectionObserverEntry.prototype)return"isIntersecting"in window.IntersectionObserverEntry.prototype||Object.defineProperty(window.IntersectionObserverEntry.prototype,"isIntersecting",{get(){return this.intersectionRatio>0}}),!0}();const h=Object.prototype.propertyIsEnumerable,d=Object.getOwnPropertySymbols;function f(e){return"function"==typeof e||"[object Object]"===toString.call(e)}function v(e){return"__proto__"!==e&&"constructor"!==e&&"prototype"!==e}function m(e,...t){if(!f(e))throw new TypeError("expected the first argument to be an object");if(0===t.length||"function"!=typeof Symbol||"function"!=typeof d)return e;for(const n of t){const t=d(n);for(const o of t)h.call(n,o)&&(e[o]=n[o])}return e}function w(e,...t){let i=0;var n;for(("object"==typeof(n=e)?null===n:"function"!=typeof n)&&(e=t[i++]),e||(e={});i<t.length;i++)if(f(t[i])){for(const n of Object.keys(t[i]))v(n)&&(f(e[n])&&f(t[i][n])?w(e[n],t[i][n]):e[n]=t[i][n]);m(e,t[i])}return e}function y(e,t,n,o,r,l,c,h){var d,f="function"==typeof e?e.options:e;if(t&&(f.render=t,f.staticRenderFns=n,f._compiled=!0),o&&(f.functional=!0),l&&(f._scopeId="data-v-"+l),c?(d=function(e){(e=e||this.$vnode&&this.$vnode.ssrContext||this.parent&&this.parent.$vnode&&this.parent.$vnode.ssrContext)||"undefined"==typeof __VUE_SSR_CONTEXT__||(e=__VUE_SSR_CONTEXT__),r&&r.call(this,e),e&&e._registeredComponents&&e._registeredComponents.add(c)},f._ssrRegister=d):r&&(d=h?function(){r.call(this,(f.functional?this.parent:this).$root.$options.shadowRoot)}:r),d)if(f.functional){f._injectStyles=d;var v=f.render;f.render=function(e,t){return d.call(t),v(e,t)}}else{var m=f.beforeCreate;f.beforeCreate=m?[].concat(m,d):[d]}return{exports:e,options:f}}const x={props:{images:{type:Array},rebuild:{type:Boolean,default:!1},trigger:{},options:{type:Object}},data:()=>({}),computed:{},watch:{images(){this.$nextTick((()=>{this.onChange()}))},trigger:{handler(){this.$nextTick((()=>{this.onChange()}))},deep:!0},options:{handler(){this.$nextTick((()=>{this.rebuildViewer()}))},deep:!0}},mounted(){this.createViewer()},unmounted(){this.destroyViewer()},methods:{onChange(){this.rebuild?this.rebuildViewer():this.updateViewer()},rebuildViewer(){this.destroyViewer(),this.createViewer()},updateViewer(){this.$viewer?(this.$viewer.update(),this.$emit("inited",this.$viewer)):this.createViewer()},destroyViewer(){this.$viewer&&this.$viewer.destroy()},createViewer(){this.$viewer=new r.a(this.$el,this.options),this.$emit("inited",this.$viewer)}}},k={};var A=y(x,(function(){var e=this,t=e.$createElement;return(e._self._c||t)("div",[e._t("default",null,{images:e.images,options:e.options})],2)}),[],!1,z,null,null,null);function z(e){for(let e in k)this[e]=k[e]}var component=function(){return A.exports}(),T="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:void 0!==e?e:"undefined"!=typeof self?self:{};var O=function(e){var t=typeof e;return null!=e&&("object"==t||"function"==t)},E="object"==typeof T&&T&&T.Object===Object&&T,D="object"==typeof self&&self&&self.Object===Object&&self,C=E||D||Function("return this")(),S=C,I=function(){return S.Date.now()},F=/\s/;var M=function(e){for(var t=e.length;t--&&F.test(e.charAt(t)););return t},R=/^\s+/;var L=function(e){return e?e.slice(0,M(e)+1).replace(R,""):e},N=C.Symbol,X=N,j=Object.prototype,P=j.hasOwnProperty,Y=j.toString,$=X?X.toStringTag:void 0;var V=function(e){var t=P.call(e,$),n=e[$];try{e[$]=void 0;var o=!0}catch(e){}var r=Y.call(e);return o&&(t?e[$]=n:delete e[$]),r},W=Object.prototype.toString;var B=V,_=function(e){return W.call(e)},H=N?N.toStringTag:void 0;var U=function(e){return null==e?void 0===e?"[object Undefined]":"[object Null]":H&&H in Object(e)?B(e):_(e)},Z=function(e){return null!=e&&"object"==typeof e};var K=L,G=O,J=function(e){return"symbol"==typeof e||Z(e)&&"[object Symbol]"==U(e)},Q=/^[-+]0x[0-9a-f]+$/i,ee=/^0b[01]+$/i,te=/^0o[0-7]+$/i,ie=parseInt;var ne=O,oe=I,re=function(e){if("number"==typeof e)return e;if(J(e))return NaN;if(G(e)){var t="function"==typeof e.valueOf?e.valueOf():e;e=G(t)?t+"":t}if("string"!=typeof e)return 0===e?e:+e;e=K(e);var n=ee.test(e);return n||te.test(e)?ie(e.slice(2),n?2:8):Q.test(e)?NaN:+e},ae=Math.max,se=Math.min;var le=function(e,t,n){var o,r,l,c,h,d,f=0,v=!1,m=!1,w=!0;if("function"!=typeof e)throw new TypeError("Expected a function");function y(time){var t=o,n=r;return o=r=void 0,f=time,c=e.apply(n,t)}function x(time){return f=time,h=setTimeout(A,t),v?y(time):c}function k(time){var e=time-d;return void 0===d||e>=t||e<0||m&&time-f>=l}function A(){var time=oe();if(k(time))return z(time);h=setTimeout(A,function(time){var e=t-(time-d);return m?se(e,l-(time-f)):e}(time))}function z(time){return h=void 0,w&&o?y(time):(o=r=void 0,c)}function T(){var time=oe(),e=k(time);if(o=arguments,r=this,d=time,e){if(void 0===h)return x(d);if(m)return clearTimeout(h),h=setTimeout(A,t),y(d)}return void 0===h&&(h=setTimeout(A,t)),c}return t=re(t)||0,ne(n)&&(v=!!n.leading,l=(m="maxWait"in n)?ae(re(n.maxWait)||0,t):l,w="trailing"in n?!!n.trailing:w),T.cancel=function(){void 0!==h&&clearTimeout(h),f=0,o=d=r=h=void 0},T.flush=function(){return void 0===h?c:z(oe())},T};const ce=({name:e="viewer",debug:t=!1}={})=>{function n(t,n,c=!1,d=!1){l.default.nextTick((()=>{d&&!function(e){const t=e.innerHTML.match(/<img([\w\W]+?)[\\/]?>/g),n=t?t.join(""):void 0;return e.__viewerImageDiffCache===n?(h("Element change detected, but image(s) has not changed"),!1):(h("Image change detected"),e.__viewerImageDiffCache=n,!0)}(t)||(c||!t[`$${e}`]?(o(t),t[`$${e}`]=new r.a(t,n),h("Viewer created")):(t[`$${e}`].update(),h("Viewer updated")))}))}function o(t){t[`$${e}`]&&(t[`$${e}`].destroy(),delete t[`$${e}`],h("Viewer destroyed"))}function c(e){e.__viewerMutationObserver&&(e.__viewerMutationObserver.disconnect(),delete e.__viewerMutationObserver,h("Observer destroyed"))}function h(){t&&console.log(...arguments)}return{bind(e,t,o){h("Viewer bind");const r=le(n,50);r(e,t.value),function(e,{expression:t},n,o){t&&/^[A-Za-z_$][\w$]*(?:\.[A-Za-z_$][\w$]*|\['[^']*?']|\["[^"]*?"]|\[\d+]|\[[A-Za-z_$][\w$]*])*$/.test(t)?(e.__viewerUnwatch=n.context.$watch(t,((n,r)=>{h("Change detected by watcher: ",t),o(e,n,!0)}),{deep:!0}),h("Watcher created, expression: ",t)):h("Only simple dot-delimited paths can create watcher")}(e,t,o,r),t.modifiers.static||function(e,t,n,o){c(e);const r=window.MutationObserver||window.WebKitMutationObserver||window.MozMutationObserver;if(!r)return void h("Observer not supported");const l=new r((r=>{r.forEach((r=>{h(`Viewer mutation:${r.type}`),n(e,t,o,!0)}))}));l.observe(e,{attributes:!0,childList:!0,characterData:!0,subtree:!0}),e.__viewerMutationObserver=l,h("Observer created")}(e,t.value,r,t.modifiers.rebuild)},unbind(e,t){h("Viewer unbind"),c(e),function(e){e.__viewerUnwatch&&(e.__viewerUnwatch(),delete e.__viewerUnwatch,h("Watcher destroyed"))}(e),o(e)}}},he=({images:e=[],options:t={}}={})=>{t=w(t,{inline:!1});const n=new(l.default.extend({render:t=>t("div",{style:{display:"none"},class:["__viewer-token"]},e.map((e=>t("img",{attrs:"string"==typeof e?{src:e}:e}))))}));n.$mount(),document.body.appendChild(n.$el);const o=new r.a(n.$el,t),c=o.destroy.bind(o);return o.destroy=function(){return c(),n.$destroy(),document.body.removeChild(n.$el),o},o.show(),n.$el.addEventListener("hidden",(function(){this.viewer===o&&o.destroy()})),o};var ue={install(e,{name:t="viewer",debug:n=!1,defaultOptions:o}={}){r.a.setDefaults(o),e.component(t,w(component,{name:t})),e.directive(t,ce({name:t,debug:n})),e.prototype[`$${t}Api`]=he},setDefaults(e){r.a.setDefaults(e)}}}).call(this,n(108))},992:function(e,t,n){e.exports=function(){"use strict";function e(object,e){var t=Object.keys(object);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(object);e&&(n=n.filter((function(e){return Object.getOwnPropertyDescriptor(object,e).enumerable}))),t.push.apply(t,n)}return t}function t(t){for(var i=1;i<arguments.length;i++){var source=null!=arguments[i]?arguments[i]:{};i%2?e(Object(source),!0).forEach((function(e){c(t,e,source[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(source)):e(Object(source)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(source,e))}))}return t}function n(e){return n="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},n(e)}function o(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function r(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}function l(e,t,n){return t&&r(e.prototype,t),n&&r(e,n),Object.defineProperty(e,"prototype",{writable:!1}),e}function c(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}var h={backdrop:!0,button:!0,navbar:!0,title:!0,toolbar:!0,className:"",container:"body",filter:null,fullscreen:!0,inheritedAttributes:["crossOrigin","decoding","isMap","loading","referrerPolicy","sizes","srcset","useMap"],initialViewIndex:0,inline:!1,interval:5e3,keyboard:!0,focus:!0,loading:!0,loop:!0,minWidth:200,minHeight:100,movable:!0,rotatable:!0,scalable:!0,zoomable:!0,zoomOnTouch:!0,zoomOnWheel:!0,slideOnTouch:!0,toggleOnDblclick:!0,tooltip:!0,transition:!0,zIndex:2015,zIndexInline:0,zoomRatio:.1,minZoomRatio:.01,maxZoomRatio:100,url:"src",ready:null,show:null,shown:null,hide:null,hidden:null,view:null,viewed:null,move:null,moved:null,rotate:null,rotated:null,scale:null,scaled:null,zoom:null,zoomed:null,play:null,stop:null},d='<div class="viewer-container" tabindex="-1" touch-action="none"><div class="viewer-canvas"></div><div class="viewer-footer"><div class="viewer-title"></div><div class="viewer-toolbar"></div><div class="viewer-navbar"><ul class="viewer-list" role="navigation"></ul></div></div><div class="viewer-tooltip" role="alert" aria-hidden="true"></div><div class="viewer-button" data-viewer-action="mix" role="button"></div><div class="viewer-player"></div></div>',f="undefined"!=typeof window&&void 0!==window.document,v=f?window:{},m=!(!f||!v.document.documentElement)&&"ontouchstart"in v.document.documentElement,w=!!f&&"PointerEvent"in v,y="viewer",x="move",k="switch",A="zoom",z="".concat(y,"-active"),T="".concat(y,"-close"),O="".concat(y,"-fade"),E="".concat(y,"-fixed"),D="".concat(y,"-fullscreen"),C="".concat(y,"-fullscreen-exit"),S="".concat(y,"-hide"),I="".concat(y,"-hide-md-down"),F="".concat(y,"-hide-sm-down"),M="".concat(y,"-hide-xs-down"),R="".concat(y,"-in"),L="".concat(y,"-invisible"),N="".concat(y,"-loading"),X="".concat(y,"-move"),j="".concat(y,"-open"),P="".concat(y,"-show"),Y="".concat(y,"-transition"),$="click",V="dblclick",W="dragstart",B="focusin",_="keydown",H="load",U="error",Z=m?"touchend touchcancel":"mouseup",K=m?"touchmove":"mousemove",G=m?"touchstart":"mousedown",J=w?"pointerdown":G,Q=w?"pointermove":K,ee=w?"pointerup pointercancel":Z,te="resize",ie="transitionend",ne="wheel",oe="ready",re="show",ae="shown",se="hide",le="hidden",ce="view",he="viewed",ue="move",de="moved",fe="rotate",ve="rotated",pe="scale",me="scaled",ge="zoom",we="zoomed",be="play",ye="stop",xe="".concat(y,"Action"),ke=/\s\s*/,Ae=["zoom-in","zoom-out","one-to-one","reset","prev","play","next","rotate-left","rotate-right","flip-horizontal","flip-vertical"];function ze(e){return"string"==typeof e}var Te=Number.isNaN||v.isNaN;function Oe(e){return"number"==typeof e&&!Te(e)}function Ee(e){return void 0===e}function De(e){return"object"===n(e)&&null!==e}var Ce=Object.prototype.hasOwnProperty;function Se(e){if(!De(e))return!1;try{var t=e.constructor,n=t.prototype;return t&&n&&Ce.call(n,"isPrototypeOf")}catch(e){return!1}}function Ie(e){return"function"==typeof e}function Fe(data,e){if(data&&Ie(e))if(Array.isArray(data)||Oe(data.length)){var i,t=data.length;for(i=0;i<t&&!1!==e.call(data,data[i],i,data);i+=1);}else De(data)&&Object.keys(data).forEach((function(t){e.call(data,data[t],t,data)}));return data}var Me=Object.assign||function(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),o=1;o<t;o++)n[o-1]=arguments[o];return De(e)&&n.length>0&&n.forEach((function(t){De(t)&&Object.keys(t).forEach((function(n){e[n]=t[n]}))})),e},Re=/^(?:width|height|left|top|marginLeft|marginTop)$/;function Le(element,e){var style=element.style;Fe(e,(function(e,t){Re.test(t)&&Oe(e)&&(e+="px"),style[t]=e}))}function Ne(e){return ze(e)?e.replace(/&(?!amp;|quot;|#39;|lt;|gt;)/g,"&amp;").replace(/"/g,"&quot;").replace(/'/g,"&#39;").replace(/</g,"&lt;").replace(/>/g,"&gt;"):e}function Xe(element,e){return!(!element||!e)&&(element.classList?element.classList.contains(e):element.className.indexOf(e)>-1)}function je(element,e){if(element&&e)if(Oe(element.length))Fe(element,(function(t){je(t,e)}));else if(element.classList)element.classList.add(e);else{var t=element.className.trim();t?t.indexOf(e)<0&&(element.className="".concat(t," ").concat(e)):element.className=e}}function Pe(element,e){element&&e&&(Oe(element.length)?Fe(element,(function(t){Pe(t,e)})):element.classList?element.classList.remove(e):element.className.indexOf(e)>=0&&(element.className=element.className.replace(e,"")))}function Ye(element,e,t){e&&(Oe(element.length)?Fe(element,(function(n){Ye(n,e,t)})):t?je(element,e):Pe(element,e))}var $e=/([a-z\d])([A-Z])/g;function Ve(e){return e.replace($e,"$1-$2").toLowerCase()}function We(element,e){return De(element[e])?element[e]:element.dataset?element.dataset[e]:element.getAttribute("data-".concat(Ve(e)))}function Be(element,e,data){De(data)?element[e]=data:element.dataset?element.dataset[e]=data:element.setAttribute("data-".concat(Ve(e)),data)}var _e=function(){var e=!1;if(f){var t=!1,n=function(){},o=Object.defineProperty({},"once",{get:function(){return e=!0,t},set:function(e){t=e}});v.addEventListener("test",n,o),v.removeEventListener("test",n,o)}return e}();function qe(element,e,t){var n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},o=t;e.trim().split(ke).forEach((function(e){if(!_e){var r=element.listeners;r&&r[e]&&r[e][t]&&(o=r[e][t],delete r[e][t],0===Object.keys(r[e]).length&&delete r[e],0===Object.keys(r).length&&delete element.listeners)}element.removeEventListener(e,o,n)}))}function He(element,e,t){var n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},o=t;e.trim().split(ke).forEach((function(e){if(n.once&&!_e){var r=element.listeners,l=void 0===r?{}:r;o=function(){delete l[e][t],element.removeEventListener(e,o,n);for(var r=arguments.length,c=new Array(r),h=0;h<r;h++)c[h]=arguments[h];t.apply(element,c)},l[e]||(l[e]={}),l[e][t]&&element.removeEventListener(e,l[e][t],n),l[e][t]=o,element.listeners=l}element.addEventListener(e,o,n)}))}function Ue(element,e,data,n){var o;return Ie(Event)&&Ie(CustomEvent)?o=new CustomEvent(e,t({bubbles:!0,cancelable:!0,detail:data},n)):(o=document.createEvent("CustomEvent")).initCustomEvent(e,!0,!0,data),element.dispatchEvent(o)}function Ze(element){var e=element.getBoundingClientRect();return{left:e.left+(window.pageXOffset-document.documentElement.clientLeft),top:e.top+(window.pageYOffset-document.documentElement.clientTop)}}function Ke(e){var t=e.rotate,n=e.scaleX,o=e.scaleY,r=e.translateX,l=e.translateY,c=[];Oe(r)&&0!==r&&c.push("translateX(".concat(r,"px)")),Oe(l)&&0!==l&&c.push("translateY(".concat(l,"px)")),Oe(t)&&0!==t&&c.push("rotate(".concat(t,"deg)")),Oe(n)&&1!==n&&c.push("scaleX(".concat(n,")")),Oe(o)&&1!==o&&c.push("scaleY(".concat(o,")"));var h=c.length?c.join(" "):"none";return{WebkitTransform:h,msTransform:h,transform:h}}function Ge(e){return ze(e)?decodeURIComponent(e.replace(/^.*\//,"").replace(/[?&#].*$/,"")):""}var Je=v.navigator&&/(Macintosh|iPhone|iPod|iPad).*AppleWebKit/i.test(v.navigator.userAgent);function Qe(image,e,t){var n=document.createElement("img");if(image.naturalWidth&&!Je)return t(image.naturalWidth,image.naturalHeight),n;var body=document.body||document.documentElement;return n.onload=function(){t(n.width,n.height),Je||body.removeChild(n)},Fe(e.inheritedAttributes,(function(e){var t=image.getAttribute(e);null!==t&&n.setAttribute(e,t)})),n.src=image.src,Je||(n.style.cssText="left:0;max-height:none!important;max-width:none!important;min-height:0!important;min-width:0!important;opacity:0;position:absolute;top:0;z-index:-1;",body.appendChild(n)),n}function et(e){switch(e){case 2:return M;case 3:return F;case 4:return I;default:return""}}function tt(e){var n=t({},e),o=[];return Fe(e,(function(e,t){delete n[t],Fe(n,(function(t){var n=Math.abs(e.startX-t.startX),r=Math.abs(e.startY-t.startY),l=Math.abs(e.endX-t.endX),c=Math.abs(e.endY-t.endY),h=Math.sqrt(n*n+r*r),d=(Math.sqrt(l*l+c*c)-h)/h;o.push(d)}))})),o.sort((function(a,b){return Math.abs(a)<Math.abs(b)})),o[0]}function it(e,n){var o=e.pageX,r=e.pageY,l={endX:o,endY:r};return n?l:t({timeStamp:Date.now(),startX:o,startY:r},l)}function nt(e){var t=0,n=0,o=0;return Fe(e,(function(e){var r=e.startX,l=e.startY;t+=r,n+=l,o+=1})),{pageX:t/=o,pageY:n/=o}}var ot,at={render:function(){this.initContainer(),this.initViewer(),this.initList(),this.renderViewer()},initBody:function(){var e=this.element.ownerDocument,body=e.body||e.documentElement;this.body=body,this.scrollbarWidth=window.innerWidth-e.documentElement.clientWidth,this.initialBodyPaddingRight=body.style.paddingRight,this.initialBodyComputedPaddingRight=window.getComputedStyle(body).paddingRight},initContainer:function(){this.containerData={width:window.innerWidth,height:window.innerHeight}},initViewer:function(){var e,t=this.options,n=this.parent;t.inline&&(e={width:Math.max(n.offsetWidth,t.minWidth),height:Math.max(n.offsetHeight,t.minHeight)},this.parentData=e),!this.fulled&&e||(e=this.containerData),this.viewerData=Me({},e)},renderViewer:function(){this.options.inline&&!this.fulled&&Le(this.viewer,this.viewerData)},initList:function(){var e=this,element=this.element,t=this.options,n=this.list,o=[];n.innerHTML="",Fe(this.images,(function(image,r){var l=image.src,c=image.alt||Ge(l),h=e.getImageURL(image);if(l||h){var d=document.createElement("li"),img=document.createElement("img");Fe(t.inheritedAttributes,(function(e){var t=image.getAttribute(e);null!==t&&img.setAttribute(e,t)})),img.src=l||h,img.alt=c,img.setAttribute("data-original-url",h||l),d.setAttribute("data-index",r),d.setAttribute("data-viewer-action","view"),d.setAttribute("role","button"),t.keyboard&&d.setAttribute("tabindex",0),d.appendChild(img),n.appendChild(d),o.push(d)}})),this.items=o,Fe(o,(function(n){var o,r,image=n.firstElementChild;Be(image,"filled",!0),t.loading&&je(n,N),He(image,H,o=function(o){qe(image,U,r),t.loading&&Pe(n,N),e.loadImage(o)},{once:!0}),He(image,U,r=function(){qe(image,H,o),t.loading&&Pe(n,N)},{once:!0})})),t.transition&&He(element,he,(function(){je(n,Y)}),{once:!0})},renderList:function(){var e=this.index,t=this.items[e];if(t){var n=t.nextElementSibling,o=parseInt(window.getComputedStyle(n||t).marginLeft,10),r=t.offsetWidth,l=r+o;Le(this.list,Me({width:l*this.length-o},Ke({translateX:(this.viewerData.width-r)/2-l*e})))}},resetList:function(){var e=this.list;e.innerHTML="",Pe(e,Y),Le(e,Ke({translateX:0}))},initImage:function(e){var t,n=this,o=this.options,image=this.image,r=this.viewerData,l=this.footer.offsetHeight,c=r.width,h=Math.max(r.height-l,l),d=this.imageData||{};this.imageInitializing={abort:function(){t.onload=null}},t=Qe(image,o,(function(t,r){var l=t/r,f=c,v=h;n.imageInitializing=!1,h*l>c?v=c/l:f=h*l,f=Math.min(.9*f,t),v=Math.min(.9*v,r);var m=(c-f)/2,w=(h-v)/2,y={left:m,top:w,x:m,y:w,width:f,height:v,oldRatio:1,ratio:f/t,aspectRatio:l,naturalWidth:t,naturalHeight:r},x=Me({},y);o.rotatable&&(y.rotate=d.rotate||0,x.rotate=0),o.scalable&&(y.scaleX=d.scaleX||1,y.scaleY=d.scaleY||1,x.scaleX=1,x.scaleY=1),n.imageData=y,n.initialImageData=x,e&&e()}))},renderImage:function(e){var t=this,image=this.image,n=this.imageData;if(Le(image,Me({width:n.width,height:n.height,marginLeft:n.x,marginTop:n.y},Ke(n))),e)if((this.viewing||this.moving||this.rotating||this.scaling||this.zooming)&&this.options.transition&&Xe(image,Y)){var o=function(){t.imageRendering=!1,e()};this.imageRendering={abort:function(){qe(image,ie,o)}},He(image,ie,o,{once:!0})}else e()},resetImage:function(){if(this.viewing||this.viewed){var image=this.image;this.viewing&&this.viewing.abort(),image.parentNode.removeChild(image),this.image=null}}},st={bind:function(){var e=this.options,t=this.viewer,canvas=this.canvas,n=this.element.ownerDocument;He(t,$,this.onClick=this.click.bind(this)),He(t,W,this.onDragStart=this.dragstart.bind(this)),He(canvas,J,this.onPointerDown=this.pointerdown.bind(this)),He(n,Q,this.onPointerMove=this.pointermove.bind(this)),He(n,ee,this.onPointerUp=this.pointerup.bind(this)),He(n,_,this.onKeyDown=this.keydown.bind(this)),He(window,te,this.onResize=this.resize.bind(this)),e.zoomable&&e.zoomOnWheel&&He(t,ne,this.onWheel=this.wheel.bind(this),{passive:!1,capture:!0}),e.toggleOnDblclick&&He(canvas,V,this.onDblclick=this.dblclick.bind(this))},unbind:function(){var e=this.options,t=this.viewer,canvas=this.canvas,n=this.element.ownerDocument;qe(t,$,this.onClick),qe(t,W,this.onDragStart),qe(canvas,J,this.onPointerDown),qe(n,Q,this.onPointerMove),qe(n,ee,this.onPointerUp),qe(n,_,this.onKeyDown),qe(window,te,this.onResize),e.zoomable&&e.zoomOnWheel&&qe(t,ne,this.onWheel,{passive:!1,capture:!0}),e.toggleOnDblclick&&qe(canvas,V,this.onDblclick)}},lt={click:function(e){var t=this.options,n=this.imageData,o=e.target,r=We(o,xe);switch(r||"img"!==o.localName||"li"!==o.parentElement.localName||(r=We(o=o.parentElement,xe)),m&&e.isTrusted&&o===this.canvas&&clearTimeout(this.clickCanvasTimeout),r){case"mix":this.played?this.stop():t.inline?this.fulled?this.exit():this.full():this.hide();break;case"hide":this.hide();break;case"view":this.view(We(o,"index"));break;case"zoom-in":this.zoom(.1,!0);break;case"zoom-out":this.zoom(-.1,!0);break;case"one-to-one":this.toggle();break;case"reset":this.reset();break;case"prev":this.prev(t.loop);break;case"play":this.play(t.fullscreen);break;case"next":this.next(t.loop);break;case"rotate-left":this.rotate(-90);break;case"rotate-right":this.rotate(90);break;case"flip-horizontal":this.scaleX(-n.scaleX||-1);break;case"flip-vertical":this.scaleY(-n.scaleY||-1);break;default:this.played&&this.stop()}},dblclick:function(e){e.preventDefault(),this.viewed&&e.target===this.image&&(m&&e.isTrusted&&clearTimeout(this.doubleClickImageTimeout),this.toggle(e.isTrusted?e:e.detail&&e.detail.originalEvent))},load:function(){var e=this;this.timeout&&(clearTimeout(this.timeout),this.timeout=!1);var element=this.element,t=this.options,image=this.image,n=this.index,o=this.viewerData;Pe(image,L),t.loading&&Pe(this.canvas,N),image.style.cssText="height:0;"+"margin-left:".concat(o.width/2,"px;")+"margin-top:".concat(o.height/2,"px;")+"max-width:none!important;position:relative;width:0;",this.initImage((function(){Ye(image,X,t.movable),Ye(image,Y,t.transition),e.renderImage((function(){e.viewed=!0,e.viewing=!1,Ie(t.viewed)&&He(element,he,t.viewed,{once:!0}),Ue(element,he,{originalImage:e.images[n],index:n,image:image},{cancelable:!1})}))}))},loadImage:function(e){var image=e.target,t=image.parentNode,n=t.offsetWidth||30,o=t.offsetHeight||50,r=!!We(image,"filled");Qe(image,this.options,(function(e,t){var l=e/t,c=n,h=o;o*l>n?r?c=o*l:h=n/l:r?h=n/l:c=o*l,Le(image,Me({width:c,height:h},Ke({translateX:(n-c)/2,translateY:(o-h)/2})))}))},keydown:function(e){var t=this.options;if(t.keyboard){var n=e.keyCode||e.which||e.charCode;if(13===n&&this.viewer.contains(e.target)&&this.click(e),this.fulled)switch(n){case 27:this.played?this.stop():t.inline?this.fulled&&this.exit():this.hide();break;case 32:this.played&&this.stop();break;case 37:this.prev(t.loop);break;case 38:e.preventDefault(),this.zoom(t.zoomRatio,!0);break;case 39:this.next(t.loop);break;case 40:e.preventDefault(),this.zoom(-t.zoomRatio,!0);break;case 48:case 49:e.ctrlKey&&(e.preventDefault(),this.toggle())}}},dragstart:function(e){"img"===e.target.localName&&e.preventDefault()},pointerdown:function(e){var t=this.options,n=this.pointers,o=e.buttons,button=e.button;if(!(!this.viewed||this.showing||this.viewing||this.hiding||("mousedown"===e.type||"pointerdown"===e.type&&"mouse"===e.pointerType)&&(Oe(o)&&1!==o||Oe(button)&&0!==button||e.ctrlKey))){e.preventDefault(),e.changedTouches?Fe(e.changedTouches,(function(e){n[e.identifier]=it(e)})):n[e.pointerId||0]=it(e);var r=!!t.movable&&x;t.zoomOnTouch&&t.zoomable&&Object.keys(n).length>1?r=A:t.slideOnTouch&&("touch"===e.pointerType||"touchstart"===e.type)&&this.isSwitchable()&&(r=k),!t.transition||r!==x&&r!==A||Pe(this.image,Y),this.action=r}},pointermove:function(e){var t=this.pointers,n=this.action;this.viewed&&n&&(e.preventDefault(),e.changedTouches?Fe(e.changedTouches,(function(e){Me(t[e.identifier]||{},it(e,!0))})):Me(t[e.pointerId||0]||{},it(e,!0)),this.change(e))},pointerup:function(e){var t,n=this,o=this.options,r=this.action,l=this.pointers;e.changedTouches?Fe(e.changedTouches,(function(e){t=l[e.identifier],delete l[e.identifier]})):(t=l[e.pointerId||0],delete l[e.pointerId||0]),r&&(e.preventDefault(),!o.transition||r!==x&&r!==A||je(this.image,Y),this.action=!1,m&&r!==A&&t&&Date.now()-t.timeStamp<500&&(clearTimeout(this.clickCanvasTimeout),clearTimeout(this.doubleClickImageTimeout),o.toggleOnDblclick&&this.viewed&&e.target===this.image?this.imageClicked?(this.imageClicked=!1,this.doubleClickImageTimeout=setTimeout((function(){Ue(n.image,V,{originalEvent:e})}),50)):(this.imageClicked=!0,this.doubleClickImageTimeout=setTimeout((function(){n.imageClicked=!1}),500)):(this.imageClicked=!1,o.backdrop&&"static"!==o.backdrop&&e.target===this.canvas&&(this.clickCanvasTimeout=setTimeout((function(){Ue(n.canvas,$,{originalEvent:e})}),50)))))},resize:function(){var e=this;if(this.isShown&&!this.hiding&&(this.fulled&&(this.close(),this.initBody(),this.open()),this.initContainer(),this.initViewer(),this.renderViewer(),this.renderList(),this.viewed&&this.initImage((function(){e.renderImage()})),this.played)){if(this.options.fullscreen&&this.fulled&&!(document.fullscreenElement||document.webkitFullscreenElement||document.mozFullScreenElement||document.msFullscreenElement))return void this.stop();Fe(this.player.getElementsByTagName("img"),(function(image){He(image,H,e.loadImage.bind(e),{once:!0}),Ue(image,H)}))}},wheel:function(e){var t=this;if(this.viewed&&(e.preventDefault(),!this.wheeling)){this.wheeling=!0,setTimeout((function(){t.wheeling=!1}),50);var n=Number(this.options.zoomRatio)||.1,o=1;e.deltaY?o=e.deltaY>0?1:-1:e.wheelDelta?o=-e.wheelDelta/120:e.detail&&(o=e.detail>0?1:-1),this.zoom(-o*n,!0,e)}}},ct={show:function(){var e=arguments.length>0&&void 0!==arguments[0]&&arguments[0],element=this.element,t=this.options;if(t.inline||this.showing||this.isShown||this.showing)return this;if(!this.ready)return this.build(),this.ready&&this.show(e),this;if(Ie(t.show)&&He(element,re,t.show,{once:!0}),!1===Ue(element,re)||!this.ready)return this;this.hiding&&this.transitioning.abort(),this.showing=!0,this.open();var n=this.viewer;if(Pe(n,S),n.setAttribute("role","dialog"),n.setAttribute("aria-labelledby",this.title.id),n.setAttribute("aria-modal",!0),n.removeAttribute("aria-hidden"),t.transition&&!e){var o=this.shown.bind(this);this.transitioning={abort:function(){qe(n,ie,o),Pe(n,R)}},je(n,Y),n.initialOffsetWidth=n.offsetWidth,He(n,ie,o,{once:!0}),je(n,R)}else je(n,R),this.shown();return this},hide:function(){var e=this,t=arguments.length>0&&void 0!==arguments[0]&&arguments[0],element=this.element,n=this.options;if(n.inline||this.hiding||!this.isShown&&!this.showing)return this;if(Ie(n.hide)&&He(element,se,n.hide,{once:!0}),!1===Ue(element,se))return this;this.showing&&this.transitioning.abort(),this.hiding=!0,this.played?this.stop():this.viewing&&this.viewing.abort();var o=this.viewer,image=this.image,r=function(){Pe(o,R),e.hidden()};if(n.transition&&!t){var l=function t(n){n&&n.target===o&&(qe(o,ie,t),e.hidden())},c=function(){Xe(o,Y)?(He(o,ie,l),Pe(o,R)):r()};this.transitioning={abort:function(){e.viewed&&Xe(image,Y)?qe(image,ie,c):Xe(o,Y)&&qe(o,ie,l)}},this.viewed&&Xe(image,Y)?(He(image,ie,c,{once:!0}),this.zoomTo(0,!1,null,!0)):c()}else r();return this},view:function(){var e=this,t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.options.initialViewIndex;if(t=Number(t)||0,this.hiding||this.played||t<0||t>=this.length||this.viewed&&t===this.index)return this;if(!this.isShown)return this.index=t,this.show();this.viewing&&this.viewing.abort();var element=this.element,n=this.options,title=this.title,canvas=this.canvas,o=this.items[t],img=o.querySelector("img"),r=We(img,"originalUrl"),l=img.getAttribute("alt"),image=document.createElement("img");if(Fe(n.inheritedAttributes,(function(e){var t=img.getAttribute(e);null!==t&&image.setAttribute(e,t)})),image.src=r,image.alt=l,Ie(n.view)&&He(element,ce,n.view,{once:!0}),!1===Ue(element,ce,{originalImage:this.images[t],index:t,image:image})||!this.isShown||this.hiding||this.played)return this;var c=this.items[this.index];c&&(Pe(c,z),c.removeAttribute("aria-selected")),je(o,z),o.setAttribute("aria-selected",!0),n.focus&&o.focus(),this.image=image,this.viewed=!1,this.index=t,this.imageData={},je(image,L),n.loading&&je(canvas,N),canvas.innerHTML="",canvas.appendChild(image),this.renderList(),title.innerHTML="";var h,d,f=function(){var t=e.imageData,o=Array.isArray(n.title)?n.title[1]:n.title;title.innerHTML=Ne(Ie(o)?o.call(e,image,t):"".concat(l," (").concat(t.naturalWidth," × ").concat(t.naturalHeight,")"))};return He(element,he,f,{once:!0}),this.viewing={abort:function(){qe(element,he,f),image.complete?e.imageRendering?e.imageRendering.abort():e.imageInitializing&&e.imageInitializing.abort():(image.src="",qe(image,H,h),e.timeout&&clearTimeout(e.timeout))}},image.complete?this.load():(He(image,H,h=function(){qe(image,U,d),e.load()},{once:!0}),He(image,U,d=function(){qe(image,H,h),e.timeout&&(clearTimeout(e.timeout),e.timeout=!1),Pe(image,L),n.loading&&Pe(e.canvas,N)},{once:!0}),this.timeout&&clearTimeout(this.timeout),this.timeout=setTimeout((function(){Pe(image,L),e.timeout=!1}),1e3)),this},prev:function(){var e=arguments.length>0&&void 0!==arguments[0]&&arguments[0],t=this.index-1;return t<0&&(t=e?this.length-1:0),this.view(t),this},next:function(){var e=arguments.length>0&&void 0!==arguments[0]&&arguments[0],t=this.length-1,n=this.index+1;return n>t&&(n=e?0:t),this.view(n),this},move:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:e,n=this.imageData;return this.moveTo(Ee(e)?e:n.x+Number(e),Ee(t)?t:n.y+Number(t)),this},moveTo:function(e){var t=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:e,o=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null,element=this.element,r=this.options,l=this.imageData;if(e=Number(e),n=Number(n),this.viewed&&!this.played&&r.movable){var c=l.x,h=l.y,d=!1;if(Oe(e)?d=!0:e=c,Oe(n)?d=!0:n=h,d){if(Ie(r.move)&&He(element,ue,r.move,{once:!0}),!1===Ue(element,ue,{x:e,y:n,oldX:c,oldY:h,originalEvent:o}))return this;l.x=e,l.y=n,l.left=e,l.top=n,this.moving=!0,this.renderImage((function(){t.moving=!1,Ie(r.moved)&&He(element,de,r.moved,{once:!0}),Ue(element,de,{x:e,y:n,oldX:c,oldY:h,originalEvent:o},{cancelable:!1})}))}}return this},rotate:function(e){return this.rotateTo((this.imageData.rotate||0)+Number(e)),this},rotateTo:function(e){var t=this,element=this.element,n=this.options,o=this.imageData;if(Oe(e=Number(e))&&this.viewed&&!this.played&&n.rotatable){var r=o.rotate;if(Ie(n.rotate)&&He(element,fe,n.rotate,{once:!0}),!1===Ue(element,fe,{degree:e,oldDegree:r}))return this;o.rotate=e,this.rotating=!0,this.renderImage((function(){t.rotating=!1,Ie(n.rotated)&&He(element,ve,n.rotated,{once:!0}),Ue(element,ve,{degree:e,oldDegree:r},{cancelable:!1})}))}return this},scaleX:function(e){return this.scale(e,this.imageData.scaleY),this},scaleY:function(e){return this.scale(this.imageData.scaleX,e),this},scale:function(e){var t=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:e,element=this.element,o=this.options,r=this.imageData;if(e=Number(e),n=Number(n),this.viewed&&!this.played&&o.scalable){var l=r.scaleX,c=r.scaleY,h=!1;if(Oe(e)?h=!0:e=l,Oe(n)?h=!0:n=c,h){if(Ie(o.scale)&&He(element,pe,o.scale,{once:!0}),!1===Ue(element,pe,{scaleX:e,scaleY:n,oldScaleX:l,oldScaleY:c}))return this;r.scaleX=e,r.scaleY=n,this.scaling=!0,this.renderImage((function(){t.scaling=!1,Ie(o.scaled)&&He(element,me,o.scaled,{once:!0}),Ue(element,me,{scaleX:e,scaleY:n,oldScaleX:l,oldScaleY:c},{cancelable:!1})}))}}return this},zoom:function(e){var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null,o=this.imageData;return e=(e=Number(e))<0?1/(1-e):1+e,this.zoomTo(o.width*e/o.naturalWidth,t,n),this},zoomTo:function(e){var t=this,n=arguments.length>1&&void 0!==arguments[1]&&arguments[1],o=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null,r=arguments.length>3&&void 0!==arguments[3]&&arguments[3],element=this.element,l=this.options,c=this.pointers,h=this.imageData,d=h.x,f=h.y,v=h.width,m=h.height,w=h.naturalWidth,y=h.naturalHeight;if(Oe(e=Math.max(0,e))&&this.viewed&&!this.played&&(r||l.zoomable)){if(!r){var x=Math.max(.01,l.minZoomRatio),k=Math.min(100,l.maxZoomRatio);e=Math.min(Math.max(e,x),k)}if(o)switch(o.type){case"wheel":l.zoomRatio>=.055&&e>.95&&e<1.05&&(e=1);break;case"pointermove":case"touchmove":case"mousemove":e>.99&&e<1.01&&(e=1)}var A=w*e,z=y*e,T=A-v,O=z-m,E=h.ratio;if(Ie(l.zoom)&&He(element,ge,l.zoom,{once:!0}),!1===Ue(element,ge,{ratio:e,oldRatio:E,originalEvent:o}))return this;if(this.zooming=!0,o){var D=Ze(this.viewer),C=c&&Object.keys(c).length>0?nt(c):{pageX:o.pageX,pageY:o.pageY};h.x-=T*((C.pageX-D.left-d)/v),h.y-=O*((C.pageY-D.top-f)/m)}else h.x-=T/2,h.y-=O/2;h.left=h.x,h.top=h.y,h.width=A,h.height=z,h.oldRatio=E,h.ratio=e,this.renderImage((function(){t.zooming=!1,Ie(l.zoomed)&&He(element,we,l.zoomed,{once:!0}),Ue(element,we,{ratio:e,oldRatio:E,originalEvent:o},{cancelable:!1})})),n&&this.tooltip()}return this},play:function(){var e=this,t=arguments.length>0&&void 0!==arguments[0]&&arguments[0];if(!this.isShown||this.played)return this;var element=this.element,n=this.options;if(Ie(n.play)&&He(element,be,n.play,{once:!0}),!1===Ue(element,be))return this;var o=this.player,r=this.loadImage.bind(this),l=[],c=0,h=0;if(this.played=!0,this.onLoadWhenPlay=r,t&&this.requestFullscreen(t),je(o,P),Fe(this.items,(function(e,i){var img=e.querySelector("img"),image=document.createElement("img");image.src=We(img,"originalUrl"),image.alt=img.getAttribute("alt"),image.referrerPolicy=img.referrerPolicy,c+=1,je(image,O),Ye(image,Y,n.transition),Xe(e,z)&&(je(image,R),h=i),l.push(image),He(image,H,r,{once:!0}),o.appendChild(image)})),Oe(n.interval)&&n.interval>0){var d=function t(){e.playing=setTimeout((function(){Pe(l[h],R),je(l[h=(h+=1)<c?h:0],R),t()}),n.interval)};c>1&&d()}return this},stop:function(){var e=this;if(!this.played)return this;var element=this.element,t=this.options;if(Ie(t.stop)&&He(element,ye,t.stop,{once:!0}),!1===Ue(element,ye))return this;var n=this.player;return this.played=!1,clearTimeout(this.playing),Fe(n.getElementsByTagName("img"),(function(image){qe(image,H,e.onLoadWhenPlay)})),Pe(n,P),n.innerHTML="",this.exitFullscreen(),this},full:function(){var e=this,t=this.options,n=this.viewer,image=this.image,o=this.list;return!this.isShown||this.played||this.fulled||!t.inline||(this.fulled=!0,this.open(),je(this.button,C),t.transition&&(Pe(o,Y),this.viewed&&Pe(image,Y)),je(n,E),n.setAttribute("role","dialog"),n.setAttribute("aria-labelledby",this.title.id),n.setAttribute("aria-modal",!0),n.removeAttribute("style"),Le(n,{zIndex:t.zIndex}),t.focus&&this.enforceFocus(),this.initContainer(),this.viewerData=Me({},this.containerData),this.renderList(),this.viewed&&this.initImage((function(){e.renderImage((function(){t.transition&&setTimeout((function(){je(image,Y),je(o,Y)}),0)}))}))),this},exit:function(){var e=this,t=this.options,n=this.viewer,image=this.image,o=this.list;return this.isShown&&!this.played&&this.fulled&&t.inline?(this.fulled=!1,this.close(),Pe(this.button,C),t.transition&&(Pe(o,Y),this.viewed&&Pe(image,Y)),t.focus&&this.clearEnforceFocus(),n.removeAttribute("role"),n.removeAttribute("aria-labelledby"),n.removeAttribute("aria-modal"),Pe(n,E),Le(n,{zIndex:t.zIndexInline}),this.viewerData=Me({},this.parentData),this.renderViewer(),this.renderList(),this.viewed&&this.initImage((function(){e.renderImage((function(){t.transition&&setTimeout((function(){je(image,Y),je(o,Y)}),0)}))})),this):this},tooltip:function(){var e=this,t=this.options,n=this.tooltipBox,o=this.imageData;return this.viewed&&!this.played&&t.tooltip?(n.textContent="".concat(Math.round(100*o.ratio),"%"),this.tooltipping?clearTimeout(this.tooltipping):t.transition?(this.fading&&Ue(n,ie),je(n,P),je(n,O),je(n,Y),n.removeAttribute("aria-hidden"),n.initialOffsetWidth=n.offsetWidth,je(n,R)):(je(n,P),n.removeAttribute("aria-hidden")),this.tooltipping=setTimeout((function(){t.transition?(He(n,ie,(function(){Pe(n,P),Pe(n,O),Pe(n,Y),n.setAttribute("aria-hidden",!0),e.fading=!1}),{once:!0}),Pe(n,R),e.fading=!0):(Pe(n,P),n.setAttribute("aria-hidden",!0)),e.tooltipping=!1}),1e3),this):this},toggle:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;return 1===this.imageData.ratio?this.zoomTo(this.imageData.oldRatio,!0,e):this.zoomTo(1,!0,e),this},reset:function(){return this.viewed&&!this.played&&(this.imageData=Me({},this.initialImageData),this.renderImage()),this},update:function(){var e=this,element=this.element,t=this.options,n=this.isImg;if(n&&!element.parentNode)return this.destroy();var o=[];if(Fe(n?[element]:element.querySelectorAll("img"),(function(image){Ie(t.filter)?t.filter.call(e,image)&&o.push(image):e.getImageURL(image)&&o.push(image)})),!o.length)return this;if(this.images=o,this.length=o.length,this.ready){var r=[];if(Fe(this.items,(function(e,i){var img=e.querySelector("img"),image=o[i];image&&img&&image.src===img.src&&image.alt===img.alt||r.push(i)})),Le(this.list,{width:"auto"}),this.initList(),this.isShown)if(this.length){if(this.viewed){var l=r.indexOf(this.index);if(l>=0)this.viewed=!1,this.view(Math.max(Math.min(this.index-l,this.length-1),0));else{var c=this.items[this.index];je(c,z),c.setAttribute("aria-selected",!0)}}}else this.image=null,this.viewed=!1,this.index=0,this.imageData={},this.canvas.innerHTML="",this.title.innerHTML=""}else this.build();return this},destroy:function(){var element=this.element,e=this.options;return element[y]?(this.destroyed=!0,this.ready?(this.played&&this.stop(),e.inline?(this.fulled&&this.exit(),this.unbind()):this.isShown?(this.viewing&&(this.imageRendering?this.imageRendering.abort():this.imageInitializing&&this.imageInitializing.abort()),this.hiding&&this.transitioning.abort(),this.hidden()):this.showing&&(this.transitioning.abort(),this.hidden()),this.ready=!1,this.viewer.parentNode.removeChild(this.viewer)):e.inline&&(this.delaying?this.delaying.abort():this.initializing&&this.initializing.abort()),e.inline||qe(element,$,this.onStart),element[y]=void 0,this):this}},ht={getImageURL:function(image){var e=this.options.url;return e=ze(e)?image.getAttribute(e):Ie(e)?e.call(this,image):""},enforceFocus:function(){var e=this;this.clearEnforceFocus(),He(document,B,this.onFocusin=function(t){var n=e.viewer,o=t.target;o===document||o===n||n.contains(o)||null!==o.getAttribute("tabindex")&&"true"===o.getAttribute("aria-modal")||n.focus()})},clearEnforceFocus:function(){this.onFocusin&&(qe(document,B,this.onFocusin),this.onFocusin=null)},open:function(){var body=this.body;je(body,j),body.style.paddingRight="".concat(this.scrollbarWidth+(parseFloat(this.initialBodyComputedPaddingRight)||0),"px")},close:function(){var body=this.body;Pe(body,j),body.style.paddingRight=this.initialBodyPaddingRight},shown:function(){var element=this.element,e=this.options,t=this.viewer;this.fulled=!0,this.isShown=!0,this.render(),this.bind(),this.showing=!1,e.focus&&(t.focus(),this.enforceFocus()),Ie(e.shown)&&He(element,ae,e.shown,{once:!0}),!1!==Ue(element,ae)&&this.ready&&this.isShown&&!this.hiding&&this.view(this.index)},hidden:function(){var element=this.element,e=this.options,t=this.viewer;e.fucus&&this.clearEnforceFocus(),this.fulled=!1,this.viewed=!1,this.isShown=!1,this.close(),this.unbind(),je(t,S),t.removeAttribute("role"),t.removeAttribute("aria-labelledby"),t.removeAttribute("aria-modal"),t.setAttribute("aria-hidden",!0),this.resetList(),this.resetImage(),this.hiding=!1,this.destroyed||(Ie(e.hidden)&&He(element,le,e.hidden,{once:!0}),Ue(element,le,null,{cancelable:!1}))},requestFullscreen:function(e){var t=this.element.ownerDocument;if(this.fulled&&!(t.fullscreenElement||t.webkitFullscreenElement||t.mozFullScreenElement||t.msFullscreenElement)){var n=t.documentElement;n.requestFullscreen?Se(e)?n.requestFullscreen(e):n.requestFullscreen():n.webkitRequestFullscreen?n.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT):n.mozRequestFullScreen?n.mozRequestFullScreen():n.msRequestFullscreen&&n.msRequestFullscreen()}},exitFullscreen:function(){var e=this.element.ownerDocument;this.fulled&&(e.fullscreenElement||e.webkitFullscreenElement||e.mozFullScreenElement||e.msFullscreenElement)&&(e.exitFullscreen?e.exitFullscreen():e.webkitExitFullscreen?e.webkitExitFullscreen():e.mozCancelFullScreen?e.mozCancelFullScreen():e.msExitFullscreen&&e.msExitFullscreen())},change:function(e){var t=this.options,n=this.pointers,o=n[Object.keys(n)[0]];if(o){var r=o.endX-o.startX,l=o.endY-o.startY;switch(this.action){case x:this.move(r,l,e);break;case A:this.zoom(tt(n),!1,e);break;case k:this.action="switched";var c=Math.abs(r);c>1&&c>Math.abs(l)&&(this.pointers={},r>1?this.prev(t.loop):r<-1&&this.next(t.loop))}Fe(n,(function(p){p.startX=p.endX,p.startY=p.endY}))}},isSwitchable:function(){var e=this.imageData,t=this.viewerData;return this.length>1&&e.x>=0&&e.y>=0&&e.width<=t.width&&e.height<=t.height}},ut=v.Viewer,ft=(ot=-1,function(){return ot+=1}),vt=function(){function e(element){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(o(this,e),!element||1!==element.nodeType)throw new Error("The first argument is required and must be an element.");this.element=element,this.options=Me({},h,Se(t)&&t),this.action=!1,this.fading=!1,this.fulled=!1,this.hiding=!1,this.imageClicked=!1,this.imageData={},this.index=this.options.initialViewIndex,this.isImg=!1,this.isShown=!1,this.length=0,this.moving=!1,this.played=!1,this.playing=!1,this.pointers={},this.ready=!1,this.rotating=!1,this.scaling=!1,this.showing=!1,this.timeout=!1,this.tooltipping=!1,this.viewed=!1,this.viewing=!1,this.wheeling=!1,this.zooming=!1,this.id=ft(),this.init()}return l(e,[{key:"init",value:function(){var e=this,element=this.element,t=this.options;if(!element[y]){element[y]=this,t.focus&&!t.keyboard&&(t.focus=!1);var n="img"===element.localName,o=[];if(Fe(n?[element]:element.querySelectorAll("img"),(function(image){Ie(t.filter)?t.filter.call(e,image)&&o.push(image):e.getImageURL(image)&&o.push(image)})),this.isImg=n,this.length=o.length,this.images=o,this.initBody(),Ee(document.createElement(y).style.transition)&&(t.transition=!1),t.inline){var r=0,progress=function(){var t;(r+=1)===e.length&&(e.initializing=!1,e.delaying={abort:function(){clearTimeout(t)}},t=setTimeout((function(){e.delaying=!1,e.build()}),0))};this.initializing={abort:function(){Fe(o,(function(image){image.complete||qe(image,H,progress)}))}},Fe(o,(function(image){image.complete?progress():He(image,H,progress,{once:!0})}))}else He(element,$,this.onStart=function(n){var o=n.target;"img"!==o.localName||Ie(t.filter)&&!t.filter.call(e,o)||e.view(e.images.indexOf(o))})}}},{key:"build",value:function(){if(!this.ready){var element=this.element,e=this.options,t=element.parentNode,template=document.createElement("div");template.innerHTML=d;var n=template.querySelector(".".concat(y,"-container")),title=n.querySelector(".".concat(y,"-title")),o=n.querySelector(".".concat(y,"-toolbar")),r=n.querySelector(".".concat(y,"-navbar")),button=n.querySelector(".".concat(y,"-button")),canvas=n.querySelector(".".concat(y,"-canvas"));if(this.parent=t,this.viewer=n,this.title=title,this.toolbar=o,this.navbar=r,this.button=button,this.canvas=canvas,this.footer=n.querySelector(".".concat(y,"-footer")),this.tooltipBox=n.querySelector(".".concat(y,"-tooltip")),this.player=n.querySelector(".".concat(y,"-player")),this.list=n.querySelector(".".concat(y,"-list")),n.id="".concat(y).concat(this.id),title.id="".concat(y,"Title").concat(this.id),je(title,e.title?et(Array.isArray(e.title)?e.title[0]:e.title):S),je(r,e.navbar?et(e.navbar):S),Ye(button,S,!e.button),e.keyboard&&button.setAttribute("tabindex",0),e.backdrop&&(je(n,"".concat(y,"-backdrop")),e.inline||"static"===e.backdrop||Be(canvas,xe,"hide")),ze(e.className)&&e.className&&e.className.split(ke).forEach((function(e){je(n,e)})),e.toolbar){var l=document.createElement("ul"),c=Se(e.toolbar),h=Ae.slice(0,3),f=Ae.slice(7,9),v=Ae.slice(9);c||je(o,et(e.toolbar)),Fe(c?e.toolbar:Ae,(function(t,n){var o=c&&Se(t),r=c?Ve(n):t,d=o&&!Ee(t.show)?t.show:t;if(d&&(e.zoomable||-1===h.indexOf(r))&&(e.rotatable||-1===f.indexOf(r))&&(e.scalable||-1===v.indexOf(r))){var m=o&&!Ee(t.size)?t.size:t,w=o&&!Ee(t.click)?t.click:t,x=document.createElement("li");e.keyboard&&x.setAttribute("tabindex",0),x.setAttribute("role","button"),je(x,"".concat(y,"-").concat(r)),Ie(w)||Be(x,xe,r),Oe(d)&&je(x,et(d)),-1!==["small","large"].indexOf(m)?je(x,"".concat(y,"-").concat(m)):"play"===r&&je(x,"".concat(y,"-large")),Ie(w)&&He(x,$,w),l.appendChild(x)}})),o.appendChild(l)}else je(o,S);if(!e.rotatable){var m=o.querySelectorAll('li[class*="rotate"]');je(m,L),Fe(m,(function(e){o.appendChild(e)}))}if(e.inline)je(button,D),Le(n,{zIndex:e.zIndexInline}),"static"===window.getComputedStyle(t).position&&Le(t,{position:"relative"}),t.insertBefore(n,element.nextSibling);else{je(button,T),je(n,E),je(n,O),je(n,S),Le(n,{zIndex:e.zIndex});var w=e.container;ze(w)&&(w=element.ownerDocument.querySelector(w)),w||(w=this.body),w.appendChild(n)}e.inline&&(this.render(),this.bind(),this.isShown=!0),this.ready=!0,Ie(e.ready)&&He(element,oe,e.ready,{once:!0}),!1!==Ue(element,oe)?this.ready&&e.inline&&this.view(this.index):this.ready=!1}}}],[{key:"noConflict",value:function(){return window.Viewer=ut,e}},{key:"setDefaults",value:function(e){Me(h,Se(e)&&e)}}]),e}();return Me(vt.prototype,at,st,lt,ct,ht),vt}()}}]);
//# sourceMappingURL=3300539-1.2.10.js.map