/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.ged.business;

import br.com.oti.gesconsys.beans.core.RefCode;
import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.ged.AnexoConteudo;
import br.com.oti.gesconsys.beans.ged.AnexoIdVO;
import br.com.oti.gesconsys.beans.ged.AnexoPK;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.AuthLogin;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.ged.beans.TipoStatusGed;
import br.com.oti.gesconsys.ged.business.GedService;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import jakarta.annotation.PostConstruct;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tika.Tika;
import org.apache.tika.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ResponseStatusException;

@Component
@EnableScheduling
public class TikaServerExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(TikaServerExtractor.class);
    TaskScheduler scheduler;
    private List<RefCode> refCodes;
    private List<AnexoIdVO> processing;
    @Autowired
    private Environment env;
    private String tokenJwt;
    private List<String> stopList;
    @Autowired
    private CoreService coreService;
    @Autowired
    private GedService gedService;
    Runnable refreshTokenTask = () -> {
        try {
            this.refreshToken();
        }
        catch (Exception e) {
            LOG.error("exc", (Throwable)e);
        }
    };
    Runnable processRepo = () -> {
        try {
            if (this.processing == null || this.processing.isEmpty()) {
                LOG.debug("Processando Reposit\u00f3rio...");
                this.processing = this.findAnexosProcessar(Boolean.valueOf(false));
                if (this.extractTikaContent().booleanValue()) {
                    this.processing.clear();
                }
                return;
            }
            LOG.debug("Reposit\u00f3rio em processamento, aguardando pr\u00f3xima janela..");
        }
        catch (Exception e) {
            LOG.error("exc: {}", (Throwable)e);
        }
    };

    public TikaServerExtractor(TaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    @PostConstruct
    public void init() {
        LOG.debug("Inicializando TikaExtractor...");
        this.fillStopList();
        this.processing = new ArrayList();
        this.refreshToken();
        this.prepareCronjobs();
    }

    private void fillStopList() {
        ArrayList<String> stopData = new ArrayList<String>();
        try {
            InputStream stopFileStream = Empresa.class.getClassLoader().getResourceAsStream("stoplist.txt");
            if (stopFileStream != null) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(stopFileStream));){
                    while (reader.ready()) {
                        stopData.add(reader.readLine());
                    }
                    reader.close();
                }
            }
            stopFileStream.close();
        }
        catch (IOException ioExc) {
            LOG.error("IOExc", (Throwable)ioExc);
        }
        this.stopList = new ArrayList();
        for (String stop : stopData) {
            String trimmed = stop.trim();
            if (!trimmed.equals(stop)) {
                this.stopList.add(trimmed);
                continue;
            }
            this.stopList.add(stop);
        }
    }

    private void prepareCronjobs() {
        this.scheduler.schedule(this.refreshTokenTask, (Trigger)new CronTrigger("0 0 * * * *"));
        this.scheduler.schedule(this.processRepo, (Trigger)new CronTrigger("0/30 * * * * *"));
    }

    public String refreshToken() {
        LOG.debug("executando refreshToken...");
        AuthLogin authPayload = new AuthLogin();
        authPayload.setUserName(this.env.getProperty("gescon.scheduler.user-name"));
        authPayload.setPassword("scheduler.passwd#[NOOP]");
        return this.tokenJwt;
    }

    private void fillRefCodes(String tokenJwt) {
        this.refCodes = new ArrayList();
        String searchTxt = null;
        List empresasData = this.coreService.findEmpresas(null, null);
        for (Empresa empresa : empresasData) {
            List refCodesAll = this.coreService.findRefCodes(empresa.getSigla(), searchTxt);
            ArrayList<RefCode> refCodes = new ArrayList<RefCode>();
            for (RefCode refBase : refCodesAll) {
                block4: {
                    try {
                        TipoRefCode tipoRef = TipoRefCode.fromString((String)refBase.getRefName());
                        if (tipoRef.getRestrito().booleanValue()) break block4;
                        LOG.debug("Usuario Admin, LIBERANDO informa\u00e7\u00f5es Restritas...");
                    }
                    catch (IllegalArgumentException iaeExc) {
                        continue;
                    }
                }
                if (refBase.getRefName().toLowerCase().contains("password") || refBase.getRefName().toLowerCase().contains("senha")) continue;
                refCodes.add(refBase);
            }
        }
    }

    private String getRefCodeByName(Integer idEmpresa, TipoRefCode tipoRefCode) {
        for (RefCode refCode : this.refCodes) {
            if (idEmpresa == null && refCode.getIdEmpresa() != null || !(idEmpresa != null ? refCode.getIdEmpresa() != null && idEmpresa.equals(refCode.getIdEmpresa()) && refCode.getRefName().equals(tipoRefCode.getRefName()) : refCode.getRefName().equals(tipoRefCode.getRefName()))) continue;
            return refCode.getRefValue();
        }
        return null;
    }

    private List<AnexoIdVO> findAnexosProcessar(Boolean reprocessar) {
        LOG.debug("executando findAnexosProcessar({})...", (Object)reprocessar);
        LOG.debug("findProcessar (reprocessar={})...", (Object)reprocessar);
        List docs = this.gedService.findProcessar(reprocessar);
        LOG.debug("findProcessar.size={}", (Object)docs.size());
        return docs;
    }

    private Anexo getAnexo(String empresa, Integer idAnexo) {
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        Anexo anx = this.gedService.getAnexoById(emp.getId(), idAnexo);
        return anx;
    }

    private AnexoConteudo getConteudo(String empresa, Integer idAnexo) {
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        AnexoConteudo anx = this.gedService.getAnexoConteudoById(emp.getId(), idAnexo);
        return anx;
    }

    public Boolean extractTikaContent() {
        this.fillRefCodes(this.tokenJwt);
        ArrayList<AnexoPK> result = new ArrayList<AnexoPK>();
        ObjectMapper jsonMapper = new ObjectMapper();
        jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        jsonMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        Integer tam50Mb = 0x3200000;
        LinkedHashMap<String, String> metadataMap = new LinkedHashMap<String, String>();
        boolean process = false;
        if (this.processing.isEmpty()) {
            LOG.debug("N\u00e3o h\u00e1 anexos para processar, reprocessando itens com erro...");
            return false;
        }
        result.clear();
        Tika tika = new Tika();
        for (AnexoIdVO anxIte : this.processing) {
            Anexo anexo = this.getAnexo(anxIte.getEmpresa(), anxIte.getIdAnexo());
            AnexoConteudo conteudo = this.getConteudo(anxIte.getEmpresa(), anxIte.getIdAnexo());
            if (conteudo == null) {
                conteudo = new AnexoConteudo();
                conteudo.getId().setIdEmpresa(anexo.getId().getIdEmpresa());
                conteudo.getId().setIdAnexo(anexo.getId().getIdAnexo());
                conteudo.setAnexo(anexo);
            }
            process = true;
            if (anexo.getTamanho() > tam50Mb) {
                LOG.debug("anexo({}:{}) > 50MB, ignorando...", (Object)anexo.getId().getIdEmpresa(), (Object)anexo.getId().getIdAnexo());
                conteudo.setMetadata(null);
                anexo.setErroGed("Ignorado: Tamanho arquivo acima esperado.");
                errorCount = anexo.getNroErrosGed();
                if (errorCount == null) {
                    errorCount = 0;
                }
                errorCount = errorCount + 1;
                anexo.setNroErrosGed(errorCount);
                if (errorCount <= 1000) {
                    anexo.setStatusGed(TipoStatusGed.ERRO_PROCESSAMENTO.getCode());
                } else {
                    anexo.setStatusGed(TipoStatusGed.NAO_ENCONTRADO.getCode());
                }
                process = false;
            } else if (anexo.getExtensao().equals("zip") || anexo.getExtensao().equals("rar") || anexo.getExtensao().equals("7z") || anexo.getExtensao().equals("tar")) {
                LOG.debug("anexo({}:{}), compactado, ignorando...", (Object)anexo.getId().getIdEmpresa(), (Object)anexo.getId().getIdAnexo());
                conteudo.setMetadata(null);
                anexo.setErroGed("Ignorado: Arquivos compactados s\u00e3o ignorados.");
                errorCount = anexo.getNroErrosGed();
                if (errorCount == null) {
                    errorCount = 0;
                }
                errorCount = errorCount + 1;
                anexo.setNroErrosGed(errorCount);
                if (errorCount <= 1000) {
                    anexo.setStatusGed(TipoStatusGed.ERRO_PROCESSAMENTO.getCode());
                } else {
                    anexo.setStatusGed(TipoStatusGed.NAO_ENCONTRADO.getCode());
                }
                process = false;
            }
            if (process) {
                LOG.debug("Extraindo metadados, Anexo[ {} , {} ]", (Object)anexo.getId().getIdEmpresa(), (Object)anexo.getId().getIdAnexo());
                File file = new File(this.extractPathAnexo(anexo));
                if (file.exists()) {
                    try (FileInputStream istream = new FileInputStream(file);){
                        Metadata meta = new Metadata();
                        String handler = tika.parseToString((InputStream)istream, meta);
                        metadataMap.clear();
                        for (String name : meta.names()) {
                            metadataMap.put(name, meta.get(name));
                        }
                        conteudo.setMetadata(jsonMapper.writeValueAsString(metadataMap));
                        conteudo.setConteudo(handler.toString());
                        conteudo.setTemas(jsonMapper.writeValueAsString((Object)this.fillTemasMap(conteudo.getConteudo())));
                        anexo.setDatHorExtracao(LocalDateTime.now());
                        LOG.debug("Anexo [id:{}], conteudo.length={}", (Object)anexo.getId(), (Object)conteudo.getConteudo().length());
                        result.add(anexo.getId());
                    }
                    catch (Exception psrExc) {
                        conteudo.setMetadata(null);
                        String erroGed = psrExc.getMessage();
                        if (erroGed != null && erroGed.length() > 140) {
                            erroGed = erroGed.substring(0, 140);
                        }
                        anexo.setErroGed("Erro:" + erroGed);
                        Integer errorCount = anexo.getNroErrosGed();
                        if (errorCount == null) {
                            errorCount = 0;
                        }
                        errorCount = errorCount + 1;
                        anexo.setNroErrosGed(errorCount);
                        LOG.error("Exception: {}", (Object)String.format("Erro Anexo: [%d:%d] - %s", anexo.getId().getIdEmpresa(), anexo.getId().getIdAnexo(), psrExc.toString()));
                    }
                } else {
                    conteudo.setMetadata(null);
                    anexo.setErroGed("Erro: Arquivo '" + file.getName() + "' n\u00e3o foi encontrado.");
                    Integer errorCount = anexo.getNroErrosGed();
                    if (errorCount == null) {
                        errorCount = 0;
                    }
                    errorCount = errorCount + 1;
                    anexo.setNroErrosGed(errorCount);
                    anexo.setStatusGed(TipoStatusGed.NAO_ENCONTRADO.getCode());
                }
            }
            this.updateMetadata(conteudo);
        }
        return true;
    }

    private Map<String, Integer> fillTemasMap(String conteudo) {
        Integer temaQtd;
        HashMap<String, Integer> destMap;
        String[] temasTags;
        HashMap<String, Integer> temasMap = new HashMap<String, Integer>();
        HashMap<String, String> temaOrig = new HashMap<String, String>();
        if (conteudo == null || conteudo.isEmpty()) {
            return null;
        }
        int qtdMax = 0;
        for (String itemTema : temasTags = conteudo.trim().split(" ")) {
            Integer tema;
            String temaTxt = itemTema.trim().toLowerCase();
            if (temaTxt.isEmpty() || this.stopList.contains(temaTxt) || temaTxt.length() <= 3) continue;
            if (!temaOrig.containsKey(temaTxt)) {
                temaOrig.put(temaTxt, itemTema.trim());
            }
            if ((tema = (Integer)temasMap.get(temaTxt)) == null) {
                tema = 0;
            }
            if ((tema = Integer.valueOf(tema + 1)) > qtdMax) {
                qtdMax = tema;
            }
            temasMap.put(temaTxt, tema);
        }
        if (qtdMax > 2) {
            destMap = new HashMap<String, Integer>();
            for (String temaKey : temasMap.keySet()) {
                temaQtd = (Integer)temasMap.get(temaKey);
                if (temaQtd < 2) continue;
                destMap.put((String)temaOrig.get(temaKey), temaQtd);
            }
            return destMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        }
        destMap = new HashMap();
        for (String temaKey : temasMap.keySet()) {
            temaQtd = (Integer)temasMap.get(temaKey);
            destMap.put((String)temaOrig.get(temaKey), temaQtd);
            if (destMap.size() < 10) continue;
            break;
        }
        return destMap;
    }

    private String extractPathAnexo(Anexo anexo) {
        String resourcePath = this.getRefCodeByName(anexo.getId().getIdEmpresa(), TipoRefCode.INFRA_PATH_GERAL);
        StringBuilder outPath = new StringBuilder();
        outPath.append(resourcePath);
        if (anexo.getRepoPath() != null) {
            String[] pathValues;
            for (String pathVal : pathValues = anexo.getRepoPath().split("/")) {
                if (outPath.length() > 0) {
                    outPath.append(File.separator);
                }
                outPath.append(pathVal);
            }
        }
        if (outPath.length() > 0) {
            outPath.append(File.separator);
        }
        if (anexo.getUuid() != null) {
            outPath.append(anexo.getUuid()).append(".").append(anexo.getExtensao());
        }
        return outPath.toString();
    }

    private Anexo updateMetadata(AnexoConteudo conteudo) {
        Anexo updated = this.gedService.updateMetadata(conteudo, Boolean.valueOf(false));
        if (updated != null) {
            if (conteudo.getAnexo().getModulo().equals(TipoModulo.CORRESPONDENCIAS.getSigla())) {
                // empty if block
            }
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Erro atualizando GED, conte\u00fado incorreto ou inv\u00e1lido.");
        }
        return conteudo.getAnexo();
    }
}

