/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.ged.business;

import br.com.oti.gesconsys.beans.core.RefCode;
import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.ged.AnexoIdVO;
import br.com.oti.gesconsys.beans.ged.AnexoPK;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.AuthLogin;
import br.com.oti.gesconsys.ged.beans.TipoStatusGed;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.net.ssl.SSLException;
import org.apache.tika.Tika;
import org.apache.tika.metadata.Metadata;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

@Component
@EnableScheduling
public class TikaServerExtractor {
    private static Logger logger = LoggerFactory.getLogger(TikaServerExtractor.class);
    WebClient webClient;
    TaskScheduler scheduler;
    private List<RefCode> refCodes;
    private List<AnexoIdVO> processing;
    @Autowired
    private Environment env;
    private String tokenJwt;
    Runnable refreshTokenTask = () -> {
        try {
            this.refreshToken();
        }
        catch (Exception e) {
            logger.error("exc", (Throwable)e);
        }
    };
    Runnable processRepo = () -> {
        try {
            if (this.processing == null || this.processing.isEmpty()) {
                logger.debug("Processando Reposit\u00f3rio...");
                this.processing = this.findAnexosProcessar(Boolean.valueOf(false));
                if (this.extractTikaContent().booleanValue()) {
                    this.processing.clear();
                }
                return;
            }
            logger.debug("Reposit\u00f3rio em processamento, aguardando pr\u00f3xima janela..");
        }
        catch (Exception e) {
            logger.error("exc: {}", (Throwable)e);
        }
    };

    public TikaServerExtractor(TaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    @PostConstruct
    public void init() {
        logger.debug("Inicializando TikaExtractor...");
        try {
            SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            HttpClient httpClient = HttpClient.create().secure(t -> t.sslContext(sslContext));
            this.webClient = WebClient.builder().baseUrl(this.env.getProperty("gescon.server.api-url")).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build();
            this.processing = new ArrayList();
            this.refreshToken();
            this.prepareCronjobs();
        }
        catch (SSLException exc) {
            logger.error("sslExc", (Throwable)exc);
            return;
        }
    }

    private void prepareCronjobs() {
        this.scheduler.schedule(this.refreshTokenTask, (Trigger)new CronTrigger("0 0 * * * *"));
        this.scheduler.schedule(this.processRepo, (Trigger)new CronTrigger("0/30 * * * * *"));
    }

    public String refreshToken() {
        logger.debug("executando refreshToken...");
        AuthLogin authPayload = new AuthLogin();
        authPayload.setUserName(this.env.getProperty("gescon.scheduler.user-name"));
        authPayload.setPassword("scheduler.passwd#[NOOP]");
        WebClient.ResponseSpec response = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/auth", new Object[0])).header("X-FROM-MICROSERVICE", new String[]{"SCHEDULER"})).bodyValue((Object)authPayload).retrieve();
        Map authData = (Map)response.bodyToMono(Map.class).block();
        this.tokenJwt = (String)authData.get("token");
        return this.tokenJwt;
    }

    private void fillRefCodes(String tokenJwt) {
        this.refCodes = new ArrayList();
        List empresasData = (List)this.webClient.get().uri("/empresas/all", new Object[0]).headers(h -> h.setBearerAuth(tokenJwt)).retrieve().bodyToFlux(Empresa.class).collectList().block(Duration.ofSeconds(10L));
        for (Empresa empresa : empresasData) {
            List refCodesData = (List)this.webClient.get().uri("/core/refCodes/" + empresa.getSigla(), new Object[0]).headers(h -> h.setBearerAuth(tokenJwt)).header("X-FROM-MICROSERVICE", new String[]{"SCHEDULER"}).retrieve().bodyToFlux(RefCode.class).collectList().block(Duration.ofSeconds(10L));
            if (refCodesData == null || refCodesData.isEmpty()) continue;
            this.refCodes.addAll(refCodesData);
        }
    }

    private String getRefCodeByName(Integer idEmpresa, TipoRefCode tipoRefCode) {
        for (RefCode refCode : this.refCodes) {
            if (idEmpresa == null && refCode.getIdEmpresa() != null || !(idEmpresa != null ? refCode.getIdEmpresa() != null && idEmpresa.equals(refCode.getIdEmpresa()) && refCode.getRefName().equals(tipoRefCode.getRefName()) : refCode.getRefName().equals(tipoRefCode.getRefName()))) continue;
            return refCode.getRefValue();
        }
        return null;
    }

    private List<AnexoIdVO> findAnexosProcessar(Boolean reprocessar) {
        logger.debug("executando findAnexosProcessar({})...", (Object)reprocessar);
        return (List)this.webClient.get().uri("/ged/processar/" + reprocessar.toString(), new Object[0]).headers(h -> h.setBearerAuth(this.tokenJwt)).retrieve().bodyToFlux(AnexoIdVO.class).collectList().block();
    }

    private Anexo getAnexo(String empresa, Integer idAnexo) {
        return (Anexo)this.webClient.get().uri(uriBuilder -> uriBuilder.path("/ged/{idEmpresa}/{idAnexo}").build(new Object[]{empresa, idAnexo})).headers(h -> h.setBearerAuth(this.tokenJwt)).retrieve().bodyToMono(Anexo.class).block();
    }

    public Boolean extractTikaContent() {
        this.fillRefCodes(this.tokenJwt);
        ArrayList<AnexoPK> result = new ArrayList<AnexoPK>();
        ObjectMapper jsonMapper = new ObjectMapper();
        jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        jsonMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        Integer tam50Mb = 0x3200000;
        LinkedHashMap<String, String> metadataMap = new LinkedHashMap<String, String>();
        boolean process = false;
        if (this.processing.isEmpty()) {
            logger.debug("N\u00e3o h\u00e1 anexos para processar, reprocessando itens com erro...");
            return false;
        }
        result.clear();
        Tika tika = new Tika();
        for (AnexoIdVO anxIte : this.processing) {
            Anexo anexo = this.getAnexo(anxIte.getEmpresa(), anxIte.getIdAnexo());
            process = true;
            if (anexo.getTamanho() > tam50Mb) {
                logger.debug("anexo({}:{}) > 50MB, ignorando...", (Object)anexo.getId().getIdEmpresa(), (Object)anexo.getId().getIdAnexo());
                anexo.setMetadata(null);
                anexo.setErroGed("Ignorado: Tamanho arquivo acima esperado.");
                errorCount = anexo.getNroErrosGed();
                if (errorCount == null) {
                    errorCount = 0;
                }
                errorCount = errorCount + 1;
                anexo.setNroErrosGed(errorCount);
                if (errorCount <= 1000) {
                    anexo.setStatusGed(TipoStatusGed.ERRO_PROCESSAMENTO.getCode());
                } else {
                    anexo.setStatusGed(TipoStatusGed.NAO_ENCONTRADO.getCode());
                }
                process = false;
            } else if (anexo.getExtensao().equals("zip") || anexo.getExtensao().equals("rar") || anexo.getExtensao().equals("7z") || anexo.getExtensao().equals("tar")) {
                logger.debug("anexo({}:{}), compactado, ignorando...", (Object)anexo.getId().getIdEmpresa(), (Object)anexo.getId().getIdAnexo());
                anexo.setMetadata(null);
                anexo.setErroGed("Ignorado: Arquivos compactados s\u00e3o ignorados.");
                errorCount = anexo.getNroErrosGed();
                if (errorCount == null) {
                    errorCount = 0;
                }
                errorCount = errorCount + 1;
                anexo.setNroErrosGed(errorCount);
                if (errorCount <= 1000) {
                    anexo.setStatusGed(TipoStatusGed.ERRO_PROCESSAMENTO.getCode());
                } else {
                    anexo.setStatusGed(TipoStatusGed.NAO_ENCONTRADO.getCode());
                }
                process = false;
            }
            if (process) {
                logger.debug("Extraindo metadados, Anexo[ {} , {} ]", (Object)anexo.getId().getIdEmpresa(), (Object)anexo.getId().getIdAnexo());
                File file = new File(this.extractPathAnexo(anexo));
                if (file.exists()) {
                    try (FileInputStream istream = new FileInputStream(file);){
                        Metadata meta = new Metadata();
                        String handler = tika.parseToString((InputStream)istream, meta);
                        metadataMap.clear();
                        for (String name : meta.names()) {
                            metadataMap.put(name, meta.get(name));
                        }
                        anexo.setMetadata(jsonMapper.writeValueAsString(metadataMap));
                        anexo.setConteudo(handler.toString());
                        anexo.setDatHorExtracao(LocalDateTime.now());
                        logger.debug("Anexo [id:{}], conteudo.length={}", (Object)anexo.getId(), (Object)anexo.getConteudo().length());
                        result.add(anexo.getId());
                    }
                    catch (Exception psrExc) {
                        anexo.setMetadata(null);
                        String erroGed = psrExc.getMessage();
                        if (erroGed != null && erroGed.length() > 140) {
                            erroGed = erroGed.substring(0, 140);
                        }
                        anexo.setErroGed("Erro:" + erroGed);
                        Integer errorCount = anexo.getNroErrosGed();
                        if (errorCount == null) {
                            errorCount = 0;
                        }
                        errorCount = errorCount + 1;
                        anexo.setNroErrosGed(errorCount);
                        logger.error("Exception: {}", (Object)String.format("Erro Anexo: [%d:%d] - %s", anexo.getId().getIdEmpresa(), anexo.getId().getIdAnexo(), psrExc.toString()));
                    }
                } else {
                    anexo.setMetadata(null);
                    anexo.setErroGed("Erro: Arquivo '" + file.getName() + "' n\u00e3o foi encontrado.");
                    Integer errorCount = anexo.getNroErrosGed();
                    if (errorCount == null) {
                        errorCount = 0;
                    }
                    errorCount = errorCount + 1;
                    anexo.setNroErrosGed(errorCount);
                    anexo.setStatusGed(TipoStatusGed.NAO_ENCONTRADO.getCode());
                }
            }
            this.updateMetadata(anexo);
        }
        return true;
    }

    private String extractPathAnexo(Anexo anexo) {
        String resourcePath = this.getRefCodeByName(anexo.getId().getIdEmpresa(), TipoRefCode.INFRA_PATH_GERAL);
        StringBuilder outPath = new StringBuilder();
        outPath.append(resourcePath);
        if (anexo.getRepoPath() != null) {
            String[] pathValues;
            for (String pathVal : pathValues = anexo.getRepoPath().split("/")) {
                if (outPath.length() > 0) {
                    outPath.append(File.separator);
                }
                outPath.append(pathVal);
            }
        }
        if (outPath.length() > 0) {
            outPath.append(File.separator);
        }
        if (anexo.getUuid() != null) {
            outPath.append(anexo.getUuid()).append(".").append(anexo.getExtensao());
        }
        return outPath.toString();
    }

    private String updateMetadata(Anexo anexo) {
        String callResult = (String)((WebClient.RequestBodySpec)this.webClient.post().uri("/ged/metadata/", new Object[0])).body((Publisher)Mono.just((Object)anexo), Anexo.class).headers(h -> h.setBearerAuth(this.tokenJwt)).retrieve().bodyToMono(String.class).block();
        logger.debug("updateMetadata.result = {}", (Object)callResult);
        return callResult;
    }
}

