<!DOCTYPE HTML>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8"/>
    <style>
        @font-face {
            font-family: "Aptos Display";
            src: url("AptosDisplay.woff2") format("woff2");
        }
        @font-face {
            font-family: "Aptos";
            src: url("Aptos.woff2") format("woff2");
        }
        body {
            font-family: "Aptos", sans-serif;
        }
    </style>
</head>
<body>
    <#if (proximoAprovador)?? && (!ultimoAprovador?? || (ultimoAprovador?? && ultimoAprovador.status != 2))>
        Prezado(a) ${proximoAprovador.responsavel.nome},<br/><br/>
    <#else>
        <#if (gestorAreaResposta)??>
            Prezado(a) ${gestorAreaResposta.nome},<br/><br/>
        <#elseif (correspondencia.responsavelArea)??>
            Prezado ${correspondencia.responsavelArea.nome},<br/><br/>
        </#if>
    </#if>

    <table>
        <tr>
            <td>
                <#if ((novoAprovador)?? || (proximoAprovador)??) && (!ultimoAprovador?? || (ultimoAprovador?? && ultimoAprovador.status != 2))>
                    Há pendência(s) de aprovação na correspondência:
                <#elseif ultimoAprovador?? && ultimoAprovador.status == 2>
                	Correspondência reprovada.
                <#else>
                    Correspondência aprovada por todos, liberado para protocolo.
                </#if>
                <br/><br/>
            </td>
        </tr>
    </table>

    <table style="border: 1px solid gray; border-collapse: collapse; width: 600px;">
        <tr><th colspan="2" style="background-color:#ececec;">Correspondência</th></tr>

        <#if (empresa.sigla)??>
        <tr>
            <td style="font-weight:bold;">Empresa:</td>
            <td>${empresa.sigla}</td>
        </tr>
        </#if>

        <tr>
            <td style="font-weight:bold;">Área responsável:</td>
            <td>
                ${(areaResposta.sigla)!''}
                <#if (areaResposta.sigla)??> - </#if>
                ${(areaResposta.descricao)!''}&nbsp;
                <#if (correspondencia.responsavel)??> - ${correspondencia.responsavel.nome!}</#if>
            </td>
        </tr>

        <#if correspondencia.datRecebimento??>
        <tr>
            <td style="font-weight:bold;">
                <#if correspondencia.tipoCorrespondencia.classe == "COR">
                    Data de recebimento:
                <#else>
                    Data de envio:
                </#if>
            </td>
            <td>${correspondencia.datRecebimento.format("dd/MM/yyyy")}</td>
        </tr>
        </#if>

        <#if (correspondencia.entidade.nome)??>
        <tr>
            <td style="font-weight:bold;">Entidade/remetente:</td>
            <td>${correspondencia.entidade.nome}</td>
        </tr>
        </#if>

        <#if correspondencia.processoInterno??>
        <tr>
            <td style="font-weight:bold;">Processo interno:</td>
            <td>
                ${correspondencia.processoInterno.nroProcessoInterno!'.'} -
                <#if (correspondencia.processoInterno.tema)??>
                    ${correspondencia.processoInterno.tema.descricao!'.'}
                </#if>
            </td>
        </tr>
        </#if>

        <#if correspondencia.observacao??>
        <tr>
            <td style="font-weight:bold;">Descrição:</td>
            <td>${correspondencia.observacao}</td>
        </tr>
        </#if>

        <#if externalLink??>
        <tr>
            <td style="font-weight:bold;">Link:</td>
            <td>
                <a href="${externalLink}">
                    ${correspondencia.id.idCorrespondencia?string("000000")}
                </a>
            </td>
        </tr>
        </#if>

        <#if correspondencia.prazoInterno??>
        <tr>
            <td style="font-weight:bold;">Prazo interno:</td>
            <td>${correspondencia.prazoInterno} dias</td>
        </tr>
        </#if>

        <#if correspondencia.prazoOficio??>
        <tr>
            <td style="font-weight:bold;">Prazo fatal:</td>
            <td>${correspondencia.prazoOficio} dias</td>
        </tr>
        </#if>

        <#if correspondencia.datFinalProtocolo??>
        <tr>
            <td style="font-weight:bold;">Data fatal:</td>
            <td>${correspondencia.datFinalProtocolo.format("dd/MM/yyyy")}</td>
        </tr>
        </#if>

        <#if correspondencia.nroMinuta??>
        <tr>
            <td style="font-weight:bold;">Numeração da minuta:</td>
            <td>${correspondencia.nroMinuta}</td>
        </tr>
        </#if>


        <#if correspondencia.descricaoHistorico??>
        <tr>
            <td style="font-weight:bold;">Descrição documento:</td>
            <td>${correspondencia.descricaoHistorico}</td>
        </tr>
        </#if>

        <#if correspondencia.observacaoResposta??>
        <tr>
            <td style="font-weight:bold;">Observação resposta:</td>
            <td>${correspondencia.observacaoResposta}</td>
        </tr>
        </#if>

        <#if revisoes??>
        <tr>
            <td style="font-weight:bold;">Encaminhamentos:</td>
            <td>&nbsp;</td>
        </tr>
        <#list revisoes as revisao>
        <tr>
            <td>&nbsp;</td>
            <td>
                <span>${revisao.usuario.nome}: ${revisao.descricao}</span>
            </td>
        </tr>
        </#list>
        </#if>
    </table>

    <br/>

    <table style="border: 1px solid gray; border-collapse: collapse; width: 600px;">
        <tr><th colspan="2" style="background-color:#ececec;">Fluxo de Aprovação</th></tr>

        <#if (novoAprovador)??>
        <tr>
            <td style="font-weight:bold;">Novo aprovador:</td>
            <td>${novoAprovador.responsavel.nome}</td>
        </tr>
        </#if>
        
        <#if (proximoAprovador)?? && (!ultimoAprovador?? || (ultimoAprovador?? && ultimoAprovador.status != 2))>
        <tr>
            <td style="font-weight:bold;">Aprovador atual:</td>
            <td>${proximoAprovador.responsavel.nome}</td>
        </tr>
        </#if>

        <#if (ultimoAprovador)??>
        <tr>
            <td style="font-weight:bold;">Última ação:</td>
            <#if ultimoAprovador.status?? && ultimoAprovador.status == 1>
                <td>${ultimoAprovador.responsavel.nome}, aprovado em ${ultimoAprovador.datHorAprovacao.format("dd/MM/yyyy HH:mm")}</td>
            <#elseif ultimoAprovador.status?? && ultimoAprovador.status == 2>
                <td>${ultimoAprovador.responsavel.nome}, reprovado em ${ultimoAprovador.datHorReprovacao.format("dd/MM/yyyy HH:mm")}</td>
            </#if>
        </tr>
        </#if>

        <#if (descricaoAprovaReprova)?? >
        <tr>
            <td style="font-weight:bold;">Descrição ação:</td>
            <td>${descricaoAprovaReprova}</td>
        </tr>
        </#if>
    </table>

    <br />Atenciosamente,<br/>

    <br/><br/>
    <p style="font-size: 11px; color: #848484">
        E-mail gerado automaticamente, não o responda
        <br/>
        Data/Hora: ${sysDate?string("dd/MM/yyyy HH:mm")}
    </p>
</body>
</html>